function coords_out = rot3d(coords_in, dims, angs)

    angs =  angs.*dims;

    rotx = [1,0,0;...
        0,cos(angs(1)), -sin(angs(1));...
        0,sin(angs(1)),cos(angs(1))];
    
    roty = [cos(angs(2)), 0, sin(angs(2));...
        0,1,0;...
        -sin(angs(2)), 0, cos(angs(2))];

    rotz = [cos(angs(3)), -sin(angs(3)), 0;...
        sin(angs(3)), cos(angs(3)), 0;...
        0,0,1];

    coords_out = coords_in*rotx*roty*rotz;

end