function [vars, CoM] = px_variance(Image, varargin)
%%

sz = size(Image);
Ndims = length(sz);

if ~isempty(varargin)
    [bg, Image_nobg] = estimatebg(Image, varargin{1});
else
    [bg, Image_nobg] = estimatebg(Image);
end

% Image_nobg = Image;
Image_nobg = Image_nobg./sum(Image_nobg,'all');

CoM = zeros(1,Ndims);
vars = zeros(1,Ndims);

if Ndims == 2

    x1 = (-floor(sz(1)/2):ceil(sz(1)/2-1));
    y1 = (-floor(sz(2)/2):ceil(sz(2)/2-1));
    [id(1,:,:),id(2,:,:)] = meshgrid(x1, y1);

    for ii = 1:Ndims
        id1 = squeeze(id(ii,:,:));
        CoM(ii) = sum(id1.*Image_nobg, 'all');
        vars(ii) = mean((Image.*(id1 - CoM(ii)).^2),'all');
    end

    CoM = CoM+sz/2;

elseif Ndims==3

    x1 = (-floor(sz(1)/2):ceil(sz(1)/2-1));
    y1 = (-floor(sz(2)/2):ceil(sz(2)/2-1));
    z1 = (-floor(sz(3)/2):ceil(sz(3)/2-1));
    [id(1,:,:,:),id(2,:,:,:),id(3,:,:,:)] = meshgrid(x1, y1, z1);

    for ii = 1:Ndims
        id1 = squeeze(id(ii,:,:,:));
        CoM(ii) = sum(id1.*Image_nobg, 'all');
        vars(ii) = mean((Image.*(id1 - CoM(ii)).^2),'all');
    end

    CoM = CoM()+sz/2;

end


end