function imout = imrot(Image, rotmat, CoM)
%%

sz = size(Image);

Npad = ceil(norm(sz) - min(sz));

Npad = 1;
imPad = zeros(size(Image)+Npad*2);
imPad(Npad+1:end-Npad,Npad+1:end-Npad,Npad+1:end-Npad) = Image;

sz = size(imPad);

x1 = (-floor(sz(2)/2):ceil(sz(2)/2-1));
y1 = (-floor(sz(1)/2):ceil(sz(1)/2-1));
z1 = (-floor(sz(3)/2):ceil(sz(3)/2-1));
[xx,yy,zz] = meshgrid(x1, y1, z1);

ReCoords = (rotmat^(-1)*[xx(:), yy(:), zz(:)]')'+CoM+Npad;
%%

ReCoords = ReCoords(:,[2,1,3]);         % Go from [x,y,z] to [rows, columns, layers]
floorCoords = min(max(floor(ReCoords),1), sz);
ceilCoords = min(max(ceil(ReCoords),1), sz);
modCoords = mod(ReCoords,1);
remmodCoords = 1-modCoords;

intCoords = [sub2ind(size(imPad),floorCoords(:,1), floorCoords(:,2), floorCoords(:,3)),...
    sub2ind(size(imPad),floorCoords(:,1), floorCoords(:,2), ceilCoords(:,3)),...
    sub2ind(size(imPad),floorCoords(:,1), ceilCoords(:,2), floorCoords(:,3)),...
    sub2ind(size(imPad),floorCoords(:,1), ceilCoords(:,2), ceilCoords(:,3)),...
    sub2ind(size(imPad),ceilCoords(:,1), floorCoords(:,2), floorCoords(:,3)),...
    sub2ind(size(imPad),ceilCoords(:,1), floorCoords(:,2), ceilCoords(:,3)),...
    sub2ind(size(imPad),ceilCoords(:,1), ceilCoords(:,2), floorCoords(:,3)),...
    sub2ind(size(imPad),ceilCoords(:,1), ceilCoords(:,2), ceilCoords(:,3))];

CoordVals = [remmodCoords(:,1).* remmodCoords(:,2).* remmodCoords(:,3),...
    remmodCoords(:,1).* remmodCoords(:,2).* modCoords(:,3),...
    remmodCoords(:,1).* modCoords(:,2).* remmodCoords(:,3),...
    remmodCoords(:,1).* modCoords(:,2).* modCoords(:,3),...
    modCoords(:,1).* remmodCoords(:,2).* remmodCoords(:,3),...
    modCoords(:,1).* remmodCoords(:,2).* modCoords(:,3),...
    modCoords(:,1).* modCoords(:,2).* remmodCoords(:,3),...
    modCoords(:,1).* modCoords(:,2).* modCoords(:,3)];


newvals = sum(imPad(intCoords).*CoordVals,2);

sz = size(imPad);
[xx,yy,zz] = meshgrid(1:sz(1), 1:sz(2), 1:sz(3));
% ind = sub2ind(sz,yy,xx,zz);
ind = sub2ind(sz,xx,yy,zz);

newvals = newvals(ind);

imout = reshape(newvals, sz(2), sz(1), sz(3));
imout = imout(1+Npad:end-Npad,1+Npad:end-Npad,1+Npad:end-Npad);
% imout = permute(imout,[2,1,3]);


end
