function [ROI, idmin] = getROI(Image, ind, dx)
%%
sz = size(Image);
Ndims = length(sz);

if Ndims==2
    [idx, idy] = ind2sub(sz, ind);
    dx = min([[idx, idy]-1, sz-[idx,idy],dx]);
    x1 = max(idx-dx,1):min(idx+dx,sz(1));
    y1 = max(idy-dx,1):min(idy+dx, sz(2));

    ROI = Image(x1,y1);
    idmin = [min(x1), min(y1)]-1;
elseif Ndims==3
    [idx, idy, idz] = ind2sub(sz, ind);
    dx = min([[idx, idy, idx]-1, sz-[idx,idy, idz],dx]);
    x1 = max(idx-dx,1):min(idx+dx,sz(1));
    y1 = max(idy-dx,1):min(idy+dx, sz(2));
    z1 = max(idz-dx,1):min(idz+dx, sz(3));

    ROI = Image(x1,y1,z1);
    idmin = [min(x1), min(y1), min(z1)]-1;
end