function [RegInitS, RegAS, RawS, shiftSave, StackSaveS] = fRegPar(sz, ll, Nlocs, col,  Nsegs, ps, Stack, parSegs, init, Nits, shiftCol, dxPeak, shiftSave, maxps)
%%

LS = parSegs(ps):(parSegs(ps+1)-1);
% pause(2)
% dipstart
RegAS = zeros(sz(1), sz(2), sz(3), max(LS));
RegInitS = zeros(sz(1), sz(2), sz(3), max(LS));
RawS = cell(max(LS),1);
StackSaveS = cell(max(LS),1);
%%
if ps==maxps
msg = fprintf('Probe %d/%d, %s, %.2f %%', ll, Nlocs, col, round((0/(LS(end)-LS(1)+1))*100,2));
end

for ss = LS - min(LS) + 1


% if ps==maxps
%     'h'
%     fprintf(repmat('\b',1,msg+17))
%     msg = fprintf('Probe %d/%d, %s, %.2f %%', ll, Nlocs, col, round((ss/(LS(end)-LS(1)+1))*100,2));
% end

Raw = struct;

Nims = size(Stack{ss},4);
if ndims(Stack{ss})<3
    continue
end

switch init
    case 'S1'
        % RegC = Stack(:,:,:,seg(1));
        RegC = Stack{ss}(:,:,:,1);
        RegC = RegC./sum(RegC, 'all');
    case 'Sum'
        % RegC = sum(Stack(:,:,:,seg),4)./Nsegs;
        RegC = sum(Stack{ss},4)./Nsegs;
        RegC = RegC./sum(RegC, 'all');
    case 'Empty'
        RegC = zeros(sz(1),sz(2),sz(3));
end

RegC = CentreIm(RegC);

RegInitS(:,:,:,ss) = RegC;
sz = size(RegC);

% if col==string(shiftCol) || string(shiftCol)=="Both"
%     its = 1:Nits;
% else
%     its = Nits;
% end

for ii = 1:Nits
    
    RegA = zeros(sz);

    StackSave = zeros(sz(1), sz(2), sz(3),Nims);
    rawFitPar = zeros(Nims,3);
    rawFitRad = zeros(Nims,3);

    % for cc = seg - min(seg) + 1
    for cc = 1:Nims
        
        if ps==maxps && ii==1
            prog = ((ss-1)/(LS(end)-LS(1)+1))*100+100/length(LS)*cc/Nims;
        'h'
        fprintf(repmat('\b',1,msg+17))
        msg = fprintf('Probe %d/%d, %s, %.2f %%', ll, Nlocs, col, round(prog,2));
        end

        % idxIm = cc + min(seg) - 1;
        idxIm = cc;
    
        Im = Stack{ss}(:,:,:,idxIm);
        Im = Im./sum(Im, 'all');

        ImS = Im;
        
        if col==string(shiftCol) || string(shiftCol)=="Both"
            xcor = im2mat(crosscorrelation(ImS, RegC));
            % [Raw.peakVal(cc),ind] = max(xcor,[],'all');
            [Raw.peakVal(cc),ind] = max(xcor./sum(xcor,'all'),[],'all');
            [peakROI, idmin] = getROI(xcor, ind, dxPeak);
            if numel(peakROI) == 1
                [peakCC(1),peakCC(2), peakCC(3)] = ind2sub(size(xcor),ind);
                dshift = floor(peakCC - size(xcor)/2);
            else
                [~,dshift] = CentreIm(peakROI);
                dshift = dshift + idmin - size(xcor)/2;
            end

            dshift = dshift([2,1,3]);
            shiftSave(ss,cc,:) = dshift;
        else
            dshift = squeeze(shiftSave(ss,cc,:));
        end

        ImS = max(im2mat(shift(ImS,dshift)),0);

        % RegC = RegC*(1-1/Nims) + ImS/Nims;      % Update template after every image
        RegA = RegA + ImS;
    
        if ii==Nits
            StackSave(:,:,:,cc) = ImS;

        end
    end

    RegC = RegA./sum(RegA, 'all');
    RegC = CentreIm(RegC);

end

RegA = CentreIm(RegA);
RegA = RegA./max(RegA,[],'all');
% Raw{ps}{ss} = Raw{ps}{ss};
RegAS(:,:,:,ss) = RegA;
RawS{ss} = Raw;
StackSaveS{ss} = StackSave;
end

if ps==maxps
    fprintf('\n');
end



        
        