function [bgEst, ImOut] = estimatebg(Image, varargin)
%%
sz = size(Image);
edge = ceil(sz/6);

if ~isempty(varargin)
   
    bgEst = varargin{1};

else

     if numel(sz)==2
    
        bgEst = double(median([(median(Image(1:edge(1),1:edge(2)),'all')),...
            (median(Image(end-edge(1):end,1:edge(2)),'all')),...
            (median(Image(1:edge(1),end-edge(2):end),'all')),...
            (median(Image(end-edge(1):end,end-edge(2):end),'all'))]));
    
    elseif numel(sz)==3
    
        bgEst = double(median([(median(Image(1:edge(1),1:edge(2),1:edge(3)),'all')),...
                (median(Image(end-edge(1):end,1:edge(2),1:edge(3)),'all')),...
                (median(Image(1:edge(1),end-edge(2):end,1:edge(3)),'all')),...
                (median(Image(end-edge(1):end,end-edge(2):end,1:edge(3)),'all')),...
                (median(Image(1:edge(1),1:edge(2),end-edge(3):end),'all')),...
                (median(Image(end-edge(1):end,1:edge(2),end-edge(3):end),'all')),...
                (median(Image(1:edge(1),end-edge(2):end,end-edge(3):end),'all')),...
                (median(Image(end-edge(1):end,end-edge(2):end,end-edge(3):end),'all'))]));
    
    else
        disp("Please input a 2D or 3D Image to estimate the background")
        return;
    end

end

if ~isnan(bgEst)
    if bgEst>1
        ImOut = max(Image - (bgEst+3*sqrt(bgEst)),0);
    else
        ImOut = max(Image - (bgEst),0);
    end
else
    ImOut = Image;
end

end