function [imout, scaling] = ellip2sph(Image, rot, toSph, varargin)
%%
Ndims = length(size(Image));
sz = size(Image);

bg = estimatebg(Image);
if isnan(bg)
    bg=0;
end
if rot
    [rotmat, CoM, ~] = PSP_Align(Image, bg);
    Image = imrot(Image, rotmat, CoM);
end

[vars, CoM] = px_variance(Image, bg);
vars = vars([2,1,3]);
vars = sqrt(vars);
%%
if numel(varargin)>0
    CoM = varargin{1};
end

if numel(varargin)>1
    scaling = varargin{2};
else
    switch toSph
        case "SameVol"
        scaling = vars./mean(vars);
        case "SameMinor"
        scaling = vars./min(vars);
    end
end

if Ndims==2
    
    Npad = 1;
    imPad = zeros(size(Image)+Npad*2);
    imPad(Npad+1:end-Npad,Npad+1:end-Npad) = Image;
    
    sz = size(imPad);
    
    x1 = -floor(sz(1)/2):ceil(sz(1)/2-1);
    y1 = -floor(sz(2)/2):ceil(sz(2)/2-1);
    [xx,yy] = meshgrid(x1, y1);
    
    ReCoords = ([xx(:), yy(:)].*(scaling))+CoM+Npad;
    %%
    for ii = 1:2
    
        floorCoords = min(max(floor(ReCoords),1), sz);
        ceilCoords = min(max(ceil(ReCoords),1), sz);
        modCoords = mod(ReCoords,1);
        remmodCoords = 1-modCoords;
    end
    
    intCoords = [sub2ind(size(imPad),floorCoords(:,1), floorCoords(:,2)),...
        sub2ind(size(imPad),floorCoords(:,1), ceilCoords(:,2)),...
        sub2ind(size(imPad),ceilCoords(:,1), floorCoords(:,2)),...
        sub2ind(size(imPad),ceilCoords(:,1), ceilCoords(:,2))];
    
    
    CoordVals = [remmodCoords(:,1).* remmodCoords(:,2),...
        remmodCoords(:,1).* modCoords(:,2),...
        modCoords(:,1).* remmodCoords(:,2),...
        modCoords(:,1).* modCoords(:,2)];
    
    
    newvals = sum(imPad(intCoords).*CoordVals,2);
    
    sz = size(imPad);
    
    imout = reshape(newvals, sz(2), sz(1));
    imout = permute(imout,[2,1]);

elseif Ndims==3
    Npad = 1;
    imPad = zeros(size(Image)+Npad*2);
    imPad(Npad+1:end-Npad,Npad+1:end-Npad,Npad+1:end-Npad) = Image;

    sz = size(imPad);
    
    x1 = -floor(sz(1)/2):ceil(sz(1)/2-1);
    y1 = -floor(sz(2)/2):ceil(sz(2)/2-1);
    z1 = -floor(sz(3)/2):ceil(sz(3)/2-1);
    [xx,yy,zz] = meshgrid(x1, y1, z1);
    
    ReCoords = ([xx(:), yy(:), zz(:)].*(scaling))+CoM+Npad;
    %%
    for ii = 1:3
    
        floorCoords = min(max(floor(ReCoords),1), sz);
        ceilCoords = min(max(ceil(ReCoords),1), sz);
        modCoords = mod(ReCoords,1);
        remmodCoords = 1-modCoords;
    end
    
    intCoords = [sub2ind(size(imPad),floorCoords(:,1), floorCoords(:,2), floorCoords(:,3)),...
        sub2ind(size(imPad),floorCoords(:,1), floorCoords(:,2), ceilCoords(:,3)),...
        sub2ind(size(imPad),floorCoords(:,1), ceilCoords(:,2), floorCoords(:,3)),...
        sub2ind(size(imPad),floorCoords(:,1), ceilCoords(:,2), ceilCoords(:,3)),...
        sub2ind(size(imPad),ceilCoords(:,1), floorCoords(:,2), floorCoords(:,3)),...
        sub2ind(size(imPad),ceilCoords(:,1), floorCoords(:,2), ceilCoords(:,3)),...
        sub2ind(size(imPad),ceilCoords(:,1), ceilCoords(:,2), floorCoords(:,3)),...
        sub2ind(size(imPad),ceilCoords(:,1), ceilCoords(:,2), ceilCoords(:,3))];
    
    
    CoordVals = [remmodCoords(:,1).* remmodCoords(:,2).* remmodCoords(:,3),...
        remmodCoords(:,1).* remmodCoords(:,2).* modCoords(:,3),...
        remmodCoords(:,1).* modCoords(:,2).* remmodCoords(:,3),...
        remmodCoords(:,1).* modCoords(:,2).* modCoords(:,3),...
        modCoords(:,1).* remmodCoords(:,2).* remmodCoords(:,3),...
        modCoords(:,1).* remmodCoords(:,2).* modCoords(:,3),...
        modCoords(:,1).* modCoords(:,2).* remmodCoords(:,3),...
        modCoords(:,1).* modCoords(:,2).* modCoords(:,3)];
    
    
    newvals = sum(imPad(intCoords).*CoordVals,2);
    
    sz = size(imPad);
    
    imout = reshape(newvals, sz(2), sz(1), sz(3));
    imout = permute(imout,[2,1,3]);
    imout = imout(1+Npad:end-Npad,1+Npad:end-Npad,1+Npad:end-Npad);
    % imout = CentreIm(imout);
end

% figure(); orthosliceViewer(imout);

end