function coords_out = car2sph(coords_in)
%%
    xx = coords_in(:,1);
    yy = coords_in(:,2);
    zz = coords_in(:,3);

    rxy =   hypot(xx,yy);
    rr =    hypot(rxy, zz);

    theta =         atan2(rxy, zz);
    phi =           atan2(yy, xx);
    phi(phi<0) =    phi(phi<0) + 2*pi;

    coords_out = [rr, theta, phi];

end
