function [varssort, varsegs, segs, idx_vars] = PSP_VarSort(sortmet, Nsegs, varargin)
%%
switch sortmet

    case "Var"
        switch pcaCol 
            case "Orange"
                cellVarA = varargin{1};
                vars = cellVarA(:,1);
            case "Red"
                cellVarB = varargin{2};
                vars = cellVarB(:,1);
            case "Sum"
                cellVarSum = varargin{3};
                vars = cellVarSum(:,1);
        end

    case "Length"
        cellRvol = varargin{4};
        vars = cellRvol(:,1);

    case "Vol"
        cellVol = varargin{5};
        vars = cellVol';
end
%%
[varssort, idx_vars] = sort(vars);

NanOut = logical(isoutlier(varssort)+isnan(varssort));

idx_vars(NanOut) = [];
varssort(NanOut) = [];

varsegs = linspace(varssort(1), varssort(end), Nsegs+1);
varsegs(end) = Inf;

seg_mask = (varssort >= varsegs(1:end-1)) & (varssort < varsegs(2:end));

[~, cols] = find(seg_mask);
[~, segs] = unique(cols, 'first');
segs(end+1) = size(varssort,1)+1;
segs = segs-1;