%{
Check installation and path for Paraspeckle image analysis
Requires DIPImage (https://diplib.org/), Parallel Computing Toolbox, Signal Processing Toolbox


Copyright Enya Berrevoets, TU Delft, 2024
Licensed under the Apache License, Version 2.0
%}
%%
function [message] = PSP_CodeCheck()
message = strings(0,1);

%% Check programs

% DIPImage

try 
    dipstart;
    close
catch 
    message(end+1) = "Please install DIPImage.";
end


%% Check toolboxes
toolboxes = ver;

if ~any(strcmp({toolboxes.Name}, 'Parallel Computing Toolbox')) % replace with actual name
    message(end+1) = "Please install the Parallel Computing Toolbox.";
end

if ~any(strcmp({toolboxes.Name}, 'Signal Processing Toolbox')) % replace with actual name
    message(end+1) = "Please install the Signal Processing Toolbox.";
end


%% 
if ~isempty(message)
    message(end+1) = 'Execution halted';
    msgbox(message')
    return
end