function [rotmat, CoM, eigvals] = PSP_Align(Image, varargin)
%%

if ~isempty(varargin)
    [~, Image_nobg] = estimatebg(Image, varargin{1});
else
    [~, Image_nobg] = estimatebg(Image);
end

%%

sz = size(Image);
Ndims = length(sz);

Image_nobg = Image_nobg./sum(Image_nobg,'all');

covmat = zeros(Ndims, Ndims);

if Ndims == 2

    x1 = (-floor(sz(1)/2):ceil(sz(1)/2-1));
    y1 = (-floor(sz(2)/2):ceil(sz(2)/2-1));
    [id(1,:,:),id(2,:,:)] = meshgrid(x1, y1);

    CoM(1) = sum(squeeze(id(1,:,:)).*Image_nobg, 'all');
    CoM(2) = sum(squeeze(id(2,:,:)).*Image_nobg, 'all');

    for ii = 1:Ndims
        for jj = 1:Ndims
            id1 = squeeze(id(ii,:,:));
            id2 = squeeze(id(jj,:,:));
            covmat(ii,jj) = (sum(Image_nobg.*(id1 - CoM(ii)).*(id2 - CoM(jj)),'all'));
        end
    end

    CoM = CoM([2,1]) + sz/2;
    [rotmat,eigvals] = eig(covmat);
    eigvals = diag(eigvals);

    [eigvals,sorteig] = sort(eigvals,'descend');
    rotmat = rotmat(:,sorteig);

    rotmat = rotmat([2,1],:);

elseif Ndims==3

    id = zeros([3,sz]);
    CoM = zeros(1,3);
    covmat = zeros(3,3);

    x1 = (-floor(sz(2)/2):ceil(sz(2)/2-1));
    y1 = (-floor(sz(1)/2):ceil(sz(1)/2-1));
    z1 = (-floor(sz(3)/2):ceil(sz(3)/2-1));
    [id(1,:,:,:),id(2,:,:,:),id(3,:,:,:)] = meshgrid(x1, y1, z1);
    CoM(1) = sum(squeeze(id(1,:,:,:)).*Image_nobg, 'all');      % Columns, x
    CoM(2) = sum(squeeze(id(2,:,:,:)).*Image_nobg, 'all');      % Rows, y
    CoM(3) = sum(squeeze(id(3,:,:,:)).*Image_nobg, 'all');      % Layers, z

    for ii = 1:Ndims
        for jj = 1:Ndims
            id1 = squeeze(id(ii,:,:,:));
            id2 = squeeze(id(jj,:,:,:));
            covmat(ii,jj) = (sum(Image_nobg.*(id1 - CoM(ii)).*(id2 - CoM(jj)),'all'));
        end
    end

    % covmat

    % CoM = CoM([2,1,3]) + ceil(sz/2);              % Rows, columns, layers ([y, x, z])
    CoM = CoM + ceil(sz/2);                         % Columns, rows, layers ([x, y, z])
    [eigvecs,eigvals] = eig(covmat);                 % Eigenvalues are not sorted
    [eigvals,sorteig] = sort(diag(eigvals),'descend');
    eigvecs = eigvecs(:,sorteig);

    % rotmat = rotmat(:,[2,1,3])';     % Rotate to maximise variance along y-axis (vertical axis, first dimension)
    rotmat = eigvecs';
    % Im_aligned = imrot(Image, rotmat, CoM);

end

% figure(); orthosliceViewer(Image_nobg);
% figure(); orthosliceViewer(Im_aligned);


end