function [fitrad, scaling, raddist, doublePSP, Rvol, outbox] = FitRad(Image, toSph, px, dx, sig, RF_method, check2, doublePSP, outbox, varargin)

%{

Image           Input image
toSph           How to perform ellipsoid-to-sphere [SameMinor/SameVol]
px              Pixel size [nm]
dx              Fitting precision [nm]
RF_method       Method to estimate the radius ["dropoff"/"50/50"]

varargin{1}     Scaling for ellip2sph. If not given, estimated using
                ellip2sph. 
varargin{2}     Drop-off value to determine radius, radius is then estimated
                by calculating the distance of this cut-off to the peak assuming a Gaussian
                PSF and using the input resolution. 
varargin{3}     Image resolution [nm]

varargin{4}     Single or double PSP

%}

%% 

% Image = RegA; toSph = 'SameMinor'; px = 30; dx = 1; res = sigma_psf;

sz = size(Image);

%%


%%
Rvol = [];
if numel(varargin)>0
    scaling = varargin{1};
    [ImSph, ~] = ellip2sph(Image,0,toSph, sz/2,scaling);    % Measure and rescale image ellipticity
else
    [Rvol, doublePSP, outbox] = AxesRatio(Image, 0.5, sig/px);
    if toSph=="SameMinor"
        scaling = Rvol./min(Rvol);
    elseif toSph=="SameVol"
        scaling = Rvol./mean(Rvol);
    end
    [ImSph, ~] = ellip2sph(Image,0,toSph, sz/2,scaling);    % Rescale image ellipticity
end
%%
raddist = im2mat(radialmean(ImSph));            % Radial intensity [RI] distribution, RI(R) = mean(I) on [R-1,R]
% raddist = raddist./max(raddist,[],'all');       % Normalise RI distribution
raddist = raddist./sum(raddist,'all');       % Normalise RI distribution

raddist = raddist(1:floor(min(sz/2)));

%% Find 50/50 point
switch RF_method 
    case "50/50"
        % First raddist value corresponds to point 0.5. Move to 0.

    dd1 = raddist(2)-raddist(1);
    dd2 = raddist(3) - raddist(2);
    dd = 0.5*dd1*(min(dd1/dd2,4));
    % dd = 0.5*dd1;
    raddist = [raddist(1)-dd, raddist];     
    xog = [0,0.5:length(raddist)-1];
    raddist = interp1(xog,raddist,0:dx/px:length(raddist)-1.5);

    raddist(raddist<0) = 0;

    LL = length(raddist);
    % cumdist = [0, cumsum(raddist)./sum(raddist)];
    cumdist = [cumsum(raddist)./sum(raddist)];
    
    under50 = find(cumdist<=0.5);
    over50 = find(cumdist>0.5);
    
    aa = [under50(end), cumdist(under50(end))];
    bb = [over50(1), cumdist(over50(1))];
    slope = (bb(2) - aa(2));
    cc = aa(2) - slope*aa(1);

    % fitrad = ((0.5-cc)/slope-1)*px
    fitrad = ((0.5-cc)/slope-1) + px/2;
    fitrad = fitrad*scaling;
    % xr = (0.5:LL-0.5)*px;
    % figure(); plot(xr,raddist); hold on; xline(fitrad)
    % plot(xr+px/2,cumdist(2:end))

%%
    case "meanR"

    LL = length(raddist);
    xr = (0.5:LL-0.5)*px;
    fitrad = sum(xr.*raddist)./sum(raddist);      % Start from 0.5 because raddist(R) is mean RI on interval [R-1,R]

    fitrad = fitrad*scaling;

    % figure(); plot(xr,raddist); hold on; xline(fitrad)

    case "dropoff"
%%

    if numel(varargin)>1
        cutoff = varargin{2};
    else
        cutoff = 0.95;
    end
    
    if numel(varargin)>2
        res = varargin{3};
    else
        res = 0;
    end

    %%
    xr = 1:length(raddist); 

    drop50 = max([xr(raddist>0.5),6]);                 % Find 50% drop-off value. Ensure that there are sufficient points to fit the curve
    
    radpeak = raddist(1:drop50);       % RI distribution up to 50% drop-off
    xr = (0:drop50-1)*px;              % Start indexing from 0 to avoid weird fitting due to lack of data at 0
    
    fg2 = fit(xr', radpeak', 'gauss2');     % Fit RI distribution
    xx = min(xr):dx:max(xr);
    fitrad = max(xx(fg2(xx)>cutoff*max(fg2(xx))));  % Find the coordinate of the chosen cutoff value
    fitrad = fitrad - res*sqrt(log(1/cutoff)) + px/2;      % Estimate the RI peak from this cutoff point

    fitrad = fitrad*scaling;

    % LL = length(raddist);
    % xr = (1:LL)*px;
    % figure(); plot(xr,raddist); hold on; xline(fitrad)


end

%%
% %{

if check2

%%
    im2 = Image(ceil(end/2)-1:ceil(end/2)+1,:,ceil(end/2)-1:ceil(end/2)+1);

    sum2 = im2mat(smooth(squeeze(sum(im2,[1,3]))));

    % figure(); 
    % findpeaks(sum2); 

    [Lmax,Pmax] = islocalmax(sum2);

    % figure(); findpeaks(sum2,'Annotate','extents')
    pk2 = find(Lmax);
    % pk2(pk2<3) = [];
    % pk2(pk2>3) = [];

    % figure(); plot(sum2); xline(pk2)

    % all(Pmax(Lmax)./sum2(Lmax)>0.05)

    doublePSP=1;

    if length(pk2)>1

        if length(pk2)==2 && ...
                any(abs(pk2 - sz(2)/2)<2) && ...
                (pk2(end)-pk2(1))*px>fitrad(2)

            % fitrad(2) = (pk2(end)-pk2(1))*px;
            % scaling(2) = fitrad(2)/fitrad(1);
            doublePSP=2;

        elseif length(pk2)>2 && ...
                (pk2(end)-pk2(1))/2*px>fitrad(2)

            % fitrad(2) = (pk2(end)-pk2(1))/2*px;
            % scaling(2) = fitrad(2)/fitrad(1);
            doublePSP=2;

        end
    end
end

% if numel(varargin)>0
%     if varargin{1}
%         Rvol = fitrad;
%     end
% end

% fitrad = [(pk1(end)-pk1(1))/2, (pk2(end)-pk2(1))/2, (pk3(end)-pk3(1))/2]*px;
% scaling = fitrad./min(fitrad);

% end
%}
end