function [ImS, CoMtot] = CentreIm(Image, varargin)
%%

sz = size(Image);
Ndims = length(sz);
ImS = Image./sum(Image,'all');
CoM = repelem(1,1,Ndims);
CoMtot = zeros(1,Ndims);
if Ndims == 2

    while any(abs(CoM-sz/2) >= 0.5)
        x1 = -floor(sz(1)/2):ceil(sz(1)/2-1);
        y1 = -floor(sz(2)/2):ceil(sz(2)/2-1);
        [xx,yy] = meshgrid(x1, y1);
        comx = sum(xx.*ImS, 'all');
        comy = sum(yy.*ImS, 'all');
    
        if numel(varargin)==0
            ImS = im2mat(shift(ImS, -[comx, comy]));
        end
    
        CoM = [comx, comy]+sz/2;
        CoMtot = CoMtot + [comx, comy];
    end

    CoMtot = CoMtot+sz/2;

elseif Ndims == 3

    while any(abs(CoM-sz/2) >= 0.5)
        x1 = (-floor(sz(1)/2):ceil(sz(1)/2-1));
        y1 = (-floor(sz(2)/2):ceil(sz(2)/2-1));
        z1 = (-floor(sz(3)/2):ceil(sz(3)/2-1));
        [xx,yy,zz] = meshgrid(x1, y1, z1);
        comx = sum(xx.*ImS, 'all');
        comy = sum(yy.*ImS, 'all');
        comz = sum(zz.*ImS, 'all');
    
        if numel(varargin)==0
            ImS = max(im2mat(shift(ImS, -[comx, comy, comz])),0);
        end
    
        CoM = [comx, comy, comz]+sz/2;
        CoMtot = CoMtot + [comx, comy, comz];
    end

    CoMtot = CoMtot+sz/2;

end

% figure(); orthosliceViewer(ImS);
