# Demo
IMPORTANT<br>
To run the demo, please make sure that all functions and files are on your path (right click folder --> "Add to Path")!
Store the Demo images (Demo_data) and analysis results elsewhere (not in Image_analysis (sub)folder, not in Downloads)!
Make sure all required toolboxes are installed (DIPImage (https://diplib.org/), Parallel Computing Toolbox, Signal Processing Toolbox)!

## PSP_CodeCheck
To check that everything is installed properly, run the script 'PSP_CodeCheck'.

## PSP_Rotation.m
_Running_<br>
1. Download the Demo folder. <br>
<br>
2. Set the "User input":
Define projDir as the path to the Demo folder on your device: projDir = '...\Demo'.<br>
Define locDir as the directory where you want to save the analysis data: locDir = '...\Demo_output'.<br>

headDir = 'Demo_data'.<br>
savedata = 1.<br>
runcol = [1,1,1].<br>
sellocs = 1.<br>
Npar = 2.<br>
Vthr = 0.5.<br>
pcaCol = 'Sum'.<br>
<br>
3. Run the code.<br>
<br>

_Run time_<br>

<1 min

_Output_<br>
StackA: Rotationally aligned Orange images, 4D double matrix<br>
StackB: Rotationally aligned Red images, 4D double matrix<br>
StackSum: Rotationally aligned Sum images, 4D double matrix<br>

cellVarA: Intensity variances Orange images<br>
cellVarB: Intensity variances Red images<br>
cellVarSum: Intensity variances Sum images<br>

cellIntA: Intensities Orange images<br>
cellIntB: Intensities Red images<br>

cellRvol: 50% drop-off lengths<br>
cellOutbox: Out-of-ROI images<br>
cellVol: PSP volumes<br>

## PSP_Translation.m

FOLLOW THE STEPS FOR PSP_ROTATION FIRST<br>

_Running_<br>
1. Set the "User input":<br>
Define projDir, locDir and headDir the same as in PSP_rotation:<br>
projDir = '...\Demo'.<br>
locDir = '...\Demo_output'.<br>
headDir = 'Demo_data'<br>

pcaCol = 'Sum'<br>
Colours = ["Sum","Orange", "Red"]<br>
Nsegs = 10<br>
binmet = 'AbCov'<br>
sellocs = [1]<br>
sortmet = "Length"<br>
fitcol = ["Sum"]<br>

sigma_psf = 0   <br>   
px = 30<br>
shiftCol = pcaCol<br>

savedata = 1<br>
saveims = 1<br>
rerun = 1<br>
refit = 1<br>
fitraws = 1<br>
loadStack = 1<br>

sliceplt = 0<br>
singlerawsplt = 0<br>
radintplt = 0<br>
radplt = 0<br>
rawsplt = 0<br>

Nits = 2<br>
init = 'Sum'<br>
dxPeak = 1<br>

Npar = 2<br>

RF_method = "50/50"<br>
check2 = 1<br>
scaling_cutoff = 1.5<br>
Vthr = 0.5<br>
<br>
3. Run the code.<br>
<br>

_Run time_<br>
~1 min<br>
<br>

_Output_<br>
Per colour channel:<br>
RegA: Averaged images per bin<br>
StackSave: Aligned individual images<br>
<br>
Overall:<br>
VarAReg: Intensity variance of averaged Orange images<br>
VarBReg: Intensity variance of averaged Red images<br>
Allfitrad: From averaged images, [1, N bins, N channels, 3] array with distance-to-centre along each axis<br>
Allrawrad: From individual images, {1,1} cell with [N images, 3] array with distance-to-centre along each axis<br>
DoubleOut: {1,2} cell with {1,1} cells with  [1,Nbins] binary arrays indicating whether averaged PSPs are double or out-of-ROI<br>
DoubleOutraw: {2,1} cell with {1,1} cells with [Nimages,1] binary arrays indicating whether PSPs are double or out-of-ROI<br>
ImVol: {1,1} cell with [1,Nims] array with PSP volumes in nm^3<br>
SegInts: [1,N bins,3] array with averaged bin intensities<br>

## PSP_Polarization.m

FOLLOW THE STEPS FOR PSP_ROTATION AND PSP_TRANSLATION FIRST<br>

_Running_<br>

1. Set the "User input":

Define locDir and headDir the same as in PSP_rotation:<br>
locDir = '...\Demo_output'.<br>
headDir = 'Demo_data'<br>

sellocs = 1<br>
rerun = 1<br>
save_data = 1<br>
savevid = 0<br>
saveStack = 0<br>
saveims = 0<br>

plot_ims = 0<br>
coeffplt = 0<br>
coeffisoplt = 0<br>
vecplt = 0<br>
sliceplt = 0<br>
svecplt = 0<br>

cols = ["magenta","green"]<br>
cut = 'above'<br>

pcaCol = 'Sum'<br> 
px = 30<br>
Colours = ["Orange", "Red"]<br>
shiftCol = "Sum"<br>
Nits = 2<br>
Nsegs = 10<br>
init = 'Sum'<br> 
dslice = 100/px<br>
binmet = 'AbCov'<br>
sortmet = "Length"<br>
res = 0<br>
OnlyIn = 1<br>

sz =    [37,37,37]<br>
Nsecs =         ceil((2*pi*360/100)^2)<br>
Apsp =          4*pi<br> 

poldeg = 1<br>
scaling_cutoff = 10<br>
<br>
3. Run the code.<br>
<br>

_Run time_<br>

<1 min

_Output_<br>
CoeffsAll: {Nbins,1} cell with [N images, N coefficients,3] array where [:,:,1] are the spherical harmonics expansion coefficients per image, [:,:,2] are the corresponding degrees and [:,:,3] are the corresponding orders<br>