# -*- coding: utf-8 -*-
"""
Created on Tue Aug  8 16:07:26 2023

@author: Enya on Abberior_Admin

Automated STED acquisition of paraspeckle images
"""

import numpy as np
import scipy
import scipy.ndimage
import specpy as sp
import matplotlib.pyplot as plt
import pprint
import STEDfun
import os
import time
import sys
import raster_geometry as rg
import diplib as dip
from datetime import datetime
import easygui

pp = pprint.PrettyPrinter(indent=2)

plt.ion()


# PARAMETER VALUES
ParOv = {               # Overview imaging parameters
    "Nov":   1,            # Number of overview images
    "thr":  0.65
}

ParROIconf = {
    
    "thr": 0.75}

ParROI = {}              # ROI imaging parameters

ParIm = {
        "Rpsp":  200e-9,
        # "thr":  600,
        "dt": "{:%Y_%m_%d}".format(datetime.now()),
        "PSFconf_xy": 250e-9,
        "PSFconf_z": 400e-9,
        "d_nb": 500e-9,      # Empty space on each side of the convolution kernel  
        "Nnb": 1,        # Empty 
        "thr":  0.7
        }

fields = ["Folder name","Labeled position","Number of overviews","Paraspeckle radii [nm]"]
exvals = ["date_dimensions","20700_22700","10","r1, r2, r3,..."]
UI = easygui.multenterbox("Please enter the following information:","User input",fields,exvals)

while True:
    try:
        int(UI[2])
        break
    except ValueError:
        easygui.msgbox("Please enter a valid integer for Number of overviews.", "Error")
        UI = easygui.multenterbox("Please enter the following information:","User input",fields,exvals)
        

ParIm["saveims"] = 1
folder = UI[0]
loc = UI[1]
ParIm["Folder"] = "Data/"+folder+"/"+loc
os.makedirs(ParIm["Folder"]+"/Overview",exist_ok=True)
os.makedirs(ParIm["Folder"]+"/ROIconf",exist_ok=True)
os.makedirs(ParIm["Folder"]+"/Red",exist_ok=True)
os.makedirs(ParIm["Folder"]+"/Orange",exist_ok=True)
os.makedirs(ParIm["Folder"]+"/ExpVals",exist_ok=True)
ParOv["Nov"] = int(UI[2])

ParIm["Rpsp"] = np.fromstring(UI[3], sep=',')
ParIm["Rpsp"] *= 1e-9
print(ParIm["Rpsp"])
for rr in enumerate(ParIm["Rpsp"]):
    print(rr)

ROIs_red = np.array([])
ROIs_orange = np.array([])

im = sp.get_application()               # Connection to Imspector
msr = im.active_measurement()           # Use existing active measurement


# im.value_at('ExpControl/scan/range/coarse_z/g_off').set( 1.20e-05)

ParOv["xinit"] = im.value_at('ExpControl/scan/range/coarse_x/g_off').get()
ParOv["yinit"] = im.value_at('ExpControl/scan/range/coarse_y/g_off').get()
ParOv["zinit"] = im.value_at('ExpControl/scan/range/coarse_z/g_off').get()


ParOv, ParROIconf, ParROI = STEDfun.GetParams(im, ParOv, ParROIconf, ParROI)


for oo in range(ParOv["Nov"]):
    
    print("OV "+str(oo))
    
    msr.activate(msr.configuration("Overview"))      # Activate the overview configuration
    config = msr.active_configuration()     # Get the experimental configuration

    ParOv =  STEDfun.PositionOverview(im, ParOv, oo)
    
# if oo!=0:
    im.run(msr)             # Acquire overview image
    
    # conv,idx, ParIm = STEDfun.FindROI(im, ParOv, ParIm, oo, ParROI)

    STEDfun.ImageROI(im, ParOv, ParROIconf, ParROI, ParIm, oo)
    

