# Data used in the paper "Resonant Drag Instabilities in Polydisperse Dust I. The Acoustic Resonant Drag Instability" (Paardekooper & Aly 2025)

This repository holds the data and the scripts to generate the plots of the paper "Resonant Drag Instabilities in Polydisperse Dust I. The Acoustic Resonant Drag Instability" by Paardekooper & Aly (2025). The data consists of numerically calculated growth rates of the instability, using the publicly available package [psitools](https://github.com/psitools).

The file `paper_figures.py` contains the Python script to generate all plots. It requires the `numpy`, `scipy` and `matplotlib` packages. If these are not available, they can be installed using the requirements file: `pip install -r requirements.txt`. Running `paper_figures.py` generates 6 png files corresponding to figures 2 to 7 in the paper.

The `*.npz` files contain the numerically generated data in the [numpy.savez](https://numpy.org/doc/stable/reference/generated/numpy.savez.html) format:

- `fig_adi_kx.npz`: growth rates as a function of wave number for three different size distributions, corresponding to figure 2 in the paper.
- `fig_adi_kx.npz`: growth rates for the backward propagating sound wave, coresponding to figure 3 in the paper.
- `fig_adi_mu.npz`: growth rates as a function of dust to gas ratio, corresponding to figure 4 in the paper.
- `fig_adi_asym.npz`: growth rates as a function of wave number for wide size distributions, corresponding to figure 5 in the paper.
- `fig_adi_conv.npz`: growth rates as a function of the number of dust species for the direct method, corresponding to figure 7 in the paper.
