### Dataset associated to the paper "Towards high-resolution gridded climatology stemming from the combination of official and crowdsourced weather observations using multi-fidelity methods"
#### Authors: D. van Beekvelt, I. Garcia-Marti, J. de Baar

#### General information

##### Description

Dataset associated to the research article "Towards high-resolution gridded climatology stemming from the combination of official and crowdsourced weather observations using multi-fidelity methods", currently under revision for the journal PLOS Climate. The present dataset contains the necessary files to run the examples that can be found in the manuscript. For more information about this research line, we refer the reader to the associated MSc thesis here: https://studenttheses.uu.nl/handle/20.500.12932/43339. Three CSV files are provided containing air temperature observations as measured by three networks for the 25th of January of 2019. These networks are:

- KNMI network: providing the official measurements (i.e. first-party data, 1PD)
- Rijkswaterstaat GMS network: providing measurements of sensors installed along roads (e.g. second-party data, 2PD)
- WOW for the Netherlands: providing measurements from personal weather stations (PWS) coming from weather enthusiasts (e.g. third-party data, 3PD)


##### File naming convention

The three files are named following the template *Xpd_20190125.csv*, where the *X* corresponds to the first, second, or third party data networks described in the previous section. Hence:
- KNMI network: 1PD_20190125.csv
- GMS network: 2PD_20190125.csv
- WOW-NL: 3PD_20190125.csv

##### File format

The three files have been organized in the same way. They contain 5 columns:

- one_hour_interval: datetime at which the measurement is acquiredd
- station_id: identifier of the station taking the measurement
- latitude: latitude in the CRS EPSG:4326
- longitude: longitude in the CRS EPSG:4326
- avg_temp: average temperature in the time interval 
- qlevel (only for WOW): quality level flag (M4 is the highest)

