clear all;
% close all;

% load('/Users/pandolinho/Downloads/PhD/Matlab/Y2021LogicOps/bldis.mat');

font=40;
font2=40;

time = [0 100 150 250 400 570];
cycle = [27 100 700 29*10^3 3.1*10^6 10^8];
volt = [0.9 0.8 0.7 0.6 0.5 0.4];

yyaxis left
plot(time,volt,'--s','LineWidth',1,'MarkerSize',10)
set(gca,'FontSize',font2);
xlim([-10 600])
ylim([0.38 0.92])
xyo=xlabel('Time Penalty (\itns)');
yyo=ylabel('Settling Volt. (V)');
set(xyo,'FontSize',font);
set(yyo,'FontSize',font);
% h=legend('Power','Energy','NumColumns',2,'Location','NorthWest');
% set(h,'FontSize',font2);
grid on;

yyaxis right
semilogy(time,cycle,'--s','LineWidth',1,'MarkerSize',10,'MarkerEdgeColor','b','MarkerFaceColor',[0.5,0.5,0.5])
hold on;
set(gca,'FontSize',font2);
xlim([-10 600])
ylim([1 10^9])
% set(gca,'xtick',[1 2 4 8 16 32]);
% set(gca,'ytick',[0, 1, 2, 3, 4, 5, 6, 7]);
xyo=xlabel('Time Penalty (\itns)');
yyo=ylabel('Cycles (#)');
set(xyo,'FontSize',font);
set(yyo,'FontSize',font);
% h=legend('Des1','Des2','Des3','Des4','Conv.','Cascade','NumColumns',2,'Location','NorthWest');
% set(h,'FontSize',font2);
grid on;