clear all;
% close all;

% load('/Users/pandolinho/Downloads/PhD/Matlab/Y2021LogicOps/bldis.mat');

font=50;
font2=30;

% Mine: Des1, 0.9V standard, bleeder
% Starting: 10, 60, 100
% Off in 1.7ns: 3.3mV
% On in 1.7ns: 93.4mV
% ref in 1.7ns: 60mV
% equation: 35.3t-3.3x=40mV
% 
% Mine: Des2, 0.9V standard, non-bleeder
% Des1 - some power
% Des1 + latency (800ps)
% 
% Mine: Des3, 0.45V PMOS, bleeder
% Des1 - some power
% Des1 + latency (500ps)
% 
% Mine: Des4, 0.35V NMOS, bleeder
% Des1 - some power
% Des1 + latency (300ps)

x1 = linspace (1, 16, 16);
y1 = 0.2+(40+3.3*x1)/27.2;
x12 = linspace (17, 32, 15);
y12 = 0.2-0.4+(40+3.0*x12)/27.2;
x2 = linspace (33, 43, 10);
y2 = 0.2+(40+2.0*x2)/27.2;
x3 = linspace (44, 56, 11);
y3 = 0.2-3.0+(40+3.5*x3)/27.2;
x4 = linspace (1, 32, 32);
y4 = 0.2+(40+3.3*x4)/27.2;
x5 = linspace (1, 4, 4);
y5 = [2.1 2.5 3.2 4.2];
x6 = linspace (1, 1, 1);
y6 = [2.1];
x7 = linspace (2, 56, 55);
y7 = 2.1*round((x7+0.95)/2) + 0.3*rem((x7+1),2);

% plot(x4,y4,'--s','LineWidth',1,'MarkerSize',10)
% hold on;
plot(x6,y6,'--s','LineWidth',1,'MarkerSize',10,'MarkerEdgeColor','r','MarkerFaceColor',[1 1 1])
hold on;
plot(x5,y5,'--s','LineWidth',2,'MarkerSize',15,'MarkerEdgeColor','r','MarkerFaceColor',[0.5,0.5,0.5])
hold on;
plot(x1,y1,'--s','LineWidth',1,'MarkerSize',10,'MarkerEdgeColor','b','MarkerFaceColor',[1 1 1])
hold on;
plot(x12,y12,'--s','LineWidth',1,'MarkerSize',10,'MarkerEdgeColor','b','MarkerFaceColor',[1 1 1])
hold on;
plot(x2,y2,'--s','LineWidth',1,'MarkerSize',10,'MarkerEdgeColor','b','MarkerFaceColor',[1 1 1])
hold on;
plot(x3,y3,'--s','LineWidth',1,'MarkerSize',10,'MarkerEdgeColor','b','MarkerFaceColor',[1 1 1])
hold on;
plot(x7,y7,'--s','LineWidth',1,'MarkerSize',10,'MarkerEdgeColor','r','MarkerFaceColor',[1 1 1])
hold on;
h = yline(1.5, 'k-.', 'LineWidth', 3);

set(gca,'FontSize',font2);
xlim([-1 58])
ylim([0 60])
% set(gca,'xtick',[1 2 4 8 16 32]);
% set(gca,'ytick',[0, 1, 2, 3, 4, 5, 6, 7]);
xyo=xlabel('Operand Size (#)');
yyo=ylabel('Latency (\itns)');
set(xyo,'FontSize',font);
set(yyo,'FontSize',font);
h=legend('Conv.[6]','Cascade[10]','Proposed','NumColumns',2,'Location','NorthWest');
set(h,'FontSize',font2);
grid on;