

# Measurement program Kun Zuo & Vincent Mourik
# Last updated: May 2012

# We use this script for transport measurements, both DC and AC,
# as a function of 1 or 2 other variables. Its well suited to measure
# with 1 or 2 Keithleys and/or 1 or 2 Lockins in 2 or 4 terminal geometries.
# If you are a first time user, we recommend scrolling down to the
# 'initialization' part of the script, we put some usefull comments there.
# Comments/improvements are appreciated.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.



from numpy import pi, random, arange, size, array, sin, cos, linspace, sinc, sqrt, log10, power, abs, matrix, radians
from time import time, sleep
from datetime import timedelta
from shutil import copyfile
from os import mkdir
from os.path import exists
from lib.file_support.spyview import SpyView

import datetime
import qt
import timetrack
import sys
import numpy as np
import data as d
import traces
import shutil
import os
import math
import winsound
import time


keithley1 = qt.instruments.get('keithley1')
keithley2 = qt.instruments.get('keithley2')
#keithley3 = qt.instruments.get('keithley3')
#lockin1 = qt.instruments.get('Lockin1')     #Rxx
#lockin2 = qt.instruments.get('lockin2')     #Rxy
#lockin3 = qt.instruments.get('lockin3')     #I
ivvi = qt.instruments.get('ivvi')
lakeshore = qt.instruments.get('lakeshore')
#cryomag = qt.instruments.get('magnetsupply')
#cryomag.set_heater(1)
#mw = qt.instruments.get('mw')


timestamp = datetime.datetime.now().strftime('%Y%m%d%H%M%S')

class majorana():

    # Function generates data file, spyview file and copies the pyton script.
    def create_data(self,x_vector,x_coordinate,x_parameter,y_vector,y_coordinate,y_parameter,z_vector,z_coordinate,z_parameter):
        self.filename=filename
        self.generator=d.IncrementalGenerator(qt.config['datadir']+'\\'+filename,1);
        qt.Data.set_filename_generator(self.generator)
        data = qt.Data(name=self.filename)
        '''
        multiplier = eval('multiplier'+x_parameter)
        if xmultiplier == 0.01:
            unitmultiplier = 1e-3
        elseif == 1e-3:
            unitmultiplier = 1e-6
        else:
            unitmultiplier = 1

        x
        '''
        data.add_coordinate(x_parameter+' ('+x_coordinate+')',
                            size=len(x_vector),
                            start=x_vector[0],
                            end=x_vector[-1])
        data.add_coordinate(y_parameter+' ('+y_coordinate+')',
                            size=len(y_vector),
                            start=y_vector[0],
                            end=y_vector[-1])
        data.add_coordinate(z_parameter+' ('+z_coordinate+')',
                            size=len(z_vector),
                            start=z_vector[0],
                            end=z_vector[-1])
        data.add_value('processed data Keithley1')          # Processed data Keithley 1
        data.add_value('processed data Keithley2')          # Processed data Keithley 2
        data.add_value('processed data Lockin1')            # Processed data Lockin 1
        data.add_value('processed data Lockin2')            # Processed data Lockin 2
        data.add_value('Keithley 1')                        # Read out of Keithley 1
        data.add_value('Keithley 2')                        # Read out of Keithley 2
        data.add_value('R Lockin 1')                        # Read out of R Lockin 1
        data.add_value('Theta Lockin 1')                    # Read out of Theta Lockin 1
        data.add_value('R Lockin 2')                        # Read out of R Lockin 2
        data.add_value('Theta Lockin 2')                    # Read out of Theta Lockin 2
        data.add_value('Mixing Chamber')                    # Fridge temperature
        data.create_file()                                  # Create data file
        SpyView(data).write_meta_file()                     # Create the spyview meta.txt file
        traces.copy_script(sys._getframe().f_code.co_filename,data._dir,filename+'_'+str(self.generator._counter-1))           # Copy the python script into the data folder
        return data


    # Function reads out relevant data
    def take_data(self,dacx,x):

        ivvi.set(dacx,x)                                                            # Set specified dac to specified value, has to be done here because of delays needed for Lockin measurements

        if Nkeithleys == 0:

            if Nlockins == 0:
                print 'Why are you using this function if you dont want to read out any Keithley or Lockin...'
                qt.msleep(3.0)
                sys.exit()

            elif Nlockins == 1:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                RL1 = lockin1.get_R()                                                   # Read out R Lockin1
                thetaL1 = lockin1.get_P()                                               # Read out theta Lockin1
                valueL1 = (RL1/GainL1)/(amplitude1/sqrt(2)-(RL1/GainL1)*RsL1)           # Process data Lockin1
                datavalues = [0,0,valueL1,0,0,0,RL1,thetaL1,0,0]
                qt.msleep(0.01)

            elif Nlockins == 2:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                RL1 = lockin1.get_R()                                                   # Read out Lockin1
                thetaL1 = lockin1.get_P()                                               # Read out theta Lockin1
                RL2 = lockin2.get_R()                                                   # Read out Lockin2
                thetaL2 = lockin2.get_P()                                               # Read out theta Lockin2
                valueL1 = (RL1/GainL1)/(amplitude1/sqrt(2)-(RL1/GainL1)*RsL1)           # Process data Lockin1
                valueL2 = (RL2/GainL2)/(amplitude1/sqrt(2)-(RL2/GainL2)*RsL2)           # Process data Lockin2
                datavalues = [0,0,valueL1,valueL2,0,0,RL1,thetaL1,RL2,thetaL2]
                qt.msleep(0.01)

        elif Nkeithleys == 1:

            if Nlockins == 0:
                K1 = keithley1.get_readlastval()                                        # Read out Keithley1
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                datavalues = [0,0,valueK1,0,0,0,K1,0,0,0]
                qt.msleep(0.01)

            elif Nlockins == 1:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                K1 = keithley1.get_readlastval()                                        # Read out Keithley1
                RL1 = lockin1.get_R()                                                   # Read out R Lockin1
                thetaL1 = lockin1.get_P()                                               # Read out theta Lockin1
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                valueL1 = (RL1/GainL1)/(amplitude1/sqrt(2)-(RL1/GainL1)*RsL1)           # Process data Lockin1
                datavalues = [valueK1,0,valueL1,0,K1,0,RL1,thetaL1,0,0]
                qt.msleep(0.01)

            elif Nlockins == 2:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                K1 = keithley1.get_readlastval()                                        # Read out Keithley1
                RL1 = lockin1.get_R()                                                   # Read out Lockin1
                thetaL1 = lockin1.get_P()                                               # Read out theta Lockin1
                RL2 = lockin2.get_R()                                                   # Read out Lockin2
                thetaL2 = lockin2.get_P()                                               # Read out theta Lockin2
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                valueL1 = (RL1/GainL1)/(amplitude1/sqrt(2)-(RL1/GainL1)*RsL1)           # Process data Lockin1
                valueL2 = (RL2/GainL2)/(amplitude1/sqrt(2)-(RL2/GainL2)*RsL2)           # Process data Lockin2value = (L1/GainL1)*(GainL2/L2)                                      # Process the data
                datavalues = [valueK1,0,valueL1,valueL2,K1,0,RL1,thetaL1,RL2,thetaL2]
                qt.msleep(0.01)

        elif Nkeithleys == 2:

            if Nlockins == 0:
                K1 = keithley1.get_readlastval()                                        # Read out Keithley1
                K2 = keithley2.get_readlastval()                                        # Read out Keithley2
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                valueK2 = K2/GainK2                                                     # Process data Keithley2
                if dacx == 'dac1':
                    G1 = valueK1/(x*Vrange*0.001-valueK1*RsL1)
                    G2 = valueK2/(x*Vrange*0.001-valueK2*RsL2)
                else:
                    G1 = valueK1/(ivvi.get('dac1')*Vrange*0.001-valueK1*RsL1)
                    G2 = valueK2/(ivvi.get('dac1')*Vrange*0.001-valueK2*RsL2)
                datavalues = [G1,G2,valueK1,valueK2,0,0,K1,K2,0,0]
                qt.msleep(0.01)

            elif Nlockins == 1:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                K1 = keithley1.get_readlastval()                                        # Read out Keithley1
                K2 = keithley2.get_readlastval()                                        # Read out Keithley2
                RL1 = lockin1.get_X()                                                   # Read out R Lockin1
                thetaL1 = lockin1.get_Y()                                               # Read out theta Lockin1
                valueK1 = K1/GainK1                                                   # Process data Keithley1
                valueK2 = K2/GainK2                                                     # Process data Keithley2
                valueL1 = (RL1/GainL1)/(amplitude1/sqrt(2)-(RL1/GainL1)*RsL1)                # Process data Lockin1
                if dacx == 'dac1':
                    G = valueK1/(x*Vrange*0.001-valueK1*RsL1)
                else:
                    G = valueK1/(ivvi.get('dac1')*Vrange*0.001-valueK1*RsL1)
                datavalues = [valueK1,valueK2,valueL1,G,K1,K2,RL1,thetaL1,0,0]
                qt.msleep(0.01)

            elif Nlockins == 2:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                K1 = keithley1.get_readlastval()                                        # Read out Keithley1
                K2 = keithley2.get_readlastval()                                        # Read out Keithley2
                RL1 = lockin1.get_R()                                                   # Read out R Lockin1
                thetaL1 = lockin1.get_P()                                               # Read out theta Lockin1
                RL2 = lockin2.get_R()                                                   # Read out R Lockin2
                thetaL2 = lockin2.get_P()                                               # Read out theta Lockin2
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                valueK2 = K2/GainK2                                                     # Process data Keithley2
                valueL1 = (RL1/GainL1)/(amplitude1/sqrt(2)-(RL1/GainL1)*RsL1)           # Process data Lockin1
                valueL2 = (RL2/GainL2)/(amplitude1/sqrt(2)-(RL2/GainL2)*RsL2)           # Process data Lockin2
                datavalues = [valueK1,valueK2,valueL1,valueL2,K1,K2,RL1,thetaL1,RL2,thetaL2]
                qt.msleep(0.01)

        else:
            print 'You try to run a too complicated experiment...'
            qt.msleep(3.0)
            sys.exit()

        return datavalues
        qt.msleep(0.01)                                                              # Keep GUI responsive

        # Function reads out relevant data
        # added by onder 2015.05 in relation to 2dacs_vs_dac function
    def take_2data(self,dacx,dacx2,x):

        ivvi.set(dacx,x)                                                            # Set specified dac to specified value, has to be done here because of delays needed for Lockin measurements
        ivvi.set(dacx2,x)#line added by onder

        if Nkeithleys == 0:

            if Nlockins == 0:
                print 'Why are you using this function if you dont want to read out any Keithley or Lockin...'
                qt.msleep(3.0)
                sys.exit()

            elif Nlockins == 1:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                RL1 = lockin1.get_R()                                                   # Read out R Lockin1
                thetaL1 = lockin1.get_P()                                               # Read out theta Lockin1
                valueL1 = (RL1/GainL1)/(amplitude1/sqrt(2)-(RL1/GainL1)*RsL1)           # Process data Lockin1
                datavalues = [0,0,valueL1,0,0,0,RL1,thetaL1,0,0]
                qt.msleep(0.01)

            elif Nlockins == 2:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                RL1 = lockin1.get_R()                                                   # Read out Lockin1
                thetaL1 = lockin1.get_P()                                               # Read out theta Lockin1
                RL2 = lockin2.get_R()                                                   # Read out Lockin2
                thetaL2 = lockin2.get_P()                                               # Read out theta Lockin2
                valueL1 = (RL1/GainL1)/(amplitude1/sqrt(2)-(RL1/GainL1)*RsL1)           # Process data Lockin1
                valueL2 = (RL2/GainL2)/(amplitude1/sqrt(2)-(RL2/GainL2)*RsL2)           # Process data Lockin2
                datavalues = [0,0,valueL1,valueL2,0,0,RL1,thetaL1,RL2,thetaL2]
                qt.msleep(0.01)

        elif Nkeithleys == 1:

            if Nlockins == 0:
                K1 = keithley1.get_readlastval()                                        # Read out Keithley1
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                datavalues = [0,0,valueK1,0,0,0,K1,0,0,0]
                qt.msleep(0.01)

            elif Nlockins == 1:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                K1 = keithley1.get_readlastval()                                        # Read out Keithley1
                RL1 = lockin1.get_X()                                                   # Read out R Lockin1
                thetaL1 = lockin1.get_Y()                                               # Read out theta Lockin1
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                valueL1 = (RL1/GainL1)/(amplitude1/sqrt(2)-(RL1/GainL1)*RsL1)           # Process data Lockin1
                datavalues = [valueK1,0,valueL1,0,K1,0,RL1,thetaL1,0,0]
                qt.msleep(0.01)

            elif Nlockins == 2:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                K1 = keithley1.get_readlastval()                                        # Read out Keithley1
                RL1 = lockin1.get_R()                                                   # Read out Lockin1
                thetaL1 = lockin1.get_P()                                               # Read out theta Lockin1
                RL2 = lockin2.get_R()                                                   # Read out Lockin2
                thetaL2 = lockin2.get_P()                                               # Read out theta Lockin2
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                valueL1 = (RL1/GainL1)/(amplitude1/sqrt(2)-(RL1/GainL1)*RsL1)           # Process data Lockin1
                valueL2 = (RL2/GainL2)/(amplitude1/sqrt(2)-(RL2/GainL2)*RsL2)           # Process data Lockin2value = (L1/GainL1)*(GainL2/L2)                                      # Process the data
                datavalues = [valueK1,0,valueL1,valueL2,K1,0,RL1,thetaL1,RL2,thetaL2]
                qt.msleep(0.01)

        elif Nkeithleys == 2:

            if Nlockins == 0:
                K1 = keithley1.get_readlastval()                                        # Read out Keithley1
                K2 = keithley2.get_readlastval()                                        # Read out Keithley2
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                valueK2 = K2/GainK2                                                     # Process data Keithley2
                if dacx == 'dac1':
                    G1 = valueK1/(x*Vrange*0.001-valueK1*RsL1)
                    G2 = valueK2/(x*Vrange*0.001-valueK2*RsL2)
                else:
                    G1 = valueK1/(ivvi.get('dac1')*Vrange*0.001-valueK1*RsL1)
                    G2 = valueK2/(ivvi.get('dac1')*Vrange*0.001-valueK2*RsL2)
                datavalues = [G1,G2,valueK1,valueK2,0,0,K1,K2,0,0]
                qt.msleep(0.01)

            elif Nlockins == 1:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                K1 = keithley1.get_readlastval()                                        # Read out Keithley1
                K2 = keithley2.get_readlastval()                                        # Read out Keithley2
                RL1 = lockin1.get_X()                                                   # Read out R Lockin1
                thetaL1 = lockin1.get_Y()                                               # Read out theta Lockin1
                valueK1 = K1/GainK1                                                   # Process data Keithley1
                valueK2 = K2/GainK2                                                     # Process data Keithley2
                valueL1 = (RL1/GainL1)/(amplitude1/sqrt(2)-(RL1/GainL1)*RsL1)                # Process data Lockin1
                if dacx == 'dac1':
                    G = valueK1/(x*Vrange*0.001-valueK1*RsL1)
                else:
                    G = valueK1/(ivvi.get('dac1')*Vrange*0.001-valueK1*RsL1)
                datavalues = [valueK1,valueK2,valueL1,G,K1,K2,RL1,thetaL1,0,0]
                qt.msleep(0.01)

            elif Nlockins == 2:
                qt.msleep(delay2)                                                       # Use explained at bottom of the script
                K1 = keithley1.get_readlastval()                                        # Read out Keithley1
                K2 = keithley2.get_readlastval()                                        # Read out Keithley2
                RL1 = lockin1.get_R()                                                   # Read out R Lockin1
                thetaL1 = lockin1.get_P()                                               # Read out theta Lockin1
                RL2 = lockin2.get_R()                                                   # Read out R Lockin2
                thetaL2 = lockin2.get_P()                                               # Read out theta Lockin2
                #if abs(lockin2.get_P()) < abs(lockin2.get_R()):
                #    RL2 = lockin2.get_P()                                                   # Read out R Lockin2
                #   thetaL2 = lockin2.get_R()                                               # Read out theta Lockin2
                valueK1 = K1/GainK1                                                     # Process data Keithley1
                valueK2 = K2/GainK2                                                     # Process data Keithley2
                valueL1 = (RL1/GainL1)/(amplitude1/sqrt(2)-(RL1/GainL1)*RsL1)           # Process data Lockin1
                valueL2 = (RL2/GainL2)/(amplitude1/sqrt(2)-(RL2/GainL2)*RsL2)           # Process data Lockin2
                datavalues = [valueK1,valueK2,valueL1,valueL2,K1,K2,RL1,thetaL1,RL2,thetaL2]
                qt.msleep(0.01)

        else:
            print 'You try to run a too complicated experiment...'
            qt.msleep(3.0)
            sys.exit()

        return datavalues
        qt.msleep(0.01)                                                              # Keep GUI responsive

    def set_dac(self,dacx,value):
        start = ivvi.get(dacx)
        steps = 100
        dacs = np.linspace(start+(value-start)/100,value,steps)
        t0 = time.time()
        for i,x in enumerate(dacs):
            ivvi.set(dacx,x)
            t = time.time()
            trem = (t-t0)/(i+1)*(100-(i+1))
            trem = str(timedelta(seconds=trem))[:-7]
            print ' {:s}={:.1f} -> {:.1f} ({:d}%) - {:s} remaining          \r'.format(dacx,x,value,i+1,trem),
        print ' '*78,'\r',


    # Function to control bias switch between different lead biasing
    def bias_switch(self,switch_bias,side1,side2,biasdac,controldac):

        if switch_bias == 'ON':

            if switch_bias_mode == 'FLOATING':

                if side1 == 'ON':

                    if side2 == 'ON':

                        print 'bias switching doesnt work with lead1 and lead2 both "ON", error in script!!!'
                        sys.exit()

                    elif side2 == 'OFF':

                        control_lead = ivvi.get(controldac)
                        ivvi.set(biasdac,0.0)

                        if control_lead > 1495.0:

                                return

                        else:

                            ivvi.set(biasdac,0.0)
                            ivvi.set(controldac,1500.0)
                            qt.msleep(5.0)

                    else:

                        print 'typo in value lead2'
                        sys.exit()

                elif side2 == 'ON':

                    if side1 == 'OFF':

                        control_lead = ivvi.get(controldac)
                        ivvi.set(biasdac,0.0)

                        if control_lead < -1495.0:

                           return

                        else:

                            ivvi.set(biasdac,0.0)
                            ivvi.set(controldac,-1500.0)
                            qt.msleep(5.0)

                    else:

                        print 'typo in value lead1'
                        sys.exit()
                else:

                    print 'typo in value lead1 and/or value lead2'
                    sys.exit()

            elif switch_bias_mode == 'TWOTERMINAL':                 #### This function is kept the same as it was before

                if lead1 == 'ON':

                    if lead2 == 'ON':

                        print 'bias switching doesnt work with lead1 and lead2 both "ON", error in script!!!'
                        sys.exit()

                    elif lead2 == 'OFF':

                        control_lead1 = ivvi.get(controldac_lead1)
                        control_lead2 = ivvi.get(controldac_lead2)

                        if control_lead1 > 1495.0:

                            if control_lead2 < -1495.0:
                                return

                        else:

                            ivvi.set(biasdac_lead1,0.0)
                            ivvi.set(biasdac_lead2,0.0)
                            ivvi.set(controldac_lead1,1500.0)
                            ivvi.set(controldac_lead2,-1500.0)
                            qt.msleep(5.0)

                    else:

                        print 'typo in value lead2'
                        sys.exit()

                elif lead2 == 'ON':

                    if lead1 == 'OFF':

                        control_lead1 = ivvi.get(controldac_lead1)
                        control_lead2 = ivvi.get(controldac_lead2)

                        if control_lead1 < -1495.0:

                            if control_lead2 > 1495:
                                return

                        else:

                            ivvi.set(biasdac_lead1,0.0)
                            ivvi.set(biasdac_lead2,0.0)
                            ivvi.set(controldac_lead1,-1500.0)
                            ivvi.set(controldac_lead2,1500.0)
                            qt.msleep(5.0)

                    else:

                        print 'typo in value lead1'
                        sys.exit()
                else:

                    print 'typo in value lead1 and/or value lead2'
                    sys.exit()

            else:

                print 'typo in value switch_bias_mode'
                sys.exit()

        else:
            return


    # Function to read out temperature
    def read_T(self):
        return lakeshore.get_kelvinA()


    # Function to set B value
    def set_B(self,B):

        if magnet == 'kepco':
            kepco.set_B(B)

        elif magnet == 'OxfordMK3':
            OxfordMK3.set_B(B)

        elif magnet == 'OxfordMK3nodriver':

            if B < 0:
                print 'Power supply unipolar, cannot set negative field'
                return

            elif B > Bmax:
                print 'Danger of magnet quench: B_set = ' + `B` + ' > B_max = ' + `Bmax`
                return

            else:
                #coilConstant = 0.0678 #Tesla per Amp
                #IVconstant = #magnet current in amps per output voltage
                TVconstant = 2.8/(-3.47)#Tesla per Volt
                lockinIncrement = 0.001# = 1mV = resolution of aux output
                rampRate = 0.05 # Tesla per min
                currentLockin = lockin3.read_aux(1)#in volts
                #print 'currentLockin'
                #print currentLockin
                currentField = currentLockin*TVconstant #conversion to Tesla
                print 'currentField'
                print currentField
                print 'setField'
                print B
                rampDistanceB = B - currentField #in Tesla
                #print 'rampDistanceB'
                #print rampDistanceB
                rampDistanceLockin = rampDistanceB/TVconstant #in Volts
                #print 'rampDistanceLockin'
                #print rampDistanceLockin
                rampTime = abs((rampDistanceB/rampRate) * 60.0) #in second.
                #print 'rampTime'
                #print rampTime
                intRampIterationMax = int(math.floor(abs(rampDistanceLockin) / lockinIncrement))
                #print 'intRampIterationMax'
                #print intRampIterationMax
                if intRampIterationMax > 0:
                    waitTime = abs(rampTime / intRampIterationMax)
                    #print 'waitTime'
                    #print waitTime
                    if rampDistanceB > 0:
                        lockinIncrement = - lockinIncrement
                    #print 'lockinIncrement'
                    #print lockinIncrement
                    for i in range(1,intRampIterationMax+1):
                        lockin3.set_aux(1,i*lockinIncrement + currentLockin)
                        qt.msleep(waitTime)
                        #print i*lockinIncrement + currentLockin

        elif magnet == 'AMI430':
            AMI430.set_field(B)
        elif magnet=='cryomag':
            B_in_T = B
            B_in_mT = B_in_T*1000
            cryomag.set_field(B_in_mT)
            while True:
                qt.msleep(0.02)
                if abs(cryomag.get_field() - B_in_mT) < 20:
                    return



    ################ 1D SCANS #####################


    # 1D sweep of a single dac
    def _single_dac_sweep(self,xname,dacx,xstart,xend,xsteps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = [0]
        z_vector = [0]

        data = self.create_data(x_vector,xname,dacx,y_vector,'none','y_parameter',z_vector,'none','z_parameter')                                # create data file, spyview metafile, copy script

        ivvi.set(dacx,x_vector[0])
        qt.msleep(delay1)
        t0 = time.time()
        
        for i,x in enumerate(x_vector):
            datavalues = self.take_data(dacx,x)  # Go to next sweep value and take data
            T_mc = self.read_T()                 # Read out mixing chamber temperature
            data.add_data_point(x,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)   # write datapoint into datafile
            t = time.time()
            trem = (t-t0)/(i+1)*(xsteps+1-(i+1))
            trem = str(timedelta(seconds=trem))[:-7]
            print 'Measuring {:s} sweep from {:.5g} to {:.5g} - {:.5g} - {:s} remaining          \r'.format(dacx,xstart,xend,x,trem),

        data.new_block()
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

    # Repeatedly sweep a single dac n times, n = repetions
    def _repeat_single_dac_sweep(self,xname,dacx,xstart,xend,xsteps,repetions):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(1,repetions,repetions)                                                                                              # this sweep variable is defined to enable 2D plotting in spyview
        z_vector = [0]

        data = self.create_data(x_vector,xname,dacx,y_vector,'n','repetions',z_vector,'none','z_parameter')                                     # create data file, spyview metafile, copy script

        counter = 0

        for i in arange(repetions):
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script

            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile

            timetrack.remainingtime(starttime,repetions,counter)                                                                                # Calculate and print remaining scantime
            data.new_block()

        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()


    # 1D sweep of 2 dac's simultaneously; sweep vectors can have arbitrary start and end values.
    def _2dacs_sweep(self,xname,dacx,xstart,xend,mname,dacm,mstart,mend,steps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,steps+1)
        y_vector = [0]
        z_vector = [0]

        data = self.create_data(x_vector,xname,dacx,y_vector,'none','y_parameter',z_vector,'none','z_parameter')                               # create data file, spyview metafile, copy script

        # Define sweep vector for other dac
        m_vector = linspace(mstart,mend,steps+1)

        for i in arange(len(x_vector)):
            x = x_vector[i]
            m = m_vector[i]
            ivvi.set(dacm,m)                                                                                                                    # Other dac needs to be set before running take_data
            datavalues = self.take_data(dacx,x)                                                                                                 # Go to next sweep value and take data
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            data.add_data_point(x,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                               # write datapoint into datafile

        data.new_block()
        data._write_settings_file()
        data.close_file()
        qt.mend()


    # 1D sweep of 3 dac's simultaneously; sweep vectors can have arbitrary start and end values.
    def _3dacs_sweep(self,xname,dacx,xstart,xend,mname,dacm,mstart,mend,nname,dacn,nstart,nend,steps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,steps+1)
        y_vector = [0]
        z_vector = [0]

        data = self.create_data(x_vector,xname,dacx,y_vector,'none','y_parameter',z_vector,'none','z_parameter')                               # create data file, spyview metafile, copy script

        # Define sweep vector for other dacs
        m_vector = linspace(mstart,mend,steps+1)
        n_vector = linspace(nstart,nend,steps+1)

        for i in arange(len(x_vector)):
            x = x_vector[i]
            m = m_vector[i]
            n = n_vector[i]
            ivvi.set(dacm,m)                                                                                                                    # Other dacs needs to be set before running take_data
            ivvi.set(dacn,n)
            datavalues = self.take_data(dacx,x)                                                                                                 # Go to next sweep value and take data
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            data.add_data_point(x,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                               # write datapoint into datafile

        data.new_block()
        data._write_settings_file()
        data.close_file()
        qt.mend()


    # 1D sweep of 4 dac's simultaneously; sweep vectors can have arbitrary start and end values.
    def _4dacs_sweep(self,xname,dacx,xstart,xend,mname,dacm,mstart,mend,nname,dacn,nstart,nend,pname,dacp,pstart,pend,steps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,steps+1)
        y_vector = [0]
        z_vector = [0]

        data = self.create_data(x_vector,xname,dacx,y_vector,'none','y_parameter',z_vector,'none','z_parameter')                               # create data file, spyview metafile, copy script

        # Define sweep vector for other dacs
        m_vector = linspace(mstart,mend,steps+1)
        n_vector = linspace(nstart,nend,steps+1)
        p_vector = linspace(pstart,pend,steps+1)

        for i in arange(len(x_vector)):
            x = x_vector[i]
            m = m_vector[i]
            n = n_vector[i]
            p = p_vector[i]
            ivvi.set(dacm,m)                                                                                                                    # Other dacs needs to be set before running take_data
            ivvi.set(dacn,n)
            ivvi.set(dacp,p)
            datavalues = self.take_data(dacx,x)                                                                                                 # Go to next sweep value and take data
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            data.add_data_point(x,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                               # write datapoint into datafile

        data.new_block()
        data._write_settings_file()
        data.close_file()
        qt.mend()

        # 1D sweep of 11 dacs, all together, same range
    def _11_dacs_sweep(self,xname,dacx,yname,dacy,zname,dacz,kname,dack,lname,dacl,mname,dacm,nname,dacn,oname,daco,pname,dacp,qname,dacq,rname,dacr,xstart,xend,xsteps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = [0]
        z_vector = [0]

        data = self.create_data(x_vector,xname,dacx,y_vector,'none','y_parameter',z_vector,'none','z_parameter')                                # create data file, spyview metafile, copy script

        for x in x_vector:
            ivvi.set(dacy,x)
            ivvi.set(dacz,x)
            ivvi.set(dack,x)
            ivvi.set(dacl,x)
            ivvi.set(dacm,x)
            ivvi.set(dacn,x)
            ivvi.set(daco,x)
            ivvi.set(dacp,x)
            ivvi.set(dacq,x)
            ivvi.set(dacr,x)
            datavalues = self.take_data(dacx,x)                                                                                                 # Go to next sweep value and take data
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            data.add_data_point(x,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                               # write datapoint into datafile

        data.new_block()
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
		
	# 1D sweep of a single dac
    def _time_sweep(self, time_steps, time_interval):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(0, time_interval*time_steps, time_steps+1) # time interval in seconds
        y_vector = [0]
        z_vector = [0]

        data = self.create_data(x_vector,"seconds",'time',y_vector,'none','y_parameter',z_vector,'none','z_parameter')  # create data file, spyview metafile, copy script

        qt.msleep(delay1)
        t0 = time.time()
        
        for i,x in enumerate(x_vector):
			K1 = keithley1.get_readnextval()
			K2 = keithley2.get_readnextval()
			datavalues = [0,0,K1/GainK1,K2/GainK2,0,0,K1,K2,0,0]  # Go to next sweep value and take data
			T_mc = self.read_T() # Read out temperature
			data.add_data_point(x,0,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)           # write datapoint into datafile
			t = time.time()
			trem = (t-t0)/(i+1)*(time_steps+1-(i+1))
			trem = str(timedelta(seconds=trem))[:-7]
			print 'Measuring {:s} sweep from {:.5g} to {:.5g} - {:.5g} - {:s} remaining          \r'.format("time",0,time_interval*time_steps,x,trem),
			qt.msleep(time_interval)
			
        data.new_block()
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()
	
	
    #################### 2D SCANS ####################


    # 2D scan of one dac vs another one
    def _dac_vs_dac(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,ysteps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ysteps+1)
        z_vector = [0]

        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'none','z_parameter')                                          # create data file, spyview metafile, copy script

        counter = 0

        for y in y_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            ivvi.set(dacy,y)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script

            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile

            timetrack.remainingtime(starttime,ysteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()

        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

        # added by onder 2015.05
        # 2D scan of 2 dacs vs another one
        # swept dac values (dacx and dacx2) are the same!
    def _2dacs_vs_dac(self,xname,dacx,dacx2,xstart,xend,xsteps,yname,dacy,ystart,yend,ysteps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ysteps+1)
        z_vector = [0]

        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'none','z_parameter')                                          # create data file, spyview metafile, copy script

        counter = 0

        for y in y_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            ivvi.set(dacy,y)
            ivvi.set(dacx,x_vector[0])
            ivvi.set(dacx2,x_vector[0])#line modified by onder
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script

            for x in x_vector:
                datavalues = self.take_2data(dacx,dacx2,x)#line modified by onder                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile

            timetrack.remainingtime(starttime,ysteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()

        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

    # 2D scan of one dac vs 2 others; the 2 dacs that are stepped together can have arbitrary start and end values
    def _dac_vs_2dacs(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,mname,dacm,mstart,mend,ymsteps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ymsteps+1)
        z_vector = [0]

        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'none','z_parameter')                                          # create data file, spyview metafile, copy script

        # Define sweep vector for other dac
        m_vector = linspace(mstart,mend,ymsteps+1)

        counter = 0

        for i in arange(len(y_vector)):
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            y = y_vector[i]
            m = m_vector[i]
            ivvi.set(dacy,y)
            ivvi.set(dacm,m)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script

            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile

            timetrack.remainingtime(starttime,ymsteps+1,counter)                                                                                # Calculate and print remaining scantime
            data.new_block()

        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

    # added by onder
    # 2D scan of 2 dacs vs 2 others; the 2 second set of dacs stepped together can have arbitrary start and end values
    def _2dacs_vs_2dacs(self,xname,dacx,dacx2,xstart,xend,xsteps,yname,dacy,ystart,yend,mname,dacm,mstart,mend,ymsteps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ymsteps+1)
        z_vector = [0]

        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'none','z_parameter')                                          # create data file, spyview metafile, copy script

        # Define sweep vector for other dac
        m_vector = linspace(mstart,mend,ymsteps+1)

        counter = 0

        for i in arange(len(y_vector)):
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            y = y_vector[i]
            m = m_vector[i]
            ivvi.set(dacy,y)
            ivvi.set(dacm,m)
            ivvi.set(dacx,x_vector[0])
            ivvi.set(dacx2,x_vector[0])#line modified by onder
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script

            for x in x_vector:
                datavalues = self.take_2data(dacx,dacx2,x)#line modified by onder                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile

            timetrack.remainingtime(starttime,ymsteps+1,counter)                                                                                # Calculate and print remaining scantime
            data.new_block()

        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()




    # 2D scan of one dac vs 3 others; the 3 dacs that are stepped together can have arbitrary start and end values
    def _dac_vs_3dacs(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,mname,dacm,mstart,mend,nname,dacn,nstart,nend,ymnsteps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ymnsteps+1)
        z_vector = [0]

        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'none','z_parameter')                                          # create data file, spyview metafile, copy script

        # Define sweep vector for other dacs
        m_vector = linspace(mstart,mend,ymnsteps+1)
        n_vector = linspace(nstart,nend,ymnsteps+1)

        counter = 0

        for i in arange(len(y_vector)):
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            y = y_vector[i]
            m = m_vector[i]
            n = n_vector[i]
            ivvi.set(dacy,y)
            ivvi.set(dacm,m)
            ivvi.set(dacn,n)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script

            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile

            timetrack.remainingtime(starttime,ymnsteps+1,counter)                                                                               # Calculate and print remaining scantime
            data.new_block()

        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()


    # added by onder
    # 2D scan of 2 dacs vs 3 others; the 3 dacs that are stepped together can have arbitrary start and end values
    def _2dacs_vs_3dacs(self,xname,dacx,dacx2,xstart,xend,xsteps,yname,dacy,ystart,yend,mname,dacm,mstart,mend,nname,dacn,nstart,nend,ymnsteps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ymnsteps+1)
        z_vector = [0]

        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'none','z_parameter')                                          # create data file, spyview metafile, copy script

        # Define sweep vector for other dacs
        m_vector = linspace(mstart,mend,ymnsteps+1)
        n_vector = linspace(nstart,nend,ymnsteps+1)

        counter = 0

        for i in arange(len(y_vector)):
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            y = y_vector[i]
            m = m_vector[i]
            n = n_vector[i]
            ivvi.set(dacy,y)
            ivvi.set(dacm,m)
            ivvi.set(dacn,n)
            ivvi.set(dacx,x_vector[0])
            ivvi.set(dacx2,x_vector[0])#line modified by onder
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script

            for x in x_vector:
                datavalues = self.take_2data(dacx,dacx2,x)#line modified by onder                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile

            timetrack.remainingtime(starttime,ymnsteps+1,counter)                                                                               # Calculate and print remaining scantime
            data.new_block()

        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()


    # 2D scan of one dac vs 4 others; the 4 dacs that are stepped together can have arbitrary start and end values
    def _dac_vs_4dacs(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,mname,dacm,mstart,mend,nname,dacn,nstart,nend,pname,dacp,pstart,pend,ymnpsteps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ymnpsteps+1)
        z_vector = [0]

        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'none','z_parameter')                                          # create data file, spyview metafile, copy script

        # Define sweep vector for other dacs
        m_vector = linspace(mstart,mend,ymnpsteps+1)
        n_vector = linspace(nstart,nend,ymnpsteps+1)
        p_vector = linspace(pstart,pend,ymnpsteps+1)

        counter = 0

        for i in arange(len(y_vector)):
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            y = y_vector[i]
            m = m_vector[i]
            n = n_vector[i]
            p = p_vector[i]
            ivvi.set(dacy,y)
            ivvi.set(dacm,m)
            ivvi.set(dacn,n)
            ivvi.set(dacp,p)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script

            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile

            timetrack.remainingtime(starttime,ymnpsteps+1,counter)                                                                              # Calculate and print remaining scantime
            data.new_block()

        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()


    # 2D scan of one dac vs another one n times repeated, n = repetions
    def _repeat_dac_vs_dac(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,ysteps,repetions):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ysteps+1)
        z_vector = linspace(1,repetions,repetions)

        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'n','repetions')                                               # create data file, spyview metafile, copy script

        counter = 0
        numloops = repetions*(ysteps+1)

        for i in arange(repetions):
            ivvi.set(dacy,y[0])
            ivvi.set(dacx,x[0])

            for y in y_vector:
                [starttime, counter] = timetrack.start(counter)
                tstart = timetrack.time()
                ivvi.set(dacy,y)
                ivvi.set(dacx,x[0])
                T_mc = self.read_T()                                                                                                            # Read out mixing chamber temperature
                qt.msleep(delay1)                                                                                                               # use explained at the bottom of the script

                for x in x_vector:
                    datavalues = self.take_data(dacx,x)                                                                                         # Go to next sweep value and take data
                    data.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                       # write datapoint into datafile

                timetrack.remainingtime(starttime,numloops,counter)                                                                             # Calculate and print remaining scantime
                data.new_block()

        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()


    # 2D scan, every sweep consists of 2 times a dac sweep (first one from start to end of the sweep vector, 2nd one backwards from end to start of the sweep vector), this is done as a function of another dac.
    def _fwdbwd_dac_vs_dac(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,ysteps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ysteps+1)
        z_vector = [0]

        data_fwd = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'none','z_parameter')                                      # create data file, spyview metafile, copy script for fwd sweep direction
        x_vector = x_vector[::-1]                                                                                                               # reverse direction of sweep vector to ensure proper spyview metafile
        data_bwd = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'none','z_parameter')                                      # create data file, spyview metafile, copy script for bwd sweep direction
        x_vector = x_vector[::-1]                                                                                                               # reverse direction sweep vector back to original


        counter = 0

        for y in y_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart=timetrack.time();
            ivvi.set(y_parameter,y)


            for data_loop in (data_fwd, data_bwd):

                ivvi.set(dacx,x_vector[0])
                T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
                qt.msleep(delay1)

                for x in x_vector:
                    datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                    data_loop.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                      # write datapoint into datafile

                data_loop.new_block()

                # Toggle forward / backward by reversing vector
                x_vector = x_vector[::-1]

            tstop = timetrack.time()
            timetrack.remainingtime(starttime,ysteps+1,counter)                                                                                 # Calculate and print remaining scantime

        for data_loop in (data_fwd, data_bwd):
            data_loop._write_settings_file()                                                                                                    # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
            data_loop.close_file()

        qt.mend()


    ############### 3D scans ########################

    # 3D scan of one dac vs another dac vs another dac
    def _dac_vs_dac_vs_dac(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,ysteps,zname,dacz,zstart,zend,zsteps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ysteps+1)
        z_vector = linspace(zstart,zend,zsteps+1)

        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,zname,dacz)                                                    # create data file, spyview metafile, copy script

        counter = 0
        numloops = (zsteps+1)*(ysteps+1)

        for z in z_vector:
            ivvi.set(dacz,z)

            for y in y_vector:
                [starttime, counter] = timetrack.start(counter)
                tstart = timetrack.time()
                ivvi.set(dacy,y)
                ivvi.set(dacx,x[0])
                T_mc = self.read_T()                                                                                                            # Read out mixing chamber temperature
                qt.msleep(delay1)                                                                                                               # use explained at the bottom of the script

                for x in x_vector:
                    datavalues = self.take_data(dacx,x)                                                                                         # Go to next sweep value and take data
                    data.add_data_point(x,y,z,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                       # write datapoint into datafile

                timetrack.remainingtime(starttime,numloops,counter)                                                                             # Calculate and print remaining scantime
                data.new_block()

        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()


    ############### SCANS INVOLVING OTHER EQUIPMENT (MAGNET SUPPLY, RF SOURCE) #################


    # To scan a dac as a function of B
    def _dac_vs_magnet(self,xname,dacx,xstart,xend,xsteps,Bstart,Bend,Bsteps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        z_vector = [0]

        data = self.create_data(x_vector,xname,dacx,B_vector,'B (T)',magnet,z_vector,'none','z_parameter')                                      # create data file, spyview metafile, copy script

        counter = 0

        for B in B_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self.set_B(B)                                                                                                                       # Sets B field
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script

            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,B,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile

            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()

        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()


    # To scan a dac as a function of B
    # added by onder 2015.09
    # 2D scan of 2 dacs vs magnetic field
    # swept dac values (dacx and dacx2) are the same!
    def _2dac_vs_magnet(self,xname,dacx,dacx2,xstart,xend,xsteps,Bstart,Bend,Bsteps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        z_vector = [0]

        data = self.create_data(x_vector,xname,dacx,B_vector,'B (T)',magnet,z_vector,'none','z_parameter')                                      # create data file, spyview metafile, copy script

        counter = 0

        for B in B_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self.set_B(B)                                                                                                                       # Sets B field
            ivvi.set(dacx,x_vector[0])
            ivvi.set(dacx2,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script

            for x in x_vector:
                datavalues = self.take_2data(dacx,dacx2,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,B,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile

            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()

        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()

    # To scan a dac as a function of B
    def _dac_vs_1dac_and_magnet(self,xname,dacx,xstart,xend,xsteps,yname,dacy,dacy_zeroB,dacy_mvperT,Bstart,Bend,Bsteps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        y_vector = linspace(dacy_zeroB+Bstart*dacy_mvperT,dacy_zeroB+Bend*dacy_mvperT,Bsteps+1)
        z_vector = [0]

        data = self.create_data(x_vector,xname,dacx,B_vector,'B (T)',magnet,z_vector,'none','z_parameter')                                     # create data file, spyview metafile, copy script

        counter = 0

        for i in arange(len(B_vector)):
            B = B_vector[i]
            y = y_vector[i]
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self.set_B(B)                                                                                                                      # Sets B field
            ivvi.set(dacy,y)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script

            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,B,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile

            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()

        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()


    # To scan a dac as a function of B and simultaneously sweep 2 dacs.
    def _dac_vs_2dac_and_magnet(self,xname,dacx,xstart,xend,xsteps,yname,dacy,dacy_zeroB,dacy_mvperT,qname,dacq,dacq_zeroB,dacq_mvperT,Bstart,Bend,Bsteps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        y_vector = linspace(dacy_zeroB+Bstart*dacy_mvperT,dacy_zeroB+Bend*dacy_mvperT,Bsteps+1)
        q_vector = linspace(dacq_zeroB+Bstart*dacq_mvperT,dacy_zeroB+Bend*dacq_mvperT,Bsteps+1)
        z_vector = [0]

        data = self.create_data(x_vector,xname,dacx,B_vector,'B (T)',magnet,z_vector,'none','z_parameter')                                     # create data file, spyview metafile, copy script

        counter = 0

        for i in arange(len(B_vector)):
            B = B_vector[i]
            y = y_vector[i]
            q = q_vector[i]
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self.set_B(B)                                                                                                                       # Sets B field
            ivvi.set(dacy,y)
            ivvi.set(dacq,q)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script

            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,B,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile

            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()

        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()


    # To sweep a dac as a function of B, every sweep consists of 2 times a dac sweep (first one from start to end of the sweep vector, 2nd one backwards from end to start of the sweep vector).
    def _fwdbwd_dac_vs_B(self,xname,dacx,xstart,xend,xsteps,Bstart,Bend,Bsteps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        z_vector = [0]

        data_fwd = self.create_data(x_vector,xname,dacx,B_vector,'B (T)',magnet,z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script for fwd sweep direction
        x_vector = x_vector[::-1]                                                                                                               # reverse direction of sweep vector to ensure proper spyview metafile
        data_bwd = self.create_data(x_vector,xname,dacx,B_vector,'B (T)',magnet,z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script for bwd sweep direction
        x_vector = x_vector[::-1]                                                                                                               # reverse direction sweep vector back to original


        counter = 0

        for B in B_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart=timetrack.time();
            self.set_B(B)                                                                                                                       # Sets B field


            for data_loop in (data_fwd, data_bwd):

                ivvi.set(dacx,x_vector[0])
                T_mc = self.read_T()                                                                                                            # Read out mixing chamber temperature
                qt.msleep(delay1)

                for x in x_vector:
                    datavalues = self.take_data(dacx,x)                                                                                         # Go to next sweep value and take data
                    data_loop.add_data_point(x,B,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                  # write datapoint into datafile

                data_loop.new_block()

                # Toggle forward / backward by reversing vector
                x_vector = x_vector[::-1]

            tstop = timetrack.time()
            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime

        for data_loop in (data_fwd, data_bwd):
            data_loop._write_settings_file()                                                                                                    # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
            data_loop.close_file()

        qt.mend()


    # Scan a dac as a function of B, while at the same time another dac is stepped linearly, this allows to correct a bit for features affected by both gate and B field so they don't move much.

    def _dac_vs_dacmagnet(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,Bstart,Bend,Bsteps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        z_vector = [0]

        data = self.create_data(x_vector,xname,dacx,B_vector,'B (T)',magnet,z_vector,'none','z_parameter')                                     # create data file, spyview metafile, copy script

        # Create sweep vector for the dac that needs to be stepped together with B
        y_vector = linspace(ystart,yend,Bsteps+1)

        counter = 0

        for i in arange(len(B_vector)):
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            B = B_vector[i]
            y = y_vector[i]
            kepco.set_B(B)                                                                                                                      # Specific for kepco as magnet supply
            ivvi.set(dacy,y)
            ivvi.set(dacx,x[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script

            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,B,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile

            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()

        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()


    # dac vs rf power, to do power dependence of Shapiro steps. rf power is stepped with non-uniform steps following P^2 ~ Vrf. Function only works well if you start the sweep at the lowest power.

    def _dac_vs_rfpower(self,xname,dacx,xstart,xend,xsteps,Pstart,Pend,Psteps,freq):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)

        # P vector needs to have quadratic shape
        yend = (Pend-Pstart)*(Pend-Pstart)
        y_vector = linspace(0,yend,Psteps+1)
        P_vector = sqrt(y_vector)+Pstart

        z_vector = [0]

        data = self.create_data(x_vector,xname,dacx,P_vector,'Prf (dB)','MW source',z_vector,'none','z_parameter')                               # create data file, spyview metafile, copy script

        counter = 0

        # initialization of MW source
        mw.set_power(-20.0)
        mw.set_frequency(freq)
        mw.set_status('ON')

        for P in P_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            mw.set_power(P)                                                                                                                     # Set mw power
            ivvi.set(dacx,x[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script

            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,P,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile

            timetrack.remainingtime(starttime,Psteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()

        mw.set_status('OFF')
        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()


    ################# SCANS TO USE WITH AMI430 3D MAGNET #######################

    # Function that transforms an aribtrary B field vector in spherical coordinates to the cartesian coordinate field values and sets it.
    # It takes into account the correction angles defined wrt to positive z and x axis!
    # Sweeping is done in safest possible way: max vector length of 1T is hardcoded, first fields are ramped down if needed, then ramped up.
    # Function written for raw mode of Attila's AMI430 driver. This function should be implemented in an upgrade of this driver!

    def _set_3Dfield(self,r,theta,phi):

        # first define and read out old field values.
        Xold = AMI430.get_fieldX()
        Yold = AMI430.get_fieldY()
        Zold = AMI430.get_fieldZ()


        # Compute the real magnet values in x,y,z from the transformed spherical coordinates by taking into account the correction angles.

        # First convert all angles to radians
        theta = radians(theta)
        phi = radians(phi)
        p = radians(phi_correction)
        t = radians(theta_correction)

        # Set matrix elements of tranformation matrix. The transformation is as follows:
        # 1) rotation around z-axis over angle phi_correction
        # 2) basis transformation to x',y',z' over the angle phi_correction. This allows for defining the next rotation in the x',y',z' frame
        # 3) rotation around y-axis over angle theta_correction


        '''
        R11 = pow(cos(f),2)*(cos(f)*cos(l)+pow(sin(f),2))
        R12 = -sin(f)*(1+cos(l)*pow(cos(f),2)-pow(cos(f),3))
        R13 = sin(l)*cos(f)
        R21 = sin(f)*cos(l)
        R22 = cos(f)*(pow(sin(f),2)+cos(l)*pow(cos(f),2)+pow(cos(f),3)*(1-cos(l)))
        R23 = sin(f)*sin(l)
        R31 = -sin(l)
        R32 = 0
        R33 = cos(l)
        '''

        Transformation = matrix([[cos(p)*cos(t),-sin(p),cos(p)*sin(t)],[sin(p)*cos(t),cos(p),sin(p)*sin(t)],[-sin(t),0,cos(t)]])

        transformed_new_field = r*matrix([[cos(phi)*sin(theta)],[sin(theta)*sin(phi)],[cos(theta)]])

        real_new_field = Transformation*transformed_new_field

        Xnew = real_new_field[0,0]
        Ynew = real_new_field[1,0]
        Znew = real_new_field[2,0]

        '''
        print Xnew
        print Ynew
        print Znew
        '''

        # To sweep safe, we check that total vector length stays below 1T

        if power(power(Xnew,2)+power(Ynew,2)+power(Znew,2),0.5) > 1:
            print 'Field value you want to set is too high!!!'
            sys.exit()


        # Set new field values. Do it in a safe way, first sweep down if possible, then up.

        if abs(Xnew) < abs(Xold):                   # We have to compare absolute value, in that way the total vector lenght will stay minimal during sweeping.
            AMI430.set_fieldX(Xnew)                 # Since abs(Xnew)<abs(Xold), we have to set it first.

            if abs(Ynew) < abs(Yold):
                AMI430.set_fieldY(Ynew)             # Since abs(Ynew)<abs(Yold), we have to set it first.
                AMI430.set_fieldZ(Znew)             # Since we already set Xnew and Ynew, we can just set Znew now.

            else:
                AMI430.set_fieldZ(Znew)             # We don't need to check if abs(Znew) < abs(Zold) since its the last one anyway, so we can set if first.
                AMI430.set_fieldY(Ynew)             # Safe to set Ynew now.

        else:

            if abs(Ynew) < abs(Yold):
                AMI430.set_fieldY(Ynew)             # Since abs(Ynew)<abs(Yold), we have to set it first.
                AMI430.set_fieldZ(Znew)             # Since we already checked Xnew and we already set Ynew, we can just set Znew now.
                AMI430.set_fieldX(Xnew)             # We set Xnew as latest since we know it goes up.

            else:
                AMI430.set_fieldZ(Znew)             # We don't need to check if abs(Znew) < abs(Zold) since its the last one anyway, so we can set if first.
                AMI430.set_fieldY(Ynew)             # Since both Ynew and Xnew are larger then the old values, it doesn't matter which one we sweep first.
                AMI430.set_fieldX(Xnew)


    # To scan a dac as a function of B
    def _dac_vs_3Dmagnet(self,xname,dacx,xstart,xend,xsteps,Bstart,Bend,Bsteps,theta,phi):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        z_vector = [0]

        data = self.create_data(x_vector,xname,dacx,B_vector,'B) (T',magnet,z_vector,'none','z_parameter')                                      # create data file, spyview metafile, copy script

        counter = 0

        for B in B_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self._set_3Dfield(B,theta,phi)                                                                                                                       # Sets B field
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script

            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,B,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile

            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()

        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()



    # Scan dac as a function of theta angle at some fixed B value. theta is defined wrt to positive z-axis. Written for raw mode of AMI430 driver, r is the magnetude of B.
    def _dac_vs_theta(self,xname,dacx,xstart,xend,xsteps,thetastart,thetaend,thetasteps,r,phi):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        theta_vector = linspace(thetastart,thetaend,thetasteps+1)
        z_vector = [0]
        data = self.create_data(x_vector,xname,dacx,theta_vector,'theta) (deg','AMI430',z_vector,'none','z_parameter')        # create data file, spyview metafile, copy script

        counter = 0

        for theta in theta_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self._set_3Dfield(r,theta,phi)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script

            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,theta,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile

            timetrack.remainingtime(starttime,thetasteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()

        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()



    # Scan dac as a function of phi angle at some fixed B value. Phi is defined wrt to positive x-axis. Written for raw mode of AMI430 driver
    def _dac_vs_phi(self,xname,dacx,xstart,xend,xsteps,phistart,phiend,phisteps,r,theta):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        phi_vector = linspace(phistart,phiend,phisteps+1)
        z_vector = [0]
        data = self.create_data(x_vector,xname,dacx,phi_vector,'phi) (deg','AMI430',z_vector,'none','z_parameter')        # create data file, spyview metafile, copy script

        counter = 0

        for phi in phi_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self._set_3Dfield(r,theta,phi)
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script

            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,phi,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile

            timetrack.remainingtime(starttime,phisteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()

        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()


    ################# SCANS TO MEASURE A 3 TERMINAL DEVICE BIASING TWO SIDES SIMULTANEOUSLY #########################

    def _dac_vs_dac_twosides(self,xname1,xname2,xstart,xend,xsteps,yname,dacy,ystart,yend,ysteps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ysteps+1)
        z_vector = [0]

        data_side1 = self.create_data(x_vector,xname1,biasdac,y_vector,yname,dacy,z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script all for lead1 measurement
        data_side2 = self.create_data(x_vector,xname2,biasdac,y_vector,yname,dacy,z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script all for lead2 measurement

        counter = 0

        for y in y_vector:

            [starttime, counter] = timetrack.start(counter)
            tstart=timetrack.time();
            ivvi.set(dacy,y)


            # switch on lead1, turn off lead2
            self.bias_switch('ON','ON','OFF',biasdac,controldac)
            dacx = biasdac

            for data_loop in (data_side1, data_side2):

                ivvi.set(dacx,x_vector[0])
                T_mc = self.read_T()                                                                                                                   # Read out mixing chamber temperature
                qt.msleep(delay1)

                for x in x_vector:
                    datavalues = self.take_data(dacx,x)                                                                                         # Go to next sweep value and take data
                    data_loop.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                       # write datapoint into datafile

                data_loop.new_block()

                ivvi.set(dacx,0)  # Set bias to zero before switch the controller in order to avoid the voltage jump.
                # switch off lead1, turn on lead2
                self.bias_switch('ON','OFF','ON',biasdac,controldac)


            tstop = timetrack.time()
            timetrack.remainingtime(starttime,ysteps+1,counter)                                                                                 # Calculate and print remaining scantime

        for data_loop in (data_side1, data_side2):
            data_loop._write_settings_file()                                                                                                    # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
            data_loop.close_file()

        qt.mend()


    def _dac_vs_2dacs_twosides(self,xname1,xname2,xstart,xend,xsteps,yname,dacy,ystart,yend,mname,dacm,mstart,mend,ymsteps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ymsteps+1)
        z_vector = [0]


        data_lead1 = self.create_data(x_vector,xname1,biasdac_lead1,y_vector,yname,dacy,z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script all for lead1 measurement
        data_lead2 = self.create_data(x_vector,xname2,biasdac_lead2,y_vector,yname,dacy,z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script all for lead2 measurement

        # Define sweep vector for other dac
        m_vector = linspace(mstart,mend,ymsteps+1)

        counter = 0

        for i in arange(len(y_vector)):

            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            y = y_vector[i]
            m = m_vector[i]
            ivvi.set(dacy,y)
            ivvi.set(dacm,m)


            # switch on lead1, turn off lead2
            self.bias_switch('ON','ON','OFF',biasdac_lead1,biasdac_lead2,controldac_lead1,controldac_lead2)
            dacx = biasdac_lead1


            for data_loop in (data_lead1, data_lead2):

                ivvi.set(dacx,x_vector[0])
                T_mc = self.read_T()                                                                                                                   # Read out mixing chamber temperature
                qt.msleep(delay1)

                for x in x_vector:
                    datavalues = self.take_data(dacx,x)                                                                                         # Go to next sweep value and take data
                    data_loop.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                       # write datapoint into datafile

                data_loop.new_block()

                # switch off lead1, turn off lead2
                self.bias_switch('ON','OFF','ON',biasdac_lead1,biasdac_lead2,controldac_lead1,controldac_lead2)
                dacx = biasdac_lead2

            tstop = timetrack.time()
            timetrack.remainingtime(starttime,ymsteps+1,counter)                                                                                 # Calculate and print remaining scantime

        for data_loop in (data_lead1, data_lead2):
            data_loop._write_settings_file()                                                                                                    # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
            data_loop.close_file()

        qt.mend()


    def _dac_vs_magnet_twosides(self,xname1,xname2,xstart,xend,xsteps,Bstart,Bend,Bsteps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        z_vector = [0]

        data_side1 = self.create_data(x_vector,xname1,biasdac,B_vector,'B (T)',magnet,z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script all for lead1 measurement
        data_side2 = self.create_data(x_vector,xname2,biasdac,B_vector,'B (T)',magnet,z_vector,'none','z_parameter')                                 # create data file, spyview metafile, copy script all for lead2 measurement

        counter = 0

        for B in B_vector:

            [starttime, counter] = timetrack.start(counter)
            tstart=timetrack.time();
            self.set_B(B)


            # switch on lead1, turn off lead2
            self.bias_switch('ON','ON','OFF',biasdac,controldac)
            dacx = biasdac

            for data_loop in (data_side1, data_side2):

                ivvi.set(dacx,x_vector[0])
                T_mc = self.read_T()                                                                                                                   # Read out mixing chamber temperature
                qt.msleep(delay1)

                for x in x_vector:
                    datavalues = self.take_data(dacx,x)                                                                                         # Go to next sweep value and take data
                    data_loop.add_data_point(x,B,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                       # write datapoint into datafile

                data_loop.new_block()
                ivvi.set(dacx,0)  # Set bias to zero before switch the controller in order to avoid the voltage jump.
                # switch off lead1, turn on lead2
                self.bias_switch('ON','OFF','ON',biasdac,controldac)
                dacx = biasdac

            tstop = timetrack.time()
            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime

        for data_loop in (data_side1, data_side2):
            data_loop._write_settings_file()                                                                                                    # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
            data_loop.close_file()

        qt.mend()


    # To scan a 3T device as a function of B from both sides simultaneously
    # added by onder 2015.10
    # swept dac values (dacx and dacx2) are the same!
    # use even-odd image processing feature!
    # even lines one lead, odd lines the other!
    # L1 output to 1a, 1b goes to N-lead1. L2 output to 2a, 2b goes to N-lead2.
    # S lead to 3b or 4a (shorted).3a to L1 input, 4b to L2 input.
    # control 1 = control 2 = controldac
    def _dac_vs_magnet_3T(self,xname,dacx,dacx2,xstart,xend,xsteps,Bstart,Bend,Bsteps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        B_vector = linspace(Bstart,Bend,Bsteps+1)
        z_vector = [0]

        data = self.create_data(x_vector,xname,dacx,B_vector,'B (T)',magnet,z_vector,'none','z_parameter')                                      # create data file, spyview metafile, copy script

        counter = 0

        for B in B_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            self.set_B(B)                                                                                                                       # Sets B field
            ivvi.set(controldac,1500)#for simultaneous 3T measurements: 1&3 conducts, 2&4 doesn't!
            ivvi.set(dacx,x_vector[0])#first dac hooked up to one side
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script

            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,B,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile

            ivvi.set(dacx,0)#set zero to avoid voltage jump

            #second for loop for the other side

            ivvi.set(controldac,-1500)#for simultaneous 3T measurements: 2&4 conducts, 1&3 doesn't!
            ivvi.set(dacx2,x_vector[0])#second dac hooked up to the other side
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script

            for x in x_vector:
                datavalues = self.take_data(dacx2,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,B,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile

            ivvi.set(dacx2,0)#set zero to avoid voltage jump

            #loop of other side ends here

            timetrack.remainingtime(starttime,Bsteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()

        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()


    # To scan a 3T device as a function of dacy from both sides simultaneously
    # added by onder 2015.10
    # swept dac values (dacx and dacx2) are the same!
    # use even-odd image processing feature!
    # even lines one lead, odd lines the other!
    # L1 output to 1a, 1b goes to N-lead1. L2 output to 2a, 2b goes to N-lead2.
    # S lead to 3b or 4a (shorted).3a to L1 input, 4b to L2 input.
    # control 1 = control 2 = controldac
    def _dac_vs_dac_3T(self,xname,dacx,xstart,xend,xsteps,yname,dacy,ystart,yend,ysteps):
        qt.mstart()

        # Create sweep vectors
        x_vector = linspace(xstart,xend,xsteps+1)
        y_vector = linspace(ystart,yend,ysteps+1)
        z_vector = [0]

        data = self.create_data(x_vector,xname,dacx,y_vector,yname,dacy,z_vector,'none','z_parameter')                                          # create data file, spyview metafile, copy script

        counter = 0

        for y in y_vector:
            [starttime, counter] = timetrack.start(counter)
            tstart = timetrack.time()
            ivvi.set(dacy,y)
            ivvi.set(controldac,1500)#for simultaneous 3T measurements: 1&3 conducts, 2&4 doesn't!
            ivvi.set(dacx,x_vector[0])
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script

            for x in x_vector:
                datavalues = self.take_data(dacx,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile

            ivvi.set(dacx,0)#set zero to avoid voltage jump

            #second for loop for the other side

            ivvi.set(controldac,-1500)#for simultaneous 3T measurements: 2&4 conducts, 1&3 doesn't!
            ivvi.set(dacx2,x_vector[0])#second dac hooked up to the other side
            T_mc = self.read_T()                                                                                                                # Read out mixing chamber temperature
            qt.msleep(delay1)                                                                                                                   # use explained at the bottom of the script

            for x in x_vector:
                datavalues = self.take_data(dacx2,x)                                                                                             # Go to next sweep value and take data
                data.add_data_point(x,y,0,datavalues[0],datavalues[1],datavalues[2],datavalues[3],datavalues[4],datavalues[5],datavalues[6],datavalues[7],datavalues[8],datavalues[9],T_mc)                           # write datapoint into datafile

            ivvi.set(dacx2,0)#set zero to avoid voltage jump

            #loop of other side ends here

            timetrack.remainingtime(starttime,ysteps+1,counter)                                                                                 # Calculate and print remaining scantime
            data.new_block()

        data._write_settings_file()                                                                                                             # Overwrite the settings file created at the beginning, this ensures updating the sweep variable with the latest value
        data.close_file()
        qt.mend()



#################### INITIALIZATION #########################





# TEMPERATURE READOUT, PLEASE SPECIFY THE APPROPRIATE OPTION BELOW:

    # Add new readout to 'read_T' function

    # 200S set up: 'cryocon'
    # F016 set up: 'lockin3' , make sure yo call the lockin used for T readout 'lockin3'!
    # no T readout: 'off'

# Treadout = 'cryocon'
Treadout = 'off'
#Treadout = 'lockin3'




# MAGNET SUPPLY

    # Add new type of supply to 'set_B' function

#magnet = 'kepco'
#magnet = 'OxfordMK3'
#magnet = 'OxfordMK3nodriver'
#magnet = 'AMI430'       # in raw mode right now, only up to 1T!

#magnet='cryomag'
# correction angles to set up a new coordinate frame.

#phi_correction = -33        # Correction angle in degrees counted from positive x-axis in the xy-plane.
#theta_correction = 10.5      # Correction angle in degrees counted from the positive z'-axis around y'-axis in the basis (x',y',z') which is transformed with the phi_correction angle.
phi_correction = 0
theta_correction = 0


'''
    # 2 TERMINAL READOUT

    # I made this function for a 3 terminal device to measure the current to ground via 2 terminals
    # if you bias via the 3th terminal.
    # Right now it only works if you measure with 2 lockins and 2 keithleys.
    # Column 4 (usual column) contains the data from Lockin1, column
    # 8 contains the data from Lockin2 (as usual), but corrected for gains and series resistances (unusual).
    # This way of implementing it is a bit lame, it would be better to store it in an extra column and also
    # store the raw data, something to be implemented in future.
#two_terminal_measurement = 'ON'                                 # Put 'ON' or 'OFF'


    # SWITCHING BIAS

    # This mode enables to actively switch between biasing 2 different leads of a 3 terminal device and measure the current
    # to ground via the 3rd of via both 2nd and 3 lead. To do this we use the U1 module, which consists of 2x an input connected
    # to an output via a MOSFET switch. The switch can be controlled by a low (no currentflow possible) or high (currentflow possible) voltage.
    #
    # Below a list of necessary parameters to operate this module has to be specified.

switch_bias = 'OFF'                          # If you use U1 module: always put this one 'ON' otherwise put 'OFF'
switch_bias_mode = 'FLOATING'               # two possible options: 'FLOATING' or 'TWOTERMINAL'
side1 = 'ON'                               # In case you want to measure via 1 lead, but you have the U1 module hooked up, specify here which
side2 = 'OFF'                                # one it will be. In case of 2 leads measurement, put lead1 on (saves one switch in the measure loop)
biasdac = 'dac1'                      # Specify the dac used for biasing lead1
#biasdac_lead2 = 'dac2'                      # Specify the dac used for biasing lead2
controldac= 'dac15'                  # Specify the dac used for controlling lead1
#controldac_lead2 = 'dac16'                  # Specify the dac used for controlling lead2

majorana().bias_switch(switch_bias,side1,side2,biasdac,controldac)

'''


# Lockin3
#amplitude3 = 0.01
#lockin3.set_amplitude(amplitude3)
#lockin3.set_frequency(11.677)
#lockin3.set_phase(0.0)
#lockin3.set_sensitivity(24)
#lockin3.set_tau(10)




# This delay is needed at the beginning of a sweep, a good value is ~ 10*tau. If you don't use it, first few datapoints of the sweep will be weird.
# It's safe to put it to 0 for Keithley measurements.

delay1 = 4.0

# Delay after setting dac during sweep, you should at least wait 1.5*tau, longer is better. This avoids integration over the previous dac value.
delay2 = 0.17

# DON'T SKIP THIS PART, ITS CRUCIAL FOR PROPER MEASUREMENTS AND DATA PROCESSING!!!



# Gains and ranges
# Please set the gains and ranges before starting measurements. This ensures proper scaling of axis and data in Spyview.
# Make sure that you put the right gain at the right Keithley/Lockin.
GainK1=1e6                       # Gain for Keithley 1
GainK2=1e6                       # Gain for Keithley 2
GainL1=1e6                       # Gain for Lockin 1
GainL2=1e6                       # Gain for Lockin 2
Vrange=10e-3                      # voltage range in V/V, first source
Vrange2=10e-3                      # voltage range in V/V, second source
Irange=100e-9                    # current range in A/V
BGrange=30                        # Gate range in V/V
Rfilter1 = 0                # series resitance of the fridge wire + filtering
Rfilter2 = 0                  # series resitance of the fridge wire + filtering
RsL1 = 2e3+GainK1*1e-3+Rfilter1   # Take care! this is only true if the M1b is set at low noise!
RsL2 = 2e3+GainK2*1e-3+Rfilter2

# INITIALIZATION OF THE LOCKINS

# Lockin1


#amplitude1 = 20e-6                                   # Excitation amplitude in V (this is the A from A*sin(omega*t+B) )
#lockin1.set_amplitude(amplitude1/(Vrange*1e-2*sqrt(2)))     # Calculates true output excitation voltage lockin
#lockin1.set_frequency(62.69)#37.09 37.13 77.17 117.13
#lockin1.set_phase(0.0)
#lockin1.set_sensitivity(19)                                 #16 good for 10 microV excitation #24 needed at high conductance!                  # Check S830 driver for the meaning of this number
#lockin1.set_tau(8)                                          # tau = 9 equals 300 ms, check S830 driver for other integration times


# Lockin2
#lockin2.set_mode(0)                                       # This command synchronizes lockin2 with lockin1
#amplitude2 = 50e-6                                           # Excitation amplitude in V (this is the A from A*sin(omega*t+B) )
#lockin2.set_amplitude(amplitude2/(Vrange2*1e-2*sqrt(2)))     # Calculates true output excitation voltage lockin
#lockin2.set_frequency(62.69)
#lockin2.set_phase(0.0)
#lockin2.set_sensitivity(19)                                 #16 good for 10 microV excitation #24 needed at high conductance!
#lockin2.set_tau(8)                # Check S830 driver for the meaning of this number

print '\nGainK1='+`GainK1`+'\t\tGain for Keithley 1\nGainK2='+`GainK2`+'\t\tGain for Keithley 2\nGainL1='+`GainL1`+'\t\tGain for Lockin 1\nGainL2='+`GainL2`+'\t\tGain for Lockin 2\nVrange='+`Vrange`+'\t\tVoltage range in V/V\nIrange='+`Irange`+'\t\tCurrent range in A/V\nBGrange='+`BGrange`+'\t\tGate range in V/V\n'
s=raw_input("Ensure smooth dataprocessing in spyview by checking if gains, Vrange, Irange and BGrange are stored correct. Press enter to continue, press any other key and enter to stop: ")
if s!='':
    print '\nVery kind of you to avoid future data processing problems.'
    time.sleep(3.0)
    sys.exit()

# DEFINE MEASUREMENT TYPE

    # LOCKIN VS KEITHLEY

    # Please update the number of Keithleys/Lockins used in the measurement, this ensures proper data readout and storage.
    # Remark: In the program its assumed that if you use a single Keithley, this one is Keithley 1. Same for the lockins.
    # To ensure proper data processing, we encourage reading the 'take_data' function above.

Nkeithleys = 2     # Allowed values: 0,1,2
Nlockins = 0    # Allowed values: 0,1,2

#filename = timestamp+'_'+ 'W06N2S' # bias gnd float (col 6) 18 19 17

#################### MEASUREMENTS #########################
m = majorana()

ivvi.set_parameter_rate('dac1',1.220703,5)
qt.msleep(0.01)
ivvi.set_parameter_rate('dac2',1.220703,5)
qt.msleep(0.01)
GateAmp = BGrange
dacIncrement = 0.06103515625 #in mV or in dac
GateRampRate = 0.04#V per second
GateRampWaitTime = dacIncrement / (GateRampRate/GateAmp)# in ms
for i in range(3,8):
    ivvi.set_parameter_rate('dac' + `i`,dacIncrement,GateRampWaitTime)
    qt.msleep(0.01)

GateAmp = 5
dacIncrement = 0.06103515625 #in mV or in dac
GateRampRate = 0.08#V per second
GateRampWaitTime = dacIncrement / (GateRampRate/GateAmp)# in ms
for i in range(4,8):
    ivvi.set_parameter_rate('dac' + `i`,dacIncrement,GateRampWaitTime)
    qt.msleep(0.01)
	
ivvi.set_parameter_rate('dac3', 10, 60)

ivvi.get_dac1()
ivvi.get_dac2()
ivvi.get_dac3()
ivvi.get_dac4()
ivvi.get_dac5()
ivvi.get_dac6()
ivvi.get_dac7()
ivvi.get_dac8()


filename ='1671_wire4_BG'
#filename ='R9R10_IV'
#m._time_sweep(time_steps=3000, time_interval=1)
#ivvi.set_dac3(200)
#m._single_dac_sweep('bias(10mV/V)','dac1',-1000,1000,250)
ivvi.set_dac1(1000)
m._single_dac_sweep('BG x30V','dac3',500,-50,550)
m._single_dac_sweep('BG x30V','dac3',-50,500,550)
#ivvi.set_dac1(0) # grsaound after measurement
#offset = -665
ivvi.set_dac1(200)
m._single_dac_sweep('BG x30V','dac3',500,-50,550)
m._single_dac_sweep('BG x30V','dac3',-50,500,550)
ivvi.set_dacs_zero()

# remark: You cannot take more than 16 pnts/mV on a dac. 4000mV/2^16 = 0.061, below that stepsize you hit dac quantization.
#m._dac_vs_magnet('VBias','dac1',-60,80,140,0.0,1.0,20)
#m._2dacs_vs_magnet('Vbias','dac1','dac2',-300,300,300,0.0,2.0,80)
#m._dac_vs_dac('Vbias(100mV/V)','dac1',-300,300,600,'BG(30V/V)','dac3',100,1000,450)
#m._2dacs_vs_dac('Vbias','dac1','dac2',-500,500,500,'BG','dac3',-650,100,375)
#m._2dacs_vs_2dacs('Vbias','dac1','dac2',-250,250,500,'Gt3','dac8',0,-150,'Gt2','dac6',50,-400,200)
#m._2dacs_vs_3dacs('Vbias','dac1','dac2',-64,76,150,'Gs','dac3',-666.66,-1000,'Gt1','dac5',-210,-170,'Gt2','dac6',-325,-225,50)
#m._single_dac_sweep('T','dac4',-300,200,250)
#m._2dacs_sweep('Vbias','dac1',-100,100,'Vbias','dac2',-100,100,200)
#m._3dacs_sweep('BG1','dac8',0,400,'BG2','dac9',0,400,'BG3','dac10',0,400,200)
#m._dac_vs_3dacs('Vbias','dac1',-200,200,200,'BG1','dac8',0,400,'BG2','dac9',0,400,'BG3','dac10',0,400,200)
#m._dac_vs_2dacs('Vbias','dac1',-200,200,200,'BG2','dac9',0,400,'BG3','dac10',0,400,200)
#m._dac_vs_4dacs('Vbias','dac1',-40,60,100,'Gs1','dac5',-200,200,'Gst','dac6',-200,200,'Gs2','dac7',-200,200,'Gt3','dac8',-150,-250,100)
#m._set_3Dfield(0,0,0)  #r, theta, phi
#m._dac_vs_3Dmagnet('Vbias','dac1',-65,65,200,0,1,40,90,175) #sweep from 0 to 1 T e_x+e_y direction     m._dac_vs_3Dmagnet(self,xname,dacx,xstart,xend,xsteps,Bstart,Bend,Bsteps,theta,phi):
#m._dac_vs_phi('Vbias','dac1',-65,65,150,0,360,180,0.8,90)
#m._dac_vs_theta('Vbias','dac1',-65,65,200,180,0,90,0.73,80)

