# XR Framework Guide

## Hardware 

* Soft robot actuator with proprioception with USB connection
* Ubuntu Computer, with Linux (tested in v16.04 LTS) and ROS (tested in Kinetic)
* Windows Computer with latest UNITY
* Hololens 2 device

## Software

* Code repository contains a zip file of two main components:
  * UNITY side [unity_gripper_visualizer]
    * Contains precompiled .exe files (PC_AR_executable), this program can be directly loaded into a hololens that is connected to Unity - [instructions can be found here](https://docs.microsoft.com/en-us/windows/mixed-reality/develop/unity/unity-development-overview?tabs=arr%2CD365%2Chl2)
      * this is the unity-side portion of the demo shown in the supplementary data, which contains a basic scene setup with one simple bellow actuator, rigged and pre-skinned, and correctly set up communication to listen to the correct MQTT port to receive live animation data.
    * Also contains the source [UnityProject]  (C# files, 3D models ,etc) that handle the [DTStacks](https://github.com/fate4gle/DTStacks) connection to receive the animation data, as well as the base scripts that use that to animate and set up the 3D scene, which can be used as a reference for custom Unity side changes (different models, more visualizations, different scenes, etc.)
  * ROS side [soft_gripper]
    * This folder contains the python ROS node which contains the actuator side processing of the pipeline (refer to figure 2 of the paper)
      * inside src/scripts we have two ROS python scripts
        * sensor_serial_streamer.py -> runs in "demo" mode where is just publishes logged data (in dataset) and publishes it to the NN node, or reading sensor data from the serial port
        * soft_gripper_node.py -> this contains the NN and postprocessing steps of the pipeline, where it will receive raw data from serial streamer via a ROS topic, preprocess it,  feed it into the FFNN and get the bone estimation parameters. more detail is explained in the code. 
      * CmakeLists and the package xml file allow it to be indexed and started once a ROS distribution is configured on the ubuntu system

_____

## Start Up

##### Unity

1. Connect [hololens to unity computer](https://docs.microsoft.com/en-us/windows/mixed-reality/develop/unity/unity-development-overview?tabs=arr%2CD365%2Chl2)
2. Set up [DTSacks](https://github.com/fate4gle/DTStacks)
3. run pre-built exe or customize scene

##### ROS

1. Install and setup ROS in Ubuntu computer:

   * Start with  installing ROS kinetic:

     * [Installation on ubuntu](https://wiki.ros.org/kinetic/Installation/Ubuntu)

     * setup an **alias for check env vars**

       * in your bash configs:

       * ```bash
         alias rosenv='export | grep ROS'
         ```


     * source your bash setup  (if not commands or packages cannot be found)

       ```bash
       # default workspace 
       source /opt/ros/ROS_VERSION/setup.bash
       # or your particular workspace
       source /MY/PATH/TO/CATKIN/devel/setup.bash
       
       ```

   * Then, create a new ROS workspace

     * Creating a **catkin_ws** workspace:

       ```bash
       mkdir -p ~/catkin_ws/src
       cd ~/catkin_ws/
       catkin_make # should produce build/ & devel/
       
       # setup and source your new workspace
       source devel/setup.bash
       
       # you can verify workspace is properly overlayed
       echo $ROS_PACKAGE_PATH
       ```

   * Finally copy the framework (soft_gripper) ROS folder into the into src of new workspace

   * Once the workspace has been rebuilt, all packages can be used at convenience:

     * 

       ```bash
       # checking dependencies (again: replace '$ROS_DISTRO' (melodic) with the ROS version you are using)
        update
       rosdep install --rosdistro $ROS_DISTRO --ignore-src --from-paths src
       
       # building
       catkin_make
       
       # activate this workspace
       source ~/catkin_ws/devel/setup.bash
       ```

       

2. Power proprioceptive sensor and connect to  ROS computer (skip this step if using demo data)

3. Activate the [MQTT configuration using package mqtt bridge](http://wiki.ros.org/mqtt_bridge)

   1. use the following launch file to trigger:

      ```xml
      <launch>
        <arg name="use_tls" default="false" />
        <node name="mqtt_bridge" pkg="mqtt_bridge" type="mqtt_bridge_node.py" output="screen">
          <rosparam command="delete" param="" />
          <rosparam command="load" file="$(find mqtt_bridge)/config/UnityBridge_params.yaml" />
          <rosparam if="$(arg use_tls)" command="load" ns="mqtt" file="$(find mqtt_bridge)/config/UnityBridge_tls_params.yaml" />
        </node>
      </launch>
      ```

      

4. with an activated ROS workspace, launch two separate shells:

   1.  shell 1: trigger the sensor_serial  node with:

      * ````bash
        rosrun soft_gripper sensor_serial_streamer.py
        ````

   2. shell 2: trigger the soft_gripper node with: 

      * ````bash
        rosrun soft_gripper soft_gripper_node.py
        ````

5. You should now be streaming data and have the full pipeline running





## 