using System;
using UnityEngine;
using DTStacks.DataType.Templates;
using DTStacks.DataType.Generic.Geometry;
using DTStacks.DataType.Generic.Helpers;
using DTStacks.DataType.Generic.Math;
using DTStacks.DataType.Generic.Navigation;

using DTStacks.DataType.ROS.Messages.std_msgs;
using DTStacks.DataType.ROS.Messages.nav_msgs;
using DTStacks.DataType.ROS.Messages.geometry_msgs;
using DTStacks.DataType.ROS.Messages.sensor_msgs;

namespace DTStacks.DataType.Generic.Custom
{
    /// <summary>
    /// Custom joint state message, non-identical to the typical joint state message in ROS.
    /// The JSON parser in Unity is capable of overwriting only parts of the received JSON if a suitable class is available.
    /// E.g. Only the float[] position while header etc. is ignored.
    /// </summary>
    [Serializable]
    public class Softgripper4Joint : Message
    {
        public float[] position;

        //Initializing the msg for all availble data point (5x (position[XYZ], rotation[XYZ])
        public Softgripper4Joint()
        {
            position = new float[30]; 
        }
    }
}
