#! /usr/bin/env python

import rospy
import rospkg
import os
import serial
import numpy as np
import random

from std_msgs.msg import String
import time

# Reads serial com port and streams it data to sg_sensor_data_raw (as string)

# ros pub & serial global variables
pub = rospy.Publisher('sg_sensor_data_raw', String, queue_size=10)
ser = serial.Serial( port =None, baudrate = 9600, timeout = 10) # "/dev/ttyUSB0"

# get package location
r = rospkg.RosPack()
path = r.get_path('soft_gripper')
# print(path)
logged_data = np.loadtxt(open( path + "/src/scripts/sensorData_only.csv", "rb"), delimiter=",", dtype=int) # 1k datapoints (1k x 16)
seq_logged_data = np.loadtxt(open( path + "/src/scripts/sequential_data.csv", "rb"), delimiter=",", dtype=int) # 600 sequential datapoints (600 x 16)
rospy.init_node("soft_gripper_sensor_data")
rate = rospy.Rate (30)                # We create a Rate object of 30/60Hz
 
seq_index = 0
 

# Read the next line from the serial port
# Sensor data matrix(sensor_num, 4) (sensor number for now is 4)
# and update topic output
def serial_to_topic():
    # Read one line
    line_bytes = ser.readline()
    # If the line is not empty
    if len(line_bytes) > 0:
        # Convert the bytes into string
        line = line_bytes.decode('utf-8')
        

        # actuator data publishing as a space separated string
        pub.publish( "{}".format(line))

# use logged sensor data to publish
# data in  "simulation" mode  
def pub_logged_data(): 
  
  global seq_index, seq_logged_data

  if (seq_index == 600):
    seq_index = 0
    time.sleep(10)
  
  pub.publish( "{}".format( seq_logged_data[seq_index] ) )
  seq_index += 1

while not rospy.is_shutdown():     # Endless loop until Ctrl + C
 
   # sensor topic data (float array published as string)
   # serial_to_topic()
   # "simulation mode"
   pub_logged_data()

   # sleep the needed time to maintain the Rate fixed above
   rate.sleep()  
                     
    
# this program creates an endless loop that repeats itself fixed times per second (1-600Hz)
# until somebody presses Ctrl + C in the Shell