"""
Some of the data are stored in different structures. This will contain a function
to read from each of the structures.
"""
import json
import numpy as np
import pandas as pd


def read_simple_tabular_structure(filename: str) -> pd.DataFrame:
    """
    For VQE magic, exact diagonalisation, and perhaps more TODO: check this.
    """
    xs = []
    ys = []
    with open(filename, "r") as f:
        for line in f:
            x, y = line.split()
            xs.append(float(x))
            ys.append(float(y))
    return pd.DataFrame({'xs': xs, 'ys': ys})


def read_wavefunction_into_df(filename: str, n_qubits=8) -> pd.DataFrame:
    # Count the number of lines to induce the range of h. Assumes equally 
    # spaced from 0 to 3
    n_lines = 0
    with open(filename, "r") as f:
        for line in f:
            n_lines +=1 
    n_hs = int(n_lines/(2**n_qubits))
    hs = np.linspace(0,3,n_hs)
    df = pd.DataFrame(columns=[f'{h:.3f}' for h in hs])
    columns = df.columns
    counter = 0
    data = []
    with open(filename, "r") as f:
        for line in f:
            try:
                # TODO: test this version
                real, imag = line.split()
                data.append((float(real)**2 + float(imag)**2)**0.5)
            except ValueError:
                data.append(abs(float(line.strip())))
            counter += 1
            if counter % (2**n_qubits) == 0:
                h_idx = int(counter/(2**n_qubits) - 1) 
                df[columns[h_idx]] = data
                data = []
    return df

                    
if __name__ == "__main__":
    read_wavefunction_into_df("../data/8_qubits/DMRG/wavefunctions.dat")
    #print(read_simple_tabular_structure("../data/8_qubits/exact_diagonalisation/exact_diagonalisation_energies.dat"))
    #print(read_simple_tabular_structure("../data/8_qubits/VQE/exact_expectations__magic_adam-4.dat"))
    #print(read_simple_tabular_structure("../data/8_qubits/VQE/measured_expectations__energies_adam-3_layers.dat"))
