"""
The stopping criteron will be two consecutive runs of Adam agreeing with 
each other.

Output is a json object.

NOTE that Adam is hard coded as the optimiser
"""
import pennylane as pl
import numpy as np
import os
import json
import sys
from tqdm import tqdm

# Get my custom modules
from modules import vqe, Hamiltonian_terms, optimisation


def main():
    # Recover some parameters from the command line
    if len(sys.argv) != 3:
        print(f"Please provide more command line arguements. Expected: mu (float), number of repeats (int). Exiting code...")
        return
    mu = float(sys.argv[1])
    repeat_idx = int(sys.argv[2]) 

    #Set the rest of the configuration parameters
    optimiser = 'adam'  # this is hard coded, so changing this does nothing
    n_vqe_layers = 4
    J = -1 # Hamiltonian parameter
    n_qubits = 2
    consecutive_agreement_tolerance = 1e-4
    save_data = True


    output_directory = f"./outputs/{n_qubits}_qubits/"    
    output_filename = f"{output_directory}energies_and_parameters_{optimiser}-{n_vqe_layers}_layers_mu-{mu:.3f}_repeat-{repeat_idx}.out"


    # Check file can be written to 
    if not os.path.exists(output_directory):
        os.mkdir(output_directory)


    # Constructs for logging the outputs
    configuration_details = {}
    configuration_details['optimiser'] = optimiser
    configuration_details['n_vqe_layers'] = n_vqe_layers
    configuration_details['J'] = J
    configuration_details['n_qubits'] = n_qubits
    configuration_details['consecutive_agreement_tolerance'] = consecutive_agreement_tolerance
    output_data_as_json = {}
    output_data_as_json['configuration'] = configuration_details
    output_data_as_json['results'] = {}


    # Optimise parameters to lower energy
    data_for_mu_value = {}
    optimal_parameters, minimum_energy = \
        optimisation.get_minimum_energy_and_parameters_vqe_consecutive_agreement(
                        J,
                        mu,
                        n_qubits,
                        n_vqe_layers,
                        consecutive_agreement_tolerance)
    data_for_repeat = {}
    data_for_repeat['parameters'] = optimal_parameters.tolist()
    data_for_repeat['energy'] = minimum_energy.numpy()
    data_for_mu_value[f'run_{repeat_idx:.0f}'] = data_for_repeat
    output_data_as_json['results'][f'mu_{mu:.3f}'] = data_for_mu_value
    if save_data:
        with open(output_filename, "a+") as f:
            json.dump(output_data_as_json, f, indent=4)
    return


if __name__ == "__main__":
    main()
