import pennylane as pl
import scipy
import numpy as np
from tqdm import tqdm
import os
import sys
sys.path.append("../VQE/modules")
import Hamiltonian_terms


def main():
    n_qubits = 4
    J = -1
    h_min = 0
    h_max = 3
    n_hs = 13
    output_directory = f'./outputs/{n_qubits}_qubits/'
    wavefunction_output_directory = f'{output_directory}/wavefunctions/'

    # Check file can be written to 
    if not os.path.exists(output_directory):
        os.mkdir(output_directory)
    if not os.path.exists(wavefunction_output_directory):
        os.mkdir(wavefunction_output_directory)

    output_filename = f"{output_directory}analytic_energies.out"
    f = open(output_filename, "w+")


    for h in tqdm(np.linspace(h_min,h_max,n_hs)):

        # Solve system
        Hamiltonian = Hamiltonian_terms.transverse_Ising_Hamiltonian(
                                    n_qubits, 
                                    J, 
                                    h)
        eigvals, eigvects = scipy.sparse.linalg.eigsh(Hamiltonian.sparse_matrix())
        ground_state_energy = min(eigvals)

        # Write out energies
        f.write(f"{h:f}\t{ground_state_energy}\n")
        ground_state_index = np.where(eigvals == ground_state_energy)

        # Write out wavefunctions
        ground_state_wavefunction = eigvects[:,ground_state_index]
        wavefunction_output_filename = f"{wavefunction_output_directory}/analytic_result_h_{h:f}.dat"
        wf = open(wavefunction_output_filename, "w+") 
        for amplitude in ground_state_wavefunction:
            wf.write(f'{amplitude.real[0,0]}\t{amplitude.imag[0,0]}\n')
        wf.close()
    f.close()
    return


if __name__=="__main__":
    main()
