using ITensors, ITensorMPS, DelimitedFiles

function generate_all_sequences(length::Int, symbols::Array{String})
    if length == 0
        return [""]
    end

    sequences = []
    smaller_sequences = generate_all_sequences(length - 1, symbols)

    for symbol in symbols
        for seq in smaller_sequences
            push!(sequences, symbol * seq)
        end
    end

    return sequences
end

function from_string_to_MPO(N::Int64, all_Pauli_strings::Vector{Any})
    all_Pauli_MPOs = similar(all_Pauli_strings)
    sites = siteinds("S=1/2", N)
    for i in eachindex(all_Pauli_strings)
        mpo = OpSum()
        for (qubit, gate) in enumerate(all_Pauli_strings[i])
            mpo += gate*"", qubit
        end
        all_Pauli_MPOs[i] = MPO(mpo, sites)
    end
    return all_Pauli_MPOs
end

function from_string_to_integers(N::Int64, all_configurations::Vector{Any})
    all_configurations_as_ints = zeros(Int64, 2^N, N)
    for (config_idx, configuration) in enumerate(all_configurations)
        for (idx, char) in enumerate(configuration)
            all_configurations_as_ints[config_idx,idx] = parse(Int64, string(char))
        end
    end
    return all_configurations_as_ints
end

#=
strings = generate_all_sequences(4, ["X", "Y"])
@show size(strings)
mpos = from_string_to_MPO(4, strings)
@show mpos[1]
@show size(mpos)
@show typeof(mpos)
configs = generate_all_sequences(4, ["1", "2"])
configs_as_ints = from_string_to_integers(4, configs)
@show configs_as_ints
=#
