# Accompanying materials for: Quantum resources of quantum and classical variational methods

### Contributing authors: Thomas Spriggs, Arash Ahmadi, Bokai Chen, and Eliska Greplova.
### Affiliation: QuTech and Kavli Institute of Nanoscience, Delft University of Technology, Delft, the Netherlands

This repo contains the code used to generate and analyse the data presented in the paper: LINK TO PAPER WHEN DONE.
These materials are also available on Zenodo at https://doi.org/10.5281/zenodo.13759651.

## Citing 
If you use this work in a way that leads to a scientific publication, please cite the paper and Zenodo repository as:
TODO once paper has been published and links are available.


## Repository layout
The repo is split into two main parts, they will be outlined here and then explained in subsequent sections.

* `src/` containing
    * Code for finding the ground state of the transverse-field Ising model (TFIM) using:
        * `DRMG/` Density matrix renormalisation group
        * `ED/` Exact diagonalisation
        * `RBM/` Variational Monte Carlo using a restricted Boltzmann machine
        * `VQE/` Variational quantum eigensolver
    * `magic/` Code for computing the magic of the ground states found.
    * `utils/` Code for computing the infidelity of the ground states with respect to another ground state.
* `visualisation/` containing
    * `VQE_RBM_comparison_dashboard/` An interactive dashboard used to help guide analysis throughout this work.
    * `VQE_RBM_comparison_notebooks/` The code used to generate the figures from the paper.
    * `data/` Containing all of the data used for the dashboard and notebooks. Slightly more than just the data for the paper figures.

## Requirements
All codes in this repo use Python unless stated otherwise.

As for requirements, a working state for all python codes can be achieved, for linux users at least, using the following:
* Create a conda environment with python version 3.10 using `conda create -n QuantResourceEvn python=3.10`.
* Activate this environment and `pip` install the provided `requirements.txt` file. `conda activate QuantResourceEvn; pip install -r requirements.txt`.

This is certainly not the only working configuration, but it is at least something to start with.

As for the one piece of Julia code, you can download a current versin of Julia at https://julialang.org/downloads/, and follow the installation instructions from the ITensor site here (https://itensor.org/). This work was perfomed with the Julia version 1.10.3+0.x64.linux.gnu and the ITensor version ITensors v0.6.4.

## Exploring the existing data yourselves

To further analyse the data from this work you can access it at `visualisation/data/`. In this directory you will find the directory structure (hopefully) self explanatory. However, the structure of the data within each type of file could perhaps do with some explanation.
* Files containing 'energy' or 'energies' are formatted:
    * transverse field strength \t energy
* Unless, the filename also ends with 'errors', in which case they are simply
    * transverse field strength \t error in energy
* This structure is replicated across the files containing 'magic' and 'infidelity' (and their corresponding error files).
* Files containing 'wavefunction' are used in the dashboard but not the notebooks (or paper figures). These are formatted as follows:
    for an N qubit system, the first 2^N lines are the amplitudes of the wavefunction at a given field strength (always starting at 0).
    The ordering of these amplitudes is lexicographical order, i.e. for N=2 it would be the amplitudes corresponding to the following:
        00
        01
        10
        11
    eigenstates in the computational basis.

    This structure repeats and the next 2^N lines are the amplitudes for the next value of field strength. The field strengths are always equally spaced.

    The field strengths always range [0,3] and thus the values of field strength for each wavefunction can be recovered by dividing the range [0,3] into the number of blocks, sized 2^N, in the file.
    Note that these are only provided for the 8 qubit simulations. 

The dashboard can be run using `python dashboard.py` from within `visualisation/VQE_RBM_comparison_dashboard/`. There may be some (non-breaking) errors whilst running the dashboard, but these don't prevent data from appearing (unless you try and plot the wavefunctions of the 12 qubit simulations, this data does not exist).

## Generating new data

Contained in `src/` are a collection of scripts used to find an approximate ground state of the TFIM and compute its energy and magic. Care has been taken to provide flexibility when reusing these codes, but a few things are not automatic in the current form: computing the magic and infidelity require changing some filepaths locally.

Finding the approximate ground states and their energies is done, for each method **from within the respective directories**, by:

* `DMRG/` *(Using Julia)* Running `julia tfim.jl`. This is the least-well-written script of the lot due to my unfamiliarity with Julia. Some care must be taken to extend this to more than 8 or 12 qubits. This is elucidated in the code itself. 
    * No input is required. Parameters such as the number of qubits, N, can be changed within `tfim.jl`.
    * The output is stored in `src/DMRG/outputs/<N>_qubits/`, where N depends on the number of qubits you chose. (You must make the `<N>_qubits` directory first! Sorry about that, this will be the only time that happens.)
* `ED/` Run `python get_energies_and_wavefunctions.py`.
    * No input is required. Parameters such as the number of qubits, N, can be changed within `get_energies_and_wavefunctions.py`.
    * The output is stored in `src/ED/outputs/<N>_qubits/`, where N depends on the number of qubits you chose. 
* `RBM/` Run `python main.py`.
    * No input is required. More parameters are available within `main.py`, such as setting the ansatz to be the symmetricRBM, or increasing alpha.
    * The output is stored in `src/RBM/outputs/<N>_qubits/` with a name that reflects the hyperparameters chosen.
* `VQE/` Run `python optimise_and_return_parameters.py` to find the quantum circuit parameters that generates the ground state along with its energy. Afterwards, run `python from_parameters_to_states.py` to generate the corresponding wavefunction.
    * No input is required for `optimise_and_return_parameters.py`, the input for `from_parameters_to_states.py` is automatically the output to `optimise_and_return_parameters.py`.
    * Both outputs are also stored in `src/VQE/outputs/<N>_qubits/`.
    * NOTE: I erred on the side of caution with the outputs of `optimise_and_return_parameters.py`. If you run the code with the same output filenames as some that already exist then it will append the data to this file rather than deleting any existing data. As a result, the file will not be a valid JSON and running `from_parameters_to_states.py` will lead to a `json.decoder.JSONDecodeError`. This can be managed by manually deleting the unwanted, JSON format breaking, data from the file being loaded.

The number of qubits and transverse field strengths set in these codes are reduced to allow for local use. All other hyperparameters are kept as was set for generating the data in the paper.

To compute the magic of each state you must do a little work. It is the same code used to compute the magic of the ground state for each method, so you must point the magic code to the method whose magic you want to compute. An example is given in `src/magic/example_magic_computation.py`.

Likewise for the infidelity, the code for this can be found in `src/utils/compute_infidelity.py`, and it will require changing some filepaths. It is currently written for the symmetric RBM as an example.

