import numpy as np
from numpy.linalg import matrix_power
import scipy.sparse
import itertools

from tqdm.auto import tqdm
from numpy import linalg as LA
import pandas as pd
import multiprocessing
import cirq
from cirq.circuits import InsertStrategy
from scipy.sparse import csr_matrix
from scipy import sparse
import qiskit 









# #function of calculating Renyi entropy for certain depth or number of the T-gates
def function (depth):
    N=16
    qubits = [cirq.LineQubit(i) for i in range(N)]

    circuit = cirq.Circuit()

    
    Hadamard = cirq.H
    Phase = cirq.S
    T_gate = cirq.T
    X = cirq.X
    Z = cirq.Z
    Y = cirq.Y
    I_gate = cirq.I
    CNOT = cirq.CNOT
    single_gates = [Hadamard,Phase,X,Z,Y,I_gate]
    
    S_Az = []
    S_Bz = []
    S_ABz = []   
    II2 = []
    II4 = []
    
    S2_AA = []
    S2_BB = []
    S2_AABB = []
    S2_AA_N8 = []
    S2_BB_N8 = []
    S2_AABB_N8 = []
    S4 = []
    rep =0
    while rep<500:
        
        circuit = cirq.Circuit()  
    
    
        #producing the random Clifford circuit with certain depth   
        if depth==0:
            for d in range(5):
                
                depthC = 40
                for dd in range(depthC):
                    # print(dd)
                    q = np.random.randint(0,len(single_gates),N)
                    for i in range(N):
                        circuit.append(single_gates[q[i]].on(qubits[i]), strategy=InsertStrategy.NEW)


                    control = []            
                    while len(control)<3:
                        qq = np.random.randint(0,N,2)
                        if qq[0] != qq[1]:
                            control.append(qq)
                            circuit.append(CNOT.on(qubits[qq[0]],qubits[qq[1]]), strategy=InsertStrategy.NEW)
            
        else:
            for d in range(depth):
                
                depthC = 60-depth 
                for dd in range(depthC):
                    
                    q = np.random.randint(0,len(single_gates),N)
                    for i in range(N):
                        circuit.append(single_gates[q[i]].on(qubits[i]), strategy=InsertStrategy.NEW)


                    control = []            
                    while len(control)<3:
                        qq = np.random.randint(0,N,2)
                        if qq[0] != qq[1]:
                            control.append(qq)
                            circuit.append(CNOT.on(qubits[qq[0]],qubits[qq[1]]), strategy=InsertStrategy.NEW)
           
                        
                if np.random.rand()<1:
                    t_rand = np.random.randint(0,N,1)
                    circuit.append(T_gate.on(qubits[t_rand[0]]), strategy=InsertStrategy.NEW)
                
            
    

        


        
        s=cirq.Simulator()
        results=s.simulate(circuit)
        
        # final state of the circuit
        psi = np.array(results.final_state_vector)

        # A subsytem by partial tracing over the rest of the system and calculating 2 and 4 renyi entropy
        rho_A = qiskit.quantum_info.partial_trace(psi,[i for i in range(int(N/4),N)])
        S2_A = -np.log2(rho_A.purity().real)
        S2_AA.append(S2_A)
        S4_A = -(1/3)*np.log2(np.trace(np.array(rho_A)@np.array(rho_A)@np.array(rho_A)@np.array(rho_A)).real)
        
        # B subsytem by partial tracing over the rest of the system and calculating 2 and 4 renyi entropy
        rho_B = qiskit.quantum_info.partial_trace(psi,[i for i in range(0,N-int(N/4))])
        S2_B = -np.log2(rho_B.purity().real)
        S2_BB.append(S2_B)
        S4_B = -(1/3)*np.log2(np.trace(np.array(rho_B)@np.array(rho_B)@np.array(rho_B)@np.array(rho_B)).real)
        
        # AB subsytem by partial tracing over the rest of the system and calculating 2 and 4 renyi entropy
        rho_AB = qiskit.quantum_info.partial_trace(psi,[i for i in range(int(N/4),N-int(N/4))])
        S2_AB = -np.log2(rho_AB.purity().real)
        S2_AABB.append(S2_AB) 
        S4_AB = -(1/3)*np.log2(np.trace(np.array(rho_AB)@np.array(rho_AB)@np.array(rho_AB)@np.array(rho_AB)).real)
        S4.append(S4_AB)

        # Mutual information for A and B for 2 Renyi entropy
        I2 = S2_A+S2_B-S2_AB
        II2.append(I2)

        # Mutual information for A and B for 2 Renyi entropy
        I4 = S4_A + S4_B - S4_AB
        II4.append(I4)
        
        #######################################################
        # |A|=|B|=N/8 subsysytem
        # only applies for 8 and 16 qubit systems
        rho_A_N8 = qiskit.quantum_info.partial_trace(psi,[i for i in range(int(N/8),N)])
        S2_A_N8 = -np.log2(rho_A_N8.purity().real)
        S2_AA_N8.append(S2_A_N8)

        rho_B_N8 = qiskit.quantum_info.partial_trace(psi,[i for i in range(0,N-int(N/8))])
        S2_B_N8 = -np.log2(rho_B_N8.purity().real)
        S2_BB_N8.append(S2_B_N8)

        rho_AB_N8 = qiskit.quantum_info.partial_trace(psi,[i for i in range(int(N/8),N-int(N/8))])
        S2_AB_N8 = -np.log2(rho_AB_N8.purity().real)
        S2_AABB_N8.append(S2_AB_N8) 
        #######################################################

        # Spin measurement for A and B systems for Kurtosis analysis
        a = cirq.LineQubit.range(N)
        sz_A = sum([Z(a[i]) for i in range(int(N/4))])
        sz_B = sum([Z(a[N-i-1]) for i in range(int(N/4))])
        sz_AB = sz_A+sz_B
        #  Adjust the number of Qubits for this part, here it is for 16 qubits
        Sz_A = sz_A.expectation_from_state_vector(np.array(psi)/np.linalg.norm(np.array(psi)),qubit_map={qubits[0]:0,qubits[1]:1,qubits[2]:2,qubits[3]:3,qubits[4]:4,qubits[5]:5,qubits[6]:6,qubits[7]:7,qubits[8]:8,qubits[9]:9,qubits[10]:10,qubits[11]:11,qubits[12]:12,qubits[13]:13,qubits[14]:14,qubits[15]:15})
        Sz_B = sz_B.expectation_from_state_vector(np.array(psi)/np.linalg.norm(np.array(psi)),qubit_map={qubits[0]:0,qubits[1]:1,qubits[2]:2,qubits[3]:3,qubits[4]:4,qubits[5]:5,qubits[6]:6,qubits[7]:7,qubits[8]:8,qubits[9]:9,qubits[10]:10,qubits[11]:11,qubits[12]:12,qubits[13]:13,qubits[14]:14,qubits[15]:15})
        Sz_AB = sz_AB.expectation_from_state_vector(np.array(psi)/np.linalg.norm(np.array(psi)),qubit_map={qubits[0]:0,qubits[1]:1,qubits[2]:2,qubits[3]:3,qubits[4]:4,qubits[5]:5,qubits[6]:6,qubits[7]:7,qubits[8]:8,qubits[9]:9,qubits[10]:10,qubits[11]:11,qubits[12]:12,qubits[13]:13,qubits[14]:14,qubits[15]:15})
        S_Az.append(Sz_A.real)
        S_Bz.append(Sz_B.real)
        S_ABz.append(Sz_AB.real)
        
        
   
        rep += 1
        
        
        
       
    

    
    #Saving the data   
    pd.DataFrame(np.array(II2)).to_csv(f'Data/I2_{depth}_N{N}.csv')
    pd.DataFrame(np.array(S4)).to_csv(f'Data/S4_{depth}_N{N}.csv')
    pd.DataFrame(np.array(S_Az)).to_csv(f'Data/S_Az{depth}_N{N}.csv')
    pd.DataFrame(np.array(S_Bz)).to_csv(f'Data/S_Bz{depth}_N{N}.csv')
    pd.DataFrame(np.array(S_ABz)).to_csv(f'Data/S_ABz{depth}_N{N}.csv')
    pd.DataFrame(np.array(II4)).to_csv(f'Data/I4_{depth}_N{N}.csv')
    pd.DataFrame(np.array(S2_AA)).to_csv(f'Data/S2_A_{depth}_N{N}.csv')
    pd.DataFrame(np.array(S2_BB)).to_csv(f'Data/S2_B_{depth}_N{N}.csv')
    pd.DataFrame(np.array(S2_AABB)).to_csv(f'Data/S2_AB_{depth}_N{N}.csv')
    pd.DataFrame(np.array(S2_AA_N8)).to_csv(f'Data/S2_A_{depth}_N{N}_N8.csv')
    pd.DataFrame(np.array(S2_BB_N8)).to_csv(f'Data/S2_B_{depth}_N{N}_N8.csv')
    pd.DataFrame(np.array(S2_AABB_N8)).to_csv(f'Data/S2_AB_{depth}_N{N}_N8.csv')
   




# This block belongs to multithreading of the function, adjust it in case you want to use it on a cluster    
if __name__ == '__main__':

    pool = multiprocessing.Pool()
    # depth is the depth of cricuit with Clifford + T blocks
    depth = [i for i in range(0,40)]
    
    outputs_async = pool.map_async(function, depth)
    outputs = outputs_async.get()
    print("Output: {}".format(outputs))
