import matplotlib.pyplot as plt
import numpy as np
import json
import os
from scipy.optimize import minimize

# Data imports

data_8q = []
data_12q = []
data_16q = []
data_20q = []

directory = os.path.join(os.getcwd(), "Data", "Theta_0")

filename_8 = [file for file in os.listdir(directory) if '8q' in file.lower()]
filename_12 = [file for file in os.listdir(directory) if '12q' in file.lower()]
filename_16 = [file for file in os.listdir(directory) if '16q' in file.lower()]
filename_20 = [file for file in os.listdir(directory) if '20q' in file.lower()]

for file_name in filename_8:
    file_path = os.path.join(directory, file_name)
    
    with open(file_path, 'r') as file:
        rundata_8q = json.load(file)
    
    data_8q.append(rundata_8q)
    
for file_name in filename_12:
    file_path = os.path.join(directory, file_name)
    
    with open(file_path, 'r') as file:
        rundata_12q = json.load(file)
    
    data_12q.append(rundata_12q)
    
for file_name in filename_16:
    file_path = os.path.join(directory, file_name)
    
    with open(file_path, 'r') as file:
        rundata_16q = json.load(file)
    
    data_16q.append(rundata_16q)
    
for file_name in filename_20:
    file_path = os.path.join(directory, file_name)
    
    with open(file_path, 'r') as file:
        rundata_20q = json.load(file)
    
    data_20q.append(rundata_20q)
        
p_clifford = np.linspace(0, 0.6, len(data_20q[0]))
data_8q_avg = [sum(values) / len(values) for values in zip(*data_8q)]
data_12q_avg = [sum(values) / len(values) for values in zip(*data_12q)]
data_16q_avg = [sum(values) / len(values) for values in zip(*data_16q)]
data_20q_avg = [sum(values) / len(values) for values in zip(*data_20q)]


data_8q_magic_pi20 = []
data_12q_magic_pi20 = []
data_16q_magic_pi20 = []
data_20q_magic_pi20 = []

directory = os.path.join(os.getcwd(), "Data", "Theta_pi20")

filename_8_magic_pi20 = [file for file in os.listdir(directory) if '8q' in file.lower()]
filename_12_magic_pi20 = [file for file in os.listdir(directory) if '12q' in file.lower()]
filename_16_magic_pi20 = [file for file in os.listdir(directory) if '16q' in file.lower()]
filename_20_magic_pi20 = [file for file in os.listdir(directory) if '20q' in file.lower()]


for file_name in filename_8_magic_pi20:
    file_path = os.path.join(directory, file_name)
    
    with open(file_path, 'r') as file:
        rundata_8q_magic_pi20 = json.load(file)
    
    data_8q_magic_pi20.append(rundata_8q_magic_pi20)


for file_name in filename_12_magic_pi20:
    file_path = os.path.join(directory, file_name)
    
    with open(file_path, 'r') as file:
        rundata_12q_magic_pi20 = json.load(file)
    
    data_12q_magic_pi20.append(rundata_12q_magic_pi20)

for file_name in filename_16_magic_pi20:
    file_path = os.path.join(directory, file_name)
    
    with open(file_path, 'r') as file:
        rundata_16q_magic_pi20 = json.load(file)
    
    data_16q_magic_pi20.append(rundata_16q_magic_pi20)
    
for file_name in filename_20_magic_pi20:
    file_path = os.path.join(directory, file_name)
    
    with open(file_path, 'r') as file:
        rundata_20q_magic_pi20 = json.load(file)
    
    data_20q_magic_pi20.append(rundata_20q_magic_pi20)

p_magic_pi20 = np.linspace(0, 0.6, len(data_8q_magic_pi20[0]))

data_8q_avg_magic_pi20 = [sum(values) / len(values) for values in zip(*data_8q_magic_pi20)]
data_12q_avg_magic_pi20 = [sum(values) / len(values) for values in zip(*data_12q_magic_pi20)]
data_16q_avg_magic_pi20 = [sum(values) / len(values) for values in zip(*data_16q_magic_pi20)]
data_20q_avg_magic_pi20 = [sum(values) / len(values) for values in zip(*data_20q_magic_pi20)]


data_8q_magic_pi4 = []
data_12q_magic_pi4 = []
data_16q_magic_pi4 = []
data_20q_magic_pi4 = []

directory = os.path.join(os.getcwd(), "Data", "Theta_pi4")

filename_8_magic_pi4 = [file for file in os.listdir(directory) if '8q' in file.lower()]
filename_12_magic_pi4 = [file for file in os.listdir(directory) if '12q' in file.lower()]
filename_16_magic_pi4 = [file for file in os.listdir(directory) if '16q' in file.lower()]
filename_20_magic_pi4 = [file for file in os.listdir(directory) if '20q' in file.lower()]


for file_name in filename_8_magic_pi4:
    file_path = os.path.join(directory, file_name)
    
    with open(file_path, 'r') as file:
        rundata_8q_magic_pi4 = json.load(file)
    
    data_8q_magic_pi4.append(rundata_8q_magic_pi4)
   
for file_name in filename_12_magic_pi4:
    file_path = os.path.join(directory, file_name)
    
    with open(file_path, 'r') as file:
        rundata_12q_magic_pi4 = json.load(file)
    
    data_12q_magic_pi4.append(rundata_12q_magic_pi4)
  
for file_name in filename_16_magic_pi4:
    file_path = os.path.join(directory, file_name)
    
    with open(file_path, 'r') as file:
        rundata_16q_magic_pi4 = json.load(file)
    
    data_16q_magic_pi4.append(rundata_16q_magic_pi4)
    
for file_name in filename_20_magic_pi4:
    file_path = os.path.join(directory, file_name)
    
    with open(file_path, 'r') as file:
        rundata_20q_magic_pi4 = json.load(file)
    
    data_20q_magic_pi4.append(rundata_20q_magic_pi4)
     
p_magic_pi4 = np.linspace(0, 0.6, len(data_12q_magic_pi4[0]))

data_8q_avg_magic_pi4 = [sum(values) / len(values) for values in zip(*data_8q_magic_pi4)]
data_12q_avg_magic_pi4 = [sum(values) / len(values) for values in zip(*data_12q_magic_pi4)]
data_16q_avg_magic_pi4 = [sum(values) / len(values) for values in zip(*data_16q_magic_pi4)]
data_20q_avg_magic_pi4 = [sum(values) / len(values) for values in zip(*data_20q_magic_pi4)]
p = p_clifford

#Data collapse for theta = 0
data1 = data_8q_avg
data2 = data_12q_avg
data3 = data_16q_avg
data4 = data_20q_avg

def f1f(p, a1, b1, c1, p_c, nu):
    x = (p - p_c) * (8 ** (1 / nu))
    return a1 + b1 * x**2 + c1 * x ** 1

def f2f(p, a2, b2, c2, p_c, nu):
    x = (p - p_c) * (12 ** (1 / nu))
    return a2 + b2 * x**2 + c2 * x ** 1

def f3f(p, a3, b3, c3, p_c, nu):
    x = (p - p_c) * (16 ** (1 / nu))
    return a3 + b3 * x**2 + c3 * x ** 1

def f4f(p, a4, b4, c4, p_c, nu):
    x = (p - p_c) * (20 ** (1 / nu))
    return a4 + b4 * x**2 + c4 * x ** 1


# Define the loss function
def loss(params):
    a1, b1, c1, a2, b2, c2, a3, b3, c3, a4, b4, c4, p_c, nu = params
    fit1 = f1f(p, a1, b1, c1, p_c, nu)
    fit2 = f2f(p, a2, b2, c2, p_c, nu)
    fit3 = f3f(p, a3, b3, c3, p_c, nu)
    fit4 = f4f(p, a4, b4, c4, p_c, nu)
    
    loss_8 = np.sum((fit1 - data1)**2)
    loss_12 = np.sum((fit2 - data2)**2)
    loss_16 = np.sum((fit3 - data3)**2)
    loss_20 = np.sum((fit4 - data4)**2)

    return loss_8 + loss_12 + loss_16 + loss_20

# Initial guess for parameters
x0 = [1,1,1,1,1,1,1,1,1,1,1,1, 0.185, 1.33]  # Initial guess for [a, b, c, p_c, nu]

# Bounds for parameters
bounds = ((-100, 100), (-100, 100), (-100, 100),
          (-100, 100), (-100, 100), (-100, 100),
          (-100, 100), (-100, 100), (-100, 100),
          (-100, 100),(-100, 100), (-100, 100),
          (0.1, 0.23), (1,2))

# Perform the optimization
result = minimize(loss, x0=x0, method="L-BFGS-B", bounds=bounds)

# Extract the fitted parameters
a1_fit, b1_fit, c1_fit, a2_fit, b2_fit, c2_fit, a3_fit, b3_fit, c3_fit, a4_fit, b4_fit, c4_fit, p_c_fit, nu_fit = result.x

# Print the fitted parameters
print(r"Fitted parameters for \theta = 0:")
print("p_c:", p_c_fit)
print("nu:", nu_fit)




# With magic = pi/20

data1_magic_pi20 = data_8q_avg_magic_pi20
data2_magic_pi20 = data_12q_avg_magic_pi20
data3_magic_pi20 = data_16q_avg_magic_pi20
data4_magic_pi20 = data_20q_avg_magic_pi20

def f1f(p, a1, b1, c1, p_c, nu):
    x = (p - p_c) * 8 ** (1 / nu)
    return a1 + b1 * x + c1 * x ** 2

def f2f(p, a2, b2, c2, p_c, nu):
    x = (p - p_c) * 12 ** (1 / nu)
    return a2 + b2 * x + c2 * x ** 2

def f3f(p, a3, b3, c3, p_c, nu):
    x = (p - p_c) * 16 ** (1 / nu)
    return a3 + b3 * x + c3 * x ** 2

def f4f(p, a4, b4, c4, p_c, nu):
    x = (p - p_c) * 20 ** (1 / nu)
    return a4 + b4 * x + c4 * x ** 2
p_data = p_clifford

# Define the loss function
def loss(params):
    a1, b1, c1, a2, b2, c2, a3, b3, c3, a4, b4, c4, p_c, nu = params
    fit1 = f1f(p, a1, b1, c1, p_c, nu)
    fit2 = f2f(p, a2, b2, c2, p_c, nu)
    fit3 = f3f(p, a3, b3, c3, p_c, nu)
    fit4 = f4f(p, a4, b4, c4, p_c, nu)
    
    loss_8 = np.sum((fit1 - data1_magic_pi20)**2)
    loss_12 = np.sum((fit2 - data2_magic_pi20)**2)
    loss_16 = np.sum((fit3 - data3_magic_pi20)**2)
    loss_20 = np.sum((fit4 - data4_magic_pi20)**2)
    
    return loss_8 + loss_12 + loss_16 + loss_20

# Initial guess for parameters
x0 = [1,1,1,1,1,1,1,1,1,1,1,1, 0.185, 1.33]  # Initial guess for [a, b, c, p_c, nu]

# Bounds for parameters (if any)
bounds = ((-100, 100), (-100, 100), (-100, 100),
          (-100, 100), (-100, 100), (-100, 100),
          (-100, 100), (-100, 100), (-100, 100),
          (-100, 100),(-100, 100), (-100, 100),
          (0.1, 0.23), (1,2))

# Perform the optimization
result = minimize(loss, x0=x0, method="L-BFGS-B", bounds=bounds)

# Extract the fitted parameters
a1_fit, b1_fit, c1_fit, a2_fit, b2_fit, c2_fit, a3_fit, b3_fit, c3_fit, a4_fit, b4_fit, c4_fit, p_c_fit, nu_fit = result.x

# Print the fitted parameters
print(r"Fitted parameters for \theta = \pi/20:")
print("p_c:", p_c_fit)
print("nu:", nu_fit)



# With magic = pi/4

data1_magic_pi4 = data_8q_avg_magic_pi4
data2_magic_pi4 = data_12q_avg_magic_pi4
data3_magic_pi4 = data_16q_avg_magic_pi4
data4_magic_pi4 = data_20q_avg_magic_pi4

def f1f(p, a1, b1, c1, p_c, nu):
    x = (p - p_c) * 8 ** (1 / nu)
    return a1 + b1 * x + c1 * x ** 2

def f2f(p, a2, b2, c2, p_c, nu):
    x = (p - p_c) * 12 ** (1 / nu)
    return a2 + b2 * x + c2 * x ** 2

def f3f(p, a3, b3, c3, p_c, nu):
    x = (p - p_c) * 16 ** (1 / nu)
    return a3 + b3 * x + c3 * x ** 2

def f4f(p, a4, b4, c4, p_c, nu):
    x = (p - p_c) * 20 ** (1 / nu)
    return a4 + b4 * x + c4 * x ** 2
p_data = p_clifford

# Define the loss function
def loss(params):
    a1, b1, c1, a2, b2, c2, a3, b3, c3, a4, b4, c4, p_c, nu = params
    fit1 = f1f(p, a1, b1, c1, p_c, nu)
    fit2 = f2f(p, a2, b2, c2, p_c, nu)
    fit3 = f3f(p, a3, b3, c3, p_c, nu)
    fit4 = f4f(p, a4, b4, c4, p_c, nu)
    
    loss_8 = np.sum((fit1 - data1_magic_pi4)**2)
    loss_12 = np.sum((fit2 - data2_magic_pi4)**2)
    loss_16 = np.sum((fit3 - data3_magic_pi4)**2)
    loss_20 = np.sum((fit4 - data4_magic_pi4)**2)
    
    return loss_8 + loss_12 + loss_16 + loss_20

# Initial guess for parameters
x0 = [1,1,1,1,1,1,1,1,1,1,1,1, 0.185, 1.33]  # Initial guess for [a, b, c, p_c, nu]

# Bounds for parameters (if any)
bounds = ((-100, 100), (-100, 100), (-100, 100),
          (-100, 100), (-100, 100), (-100, 100),
          (-100, 100), (-100, 100), (-100, 100),
          (-100, 100),(-100, 100), (-100, 100),
          (0.1, 0.23), (1,2))

# Perform the optimization
result = minimize(loss, x0=x0, method="L-BFGS-B", bounds=bounds)

# Extract the fitted parameters
a1_fit, b1_fit, c1_fit, a2_fit, b2_fit, c2_fit, a3_fit, b3_fit, c3_fit, a4_fit, b4_fit, c4_fit, p_c_fit, nu_fit = result.x

# Print the fitted parameters
print(r"Fitted parameters for \theta = \pi/4:")
print("p_c:", p_c_fit)
print("nu:", nu_fit)