setwd("/home/cephi/PhD/PhD Wageningen/Data/Biosys/Survival")
library(car)
library(Rmisc)
library(lsmeans)
dat<-read.csv("Survival.csv")

#LM eggs

meggs<-lm(survival~Total.number.of.eggs.at.investation,dat)
summary(meggs)

#GLM
#pests
pest<-glm(cbind(caterpillars,Not.hatched)~Pest*Line,dat,family = binomial)
Anova(pest)

#real variables

mod<-glm(cbind(caterpillars,Not.hatched)~Line,dat,family = binomial)
Anova(mod)

leastsquare = lsmeans(compmod,
                      pairwise ~ Line,
                      adjust="tukey")
leastsquare

leastsquare = lsmeans(compmod,
                      pairwise ~ factor(HR):State:Line2,
                      adjust="tukey")
leastsquare

step(mod)

compmod<-glm(cbind(caterpillars,Not.hatched)~factor(HR)*State*Line2,dat,family = binomial)
Anova(compmod)
step(compmod)

mod<-glm(cbind(caterpillars,Not.hatched)~factor(HR)*species,dat,family = binomial)
Anova(mod)
step(mod)

leastsquare = lsmeans(mod,
                      pairwise ~ species,
                      adjust="tukey")
leastsquare

boxplot(dat$survival~dat$Total.number.of.eggs.at.investation)

#Values
HR<-summarySE(dat,"survival",factor("HR"))
Sp<-summarySE(dat,"survival",factor("species"))
eggs<-summarySE(dat,"survival","Total.number.of.eggs.at.investation")
State<-summarySE(dat,"survival","State")
Line<-summarySE(dat,"survival","Line2")
HRState<-summarySE(dat,"survival",c("HR","State"))
HRLine<-summarySE(dat,"survival",c("HR","Line2"))
HRSpecies<-summarySE(dat,"survival",c("HR","species"))
LineState<-summarySE(dat,"survival",c("Line2","State"))
Int<-summarySE(dat,"survival",c("HR","State","Line"))

write.csv(HRSpecies,"HRSpecies.csv")

#posthoc
kruskal.test(dat$survival~dat$Line2)
pairwise.wilcox.test(dat$survival,dat$Line2)

kruskal.test(dat$survival~dat$State)
pairwise.wilcox.test(dat$survival,dat$State)

wilcox.test(dat$survival~dat$HR)

kruskal.test(dat$survival~dat$HRState)
pairwise.wilcox.test(dat$survival,dat$HRState)

kruskal.test(dat$survival~dat$HRState)
pairwise.wilcox.test(dat$survival,dat$HRState)

kruskal.test(dat$survival~dat$HRStateLine)
pairwise.wilcox.test(dat$survival,dat$HRStateLine)

#correlation
co<-read.csv("SurvHRCorr.csv")
cor.test(co$survival,co$Hrfrac, method = "spearman")
plot(co$survival~co$Hrfrac)
ab<-lm(co$survival~co$Hrfrac)
abline(ab)
summary(ab)
