setwd("/media/cephi/Eddie's USB/PhDWageningen/Coevolution paper/LotteCindySurvival")
#setwd("E:/PhDWageningen/Coevolution paper/LotteCindySurvival")

library(car)
library(Rmisc)
library(ggplot2)
library(dunn.test)
library(emmeans)

dat<-read.csv("Survbnr.csv")

expl<-summarySE(dat,"percentage.survivial",c("butterfly.species","HRYN"))
but<-summarySE(dat,"percentage.survivial",c("butterfly.species"))


modyn<-glm(cbind(N.survival,N.eggs-N.survival)~butterfly.species*factor(HRYN)*Experiment,data=dat,family = binomial)
Anova(modyn)
step(modyn)
newmodyn<-glm(formula = cbind(N.survival, N.eggs - N.survival) ~ butterfly.species + 
                factor(HRYN) + Experiment + butterfly.species:factor(HRYN) + 
                factor(HRYN):Experiment, family = binomial, data = dat)
Anova(newmodyn)

but<-emmeans (modyn,  ~ butterfly.species , type="response", Letters = letters, adjust = "none")
pairs(but)
cld(but)

comp<-emmeans (modyn,  ~ butterfly.species : factor(HRYN), type="response", Letters = letters, adjust = "none")
pairs(comp)
cld(comp)

sn<-subset(dat,Experiment=="Same Number")
dn<-subset(dat,Experiment=="Variing Number")
fe<-subset(dat,Experiment=="First experiment")

modsnex<-glm(cbind(N.survival,N.eggs-N.survival)~butterfly.species+factor(HRYN)+butterfly.species:factor(HRYN),data=sn,family = binomial)
Anova(modsnex)

but<-emmeans (modsnex,  ~ butterfly.species, type="response", Letters = letters, adjust = "none")
pairs(but)
cld(but)
pairwise.wilcox.test(sn$N.survival,sn$butterfly.species)

comp<-emmeans (modsnex,  ~ butterfly.species : factor(HRYN), type="response", Letters = letters, adjust = "none")
pairs(comp)
cld(comp)

wilcox.test(sn$percentage.survivial[sn$butterfly.species=="P.brassicae"]~sn$HRYN[sn$butterfly.species=="P.brassicae"])
wilcox.test(sn$percentage.survivial[sn$butterfly.species=="P.rapae"]~sn$HRYN[sn$butterfly.species=="P.rapae"])
wilcox.test(sn$percentage.survivial[sn$butterfly.species=="P.napi"]~sn$HRYN[sn$butterfly.species=="P.napi"])

snexpl<-summarySE(sn,"percentage.survivial",c("butterfly.species","HRYN"))

moddnex<-glm(cbind(N.survival,N.eggs-N.survival)~butterfly.species*factor(HRYN),data=dn,family = binomial)
Anova(moddnex)

but<-emmeans (moddnex,  ~ factor(HRYN) , type="response", Letters = letters, adjust = "none")
pairs(but)
cld(but)

comp<-emmeans (moddnex,  ~ butterfly.species : factor(HRYN), type="response", Letters = letters, adjust = "none")
pairs(comp)
cld(comp)

dnexpl<-summarySE(dn,"percentage.survivial",c("HRYN"))

modfex<-glm(cbind(N.survival,N.eggs-N.survival)~factor(HRYN),data=fe,family = binomial)
Anova(modfex)

but<-emmeans (modfex,  ~ butterfly.species , type="response", Letters = letters, adjust = "none")
pairs(but)
cld(but)

comp<-emmeans (modfex,  ~ factor(HRYN), type="response", Letters = letters, adjust = "none")
pairs(comp)
cld(comp)

feexpl<-summarySE(fe,"percentage.survivial",c("butterfly.species","HRYN"))
#Plots
source(file="opts_layout_legend.R")
dodge <- position_dodge(width=0.9)

barhr<-ggplot(data=snexpl,aes(y=percentage.survivial,x=butterfly.species,fill=factor(HRYN)))+
  geom_bar(colour="black", stat="identity",position=dodge
           #)+facet_wrap(~Butterfly,ncol=1
  )+scale_y_continuous("Fraction egg survival", expand=c(0,0),limits=c(0,1) 
  )+scale_x_discrete("Butterfly species"                     
  )+geom_errorbar(aes(ymin=percentage.survivial-se, ymax=percentage.survivial+se),position=dodge,width=.2
  )+geom_text(aes(label =N),position=dodge, vjust=1,size=12
  )+scale_fill_manual(values=c("white", "gray27")
  )+plot.opts.layout+plot.opts.legend
barhr

barhr<-ggplot(data=dnexpl,aes(y=percentage.survivial,x=butterfly.species,fill=factor(HRYN)))+
  geom_bar(colour="black", stat="identity",position=dodge
           #)+facet_wrap(~Butterfly,ncol=1
  )+scale_y_continuous("Fraction egg survival", expand=c(0,0),limits=c(0,1) 
  )+scale_x_discrete("Butterfly species"                     
  )+geom_errorbar(aes(ymin=percentage.survivial-se, ymax=percentage.survivial+se),position=dodge,width=.2
  )+geom_text(aes(label =N),position=dodge, vjust=1,size=12
  )+scale_fill_manual(values=c("white", "gray27")
  )+plot.opts.layout+plot.opts.legend
barhr

barhr<-ggplot(data=feexpl,aes(y=percentage.survivial,x=butterfly.species,fill=factor(HRYN)))+
  geom_bar(colour="black", stat="identity",position=dodge
           #)+facet_wrap(~Butterfly,ncol=1
  )+scale_y_continuous("Fraction egg survival", expand=c(0,0),limits=c(0,1) 
  )+scale_x_discrete("Butterfly species"                     
  )+geom_errorbar(aes(ymin=percentage.survivial-se, ymax=percentage.survivial+se),position=dodge,width=.2
  )+geom_text(aes(label =N),position=dodge, vjust=1,size=12
  )+scale_fill_manual(values=c("white", "gray27")
  )+plot.opts.layout+plot.opts.legend
barhr

#severity

modsnex<-glm(cbind(N.survival,N.eggs-N.survival)~butterfly.species*factor(HR),data=sn,family = binomial)
Anova(modsnex)

but<-emmeans (modsnex,  ~ butterfly.species, type="response", Letters = letters, adjust = "none")
pairs(but)
cld(but)

comp<-emmeans (modsnex,  ~ butterfly.species : factor(HR), type="response", Letters = letters, adjust = "none")
pairs(comp)
cld(comp)

snexpl<-summarySE(sn,"percentage.survivial",c("butterfly.species","HR"))

moddnex<-glm(cbind(N.survival,N.eggs-N.survival)~butterfly.species*factor(HR),data=dn,family = binomial)
Anova(moddnex)

but<-emmeans (moddnex,  ~ butterfly.species , type="response", Letters = letters, adjust = "none")
pairs(but)
cld(but)

comp<-emmeans (moddnex,  ~ butterfly.species : factor(HR), type="response", Letters = letters, adjust = "none")
pairs(comp)
cld(comp)

dnexpl<-summarySE(dn,"percentage.survivial",c("butterfly.species","HR"))

#HR expression
dnexpl<-summarySE(dn,"HR03",c("butterfly.species","B..nigra.acssesion"))
snexpl<-summarySE(sn,"HR03",c("butterfly.species","B..nigra.acssesion"))
dnexplyn<-summarySE(dn,"HRYN",c("butterfly.species","B..nigra.acssesion"))
snexplyn<-summarySE(sn,"HRYN",c("butterfly.species","B..nigra.acssesion"))


modeldn<-glm(HR03 ~ butterfly.species*B..nigra.acssesion,dn,family = poisson)
Anova(modeldn)

comp<-emmeans (modeldn,  ~ butterfly.species : B..nigra.acssesion, type="response", Letters = letters, adjust = "none")
pairs(comp)
cld(comp)

modelsn<-glm(HR03 ~ butterfly.species*B..nigra.acssesion,sn,family = poisson)
Anova(modelsn)

comp<-emmeans (modelsn,  ~ butterfly.species : B..nigra.acssesion, type="response", Letters = letters, adjust = "none")
pairs(comp)
cld(comp)

source(file="opts_layout_legend.R")
dodge <- position_dodge(width=0.9)

pdHR <- ggplot(data=dnexpl, aes(x=butterfly.species, y=HR03, fill=B..nigra.acssesion)
)+geom_bar(stat="identity", color="black", position=dodge
)+ geom_errorbar(aes(ymin=HR03-se, ymax=HR03+se), width=.1, position=dodge
)+scale_x_discrete("Butterfly species"
)+scale_y_continuous("HR Severity",expand=c(0,0),limits=c(0,3)
)+geom_text(aes(label =N),position=dodge, vjust=1,size=12
)+plot.opts.layout+plot.opts.legend
pdHR

psHR <- ggplot(data=snexpl, aes(x=butterfly.species, y=HR03, fill=B..nigra.acssesion)
)+geom_bar(stat="identity", color="black", position=dodge
)+ geom_errorbar(aes(ymin=HR03-se, ymax=HR03+se), width=.1, position=dodge
)+scale_x_discrete("Butterfly species"
)+scale_y_continuous("HR Severity",expand=c(0,0),limits=c(0,3)
)+geom_text(aes(label =N),position=dodge, vjust=1,size=12
)+plot.opts.layout+plot.opts.legend
psHR

pdHRyn <- ggplot(data=dnexplyn, aes(x=butterfly.species, y=HRYN, fill=B..nigra.acssesion)
)+geom_bar(stat="identity", color="black", position=dodge
)+ geom_errorbar(aes(ymin=HRYN-se, ymax=HRYN+se), width=.1, position=dodge
)+scale_x_discrete("Butterfly species"
)+scale_y_continuous("Fraction plants expressing HR",expand=c(0,0),limits=c(0,1)
)+geom_text(aes(label =N),position=dodge, vjust=1,size=12
)+plot.opts.layout+plot.opts.legend
pdHRyn

psHRyn <- ggplot(data=snexplyn, aes(x=butterfly.species, y=HRYN, fill=B..nigra.acssesion)
)+geom_bar(stat="identity", color="black", position=dodge
)+ geom_errorbar(aes(ymin=HRYN-se, ymax=HRYN+se), width=.1, position=dodge
)+scale_x_discrete("Butterfly species"
)+scale_y_continuous("Fraction plants expressing HR",expand=c(0,0),limits=c(0,1)
)+geom_text(aes(label =N),position=dodge, vjust=1,size=12
)+plot.opts.layout+plot.opts.legend
psHRyn


#outdoor survival
out<-read.csv("outdoor survival.csv")
chisq.test(out)

outa<-read.csv("outdoor survivalall.csv")
mods<-glm(survival~Frac.HR,outa,weights=total.eggs,family = binomial)
Anova(mods)
summary(mods)
Rsqu<-1-(32.991/79.317)

wilcox.test(outa$Frac..Survival.HR.eggs,outa$Frac..Survival.non.hr)

m<-summarySE(outa,"survival","HRYN")

scat<- ggplot(data=outa, aes(x=Frac.HR, y=survival)
)+geom_point(size=8
#)+ geom_errorbar(aes(ymin=HRYN-se, ymax=HRYN+se), width=.1, position=dodge
)+geom_smooth(method=glm
)+stat_smooth(method = glm
)+scale_x_continuous("Fraction eggs eliciting HR",limits=c(0,1.05)
)+scale_y_continuous("Fraction egg survival",expand=c(0.05,0),limits=c(0,1.05)
#)+geom_text(aes(label =N),position=dodge, vjust=1,size=12
)+plot.opts.layout+plot.opts.nolegend
scat

source(file="opts_layout_legend.R")
dodge <- position_dodge(width=0.9)

hryn <- ggplot(m, aes(x=HRYN, y=survival)
)+geom_bar(stat="identity", color="black", position=dodge
)+ geom_errorbar(aes(ymin=survival-se, ymax=survival+se), width=.1, position=dodge
)+scale_x_discrete("HR expression"
)+scale_y_continuous("Fraction egg survival",expand=c(0,0),limits=c(0,1)
)+geom_text(aes(label =N),position=dodge, vjust=1,size=12
)+plot.opts.layout+plot.opts.nolegend
hryn

#P. napi Dimitri
ddat<-read.csv("Pnapi_survival.csv")
SF19<-subset(ddat,ddat$Genotype=="SF19")

mosu<-glm(survival~HRYN+Genotype,weights = N_eggs,ddat,family = binomial)
Anova(mosu)

mosf19<-glm(survival~HRYN,SF19,weights=N_eggs,family = binomial)
Anova(mosf19)

pn<-summarySE(ddat,"survival","HRYN")
