# Author: Niccolo` Bassetti	- niccolo.bassetti@protonmail.com

# Set working directories
rm(list=ls())
sessionInfo() #check packages available
setwd("")	#set working directory 

# Set R library folder location
.libPaths()

Sys.getenv("R_LIBS_USER") 		#same as above

# Install R packages (update.packages(), install.packages(), library())
packageurl <- "https://cran.r-project.org/src/contrib/Archive/devtools/devtools_1.13.2.tar.gz" #write URL of package to install
install.packages(packageurl, repos=NULL, type="source") #install old version packages
install.packages("binom")

### Import library and mydata
packages = c("tidyverse", "binom","dplyr","RColorBrewer","plotrix","multcomp")
lapply(packages, library, character.only = TRUE)

mydata  <-  read.table("OVIPO-05_survival.txt", header=TRUE,sep="")

mydata  <-  read.table("Survival_Eddie.txt", header=TRUE,sep="")

mydata  <-  read.table("Survival_Vrolings_Arabidopsis.txt", header=TRUE,sep="")

# Examine dataset 
sapply(mydata, function(x)(sum(is.na(x))))		# search NAs
mydata <- na.omit(mydata)		# revome NAs
# data = subset(mydata, Genotype == "RC144")	 # subset dataset based on one column level 

# Summary stastics and plotting data
summary(mydata)
tapply(mydata$Survival, mydata$Genotype, mean)	 # mean variable for each Genotype
tapply(mydata$Survival, mydata$Genotype, sd)
#se <- function(x) sqrt(var(x)/length(x))
tapply(mydata$Survival, mydata$Genotype, se)
binom.confint(sum(data$Hatched), sum(data$Total), method=c("wilson"))	# confidence interval

tapply(mydata$Survival, mydata$HR, mean)	 # mean variable for each HR
tapply(mydata$Survival, mydata$HR, sd)


### Boxplot 1
par(mfrow=c(1,1))		# (row, column)
boxplot(mydata$Survival~ mydata$Genotype)	# boxplot each genotype

par(mfrow=c(2,2))
hist(subset(mydata, Genotype == "BRO-030")$Survival)
rug(jitter(subset(mydata, Genotype == "BRO-030")$Survival))
hist(subset(mydata, Genotype == "	Rapa")$Survival)
hist(subset(mydata, Genotype == "RC144")$Survival)
hist(subset(mydata, Genotype == "SF48")$Survival)


### Boxplot 2
# Reformat dataframe for plotting purpose
data  <-  as_tibble(mydata)
# options(pillar.sigfig = 5) # visualize decimals in tibble
#data <- data %>% filter(`Species`=="B.rapa")
data <- data %>% dplyr::select(Species, HR, Survival)
data$Species <- as.character((data$Species))
#data$Genotype <- as.character(data$Genotype)
data$HR <- as.character(data$HR)

data <- data  %>% group_by(Species,HR) %>% summarize(mean=mean(Survival),sd=sd(Survival),se=std.error(Survival),count=n()) # add confdence interval

head(data)

cbPalette=c("Set1") # choose palette colours
# cbPalette=c("white","black")
size=15
# Boxplot
par(mfrow=c(1,1))
plot = ggplot(data) + # use geom_boxplot or geom_violin
  geom_bar(aes(x=Species, y=mean, fill=HR),
           stat="identity",
           colour="black", # black outline for boxes
           position=position_dodge(width = 0.9)) +
  #geom_text(mapping=aes(x=Species, y=mean,label=count,group=HR),
            #position=position_dodge(width=0.9), vjust=25) +
  geom_errorbar(mapping=aes(x=Species, y=mean, fill=HR,
                            ymin=(mean - se), ymax=(mean + se)), 
             colour="black", # black outline for points
             width=0.33,
             position=position_dodge(width=0.9)) +
  labs(x="", y="", size=size) +
  #scale_fill_brewer(palette=cbPalette) + # set color for fills - http://www.cookbook-r.com/Graphs/Colors_(ggplot2)/
  scale_fill_manual(values=c("white","black")) + # set color for fills - http://www.cookbook-r.com/Graphs/Colors_(ggplot2)/
  # scale_colour_brewer(palette=cbPalette) + # set color for line/points - 
  theme(axis.text.x = element_text(angle = 0, vjust = 0.5, hjust = 0.5, 