# Author: Niccolo` Bassetti	- niccolo.bassetti@protonmal.com

# Set working directories
rm(list=ls())
sessionInfo() #check packages available
setwd()

# Set R library folder location
.libPaths()
Sys.getenv("R_LIBS_USER") 		#same as above

# Install R packages (update.packages(), install.packages(), library())
packageurl <- "https://cran.r-project.org/src/contrib/Archive/devtools/devtools_1.13.2.tar.gz" #write URL of package to install
install.packages(packageurl, repos=NULL, type="source") #install old version packages
install.packages("glue")

### Import library and mydata
packages = c("tidyverse", "binom","dplyr","RColorBrewer")
lapply(packages, library, character.only = TRUE)

mydata <- read.table("qPCR_butterflies.txt",header=TRUE,sep="")
head(mydata)
names(mydata)

dim(mydata)
str(mydata)

### NOT USED ###
# Transform class variables
sapply(FUN = class, mydata)
mydata$ID <- as.factor(mydata$ID)

# Search NAs
sapply(mydata, function(x)(sum(is.na(x))))		# search NAs
mydata <- na.omit(mydata)		# revome NAs


### Summary stastics and exploratory plotting mydata
summary(mydata)
tapply(mydata$HR_corrected_10eggs, list(mydata$Species,mydata$staining), mean)	 # mean variable for each Species
tapply(mydata$HR_corrected_10eggs, list(mydata$Species,mydata$staining), sd)
#se <- function(x) sqrt(var(x)/length(x))
#tapply(mydata$HR_corrected_10eggs, mydata$Species, se)

par(mfrow=c(1,1))		# (row, column)
boxplot(mydata$HR_corrected_10eggs~ mydata$Species)	# boxplot each Species

par(mfrow=c(2,2))
hist(subset(mydata, Genotype == "BRO-030")$Survival) # NOT USED
rug(jitter(subset(mydata, Genotype == "BRO-030")$Survival)) # NOT USED
### NOT USED ###

### Boxplot
require(ggplot2,svglite)

# Reformat dataframe for plotting purpose
data  <-  as_tibble(mydata)
options(pillar.sigfig = 5) # visualize decimals in tibble
# data <- data %>% filter(`staining_type`=="TB")
# data <- data %>% dplyr::select(Species, staining, HR, staining) %>% gather(HR, staining, key = class, value = value)
data$Species <- as.character(data$Species)

head(data)

cbPalette=c("Set1") # choose palette colours
size=15
# Boxplot
par(mfrow=c(1,1))		# open graphic device (row, column) 
plot = ggplot(data) + # use geom_boxplot or geom_violin
  geom_boxplot(aes(x=Species, y=Relative_exp, fill=Species),
               colour="black", # black outline for boxes
               outlier.colour=NA) +
  geom_point(mapping=aes(x=Species,y=Relative_exp, fill=Species), 
             colour="black", # black outline for points
             size=2,
             shape=19,
             alpha=0.5,
             position=position_jitterdodge(jitter.width=0.01,jitter.height=0,dodge.width=0.75,seed=NA)) +
  labs(x="", y="Relative  expression", size=size) +
  scale_fill_manual(values=rep("white",9)) + # set color for fills - http://www.cookbook-r.com/Graphs/Colors_(ggplot2)/
  #scale_fill_brewer(palette=cbPalette) + # set color for fills - http://www.cookbook-r.com/Graphs/Colors_(ggplot2)/
  #scale_colour_brewer(palette=cbPalette) + # set color for line/points - 
  theme_bw() + # remove gray background 
  theme(axis.text.x = element_text(angle = 45, vjust = 0.5, hjust = 0.5, size=size, color="black"),
        axis.text.y=element_text(size=size, color="black"),
        axis.title=element_text(size=size, color="black")) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank()) + # remove grid https://felixfan.github.io/ggplot2-remove-grid-background-margin/
  theme(legend.position="none") + # change to set position, "none" remove legend
  #theme(legend.position = c(0.85, 0.90)) +
  theme(legend.title = element_blank()) +
  theme(legend.text = element_text(colour="black", size=(size-10), face="plain")) + # change "face" value for style text
  scale_x_discrete(limits=c("P.rapae","P.mannii","A.crataegi","A.cardamines","G.rhamni","Colias_spp.","P.xylostella","M.brassicae","control")) + # reorder scale x and legend
  scale_y_continuous(breaks=c(200,seq(500,3000, by=500)),
                    #breaks=c(seq(0,200, by=50)),
                    limits=c(200,3000)
                     )+
  theme(aspect.ratio = 20/20) # fix the x/y ratio of the plot
plot(plot)
ggsave("PLOT_NEW.png", plot=plot, width = 6, height = 6, units="in") # CHANGE
ggsave(file="Figure_PR1_butterflies_TOP.svg", plot=plot, width=6, height=6, units="in")
dev.off()


### Statistical analysis ###
packages("multcomp", "multcompView", "FSA", "rcompanion")
lapply(packages, library, character.only = TRUE)

# Check normality of the mydata
qqnorm(log2(mydata$Relative_exp))
qqline(log2(mydata$Relative_exp))
shapiro.test(log2(mydata$Relative_exp))		# test for normality (small P = NOT NORMAL)
fligner.test(log2(mydata$Relative_exp)~mydata$Species)	# test for equal variances (small P = NOT EQUAL VARIANCE)

# linear model
data=mydata
lm1 <- lm(log2(Relative_exp) ~ Species, data)

summary(lm1)
anova(lm1)
AIC(lm1) # goodness-of-fit measure - smaller values are better
BIC(lm1) # goodness-of-fit measure - smaller values are better
coef(lm1) # coefficients of the model
confint(lm1) # confidence interval
  
  # multiple comparison
  pairs <- glht(lm1, linfct = mcp(Species = "Tukey"))
  cld(pairs, level=0.05)
  summary(pairs) 
  confint(pairs)

# non-parametric test (Anova) - https://rcompanion.org/rcompanion/d_06.html
kruskal.test(log2(mydata$Relative_exp)~mydata$Species)
  # pairwise comparison 1: Dunn test (NOT USED)
  PT = dunnTest(log2(mydata$Relative_exp)~mydata$Species,
                data=mydata,
                method="bh")    # require "FSA", p.adjust to be used to adjust p-values
  PT
  PT = PT$res

  cldList(comparison = PT$Comparison, # gives weird results, not correspondin with Wilcoxon
          p.value    = PT$P.adj,
          threshold  = 0.05) # require "rcompanion"





  # pairwise comparison 2: Withney-Mann U test/Wilcoxon rank sum test
  PT = pairwise.wilcox.test(mydata$Relative_exp, mydata$Species,
                       p.adjust.method = "BH")
  PT = PT$p.value
  PT1 = round(fullPTable(PT),3) # require "rcompanion"
  PT1
  
  multcompLetters(PT1,
                  compare="<",
                  threshold=0.05,
                  Letters=letters,
                  reversed = FALSE) # require "multcompView"
  