function download_and_cache(logger, name, type, size, url)
    % DOWNLOAD_AND_CACHE  Downloads the file at [url] into `cache/[name].zip` and
    % extracting into `cache/[name]`, while telling the user the download has
    % [size].

    arguments% (Input)
        logger (1, 1) Logger;
        name (1, 1) {mustBeText};
        type (1, 1) {mustBeText, mustBeMember(type, ["zip", "mat"])};
        size (1, 1) {mustBeText};
        url (1, 1) {mustBeText};
    end

    if ~exist("./cache/", "dir")
        mkdir("./cache/");
    end

    downloaded_file = sprintf("./cache/%s.%s", name, type);
    extracted_file = sprintf("./cache/%s", name);

    if ~exist(extracted_file, "dir")
        if ~exist(downloaded_file, "file")
            logger.print("Downloading %s (%s)... ", name, size); tic;

            % org.apache.commons.io.FileUtils.copyURLToFile(java.net.URL(url), java.io.File(downloaded_file));
            websave(downloaded_file, url);

            logger.append("done in %.3f seconds.\n", toc);
        end

        if type == "zip"
            logger.print("Extracting %s... ", name); tic;
            unzip(downloaded_file, extracted_file);
            logger.append("done in %.3f seconds.\n", toc);
        end
    end
end
