function r = dirichlet(k, a, n)
    % DIRICHLET  Returns [n] samples of dimension [k] from a Dirichlet distribution
    % with alpha [a].

    arguments% (Input)
        k (1, 1) {mustBeInteger, mustBeGreaterThanOrEqual(k, 2)};
        a (1, :) {mustBeFloat, mustBePositive};
        n (1, 1) {mustBeInteger, mustBePositive};
    end
    % arguments (Output)
    %     r (:, :) {mustBeFloat};
    % end

    scale = 1;
    r = gamrnd(repmat(a, n, k), scale, [n, k]);
    r = r ./ repmat(sum(r, 2), 1, k);
end
