classdef MnistModel < DLModel
    % MNISTMODEL  A model for the MNIST (or EMNIST) dataset.


    properties (Access = protected)
        % CLASSES  The classes that this model distinguishes.
        classes = 0:9;
    end


    methods
        function obj = MnistModel()
            % MNISTMODEL  Constructs a new (E)MNIST model.

            obj = obj@DLModel([imageInputLayer([28 28 1], Normalization = "none");
                               convolution2dLayer([3, 3], 32); reluLayer;
                               maxPooling2dLayer([2, 2]);
                               convolution2dLayer([3, 3], 64); reluLayer;
                               convolution2dLayer([3, 3], 64); reluLayer;
                               maxPooling2dLayer([2, 2]);
                               dropoutLayer(0.2);
                               flattenLayer;
                               fullyConnectedLayer(128); reluLayer;
                               fullyConnectedLayer(10); softmaxLayer]);
        end
    end
end
