function graph_is_connected = graph_is_connected(G, e)
    %GRAPH_IS_CONNECTED Returns `true` if and only if the graph `G` is
    %connected, with a floating-point error margin of `e`.
    arguments
        G;
        e(1, 1) = 1e-10;
    end

    if size(G, 1) ~= size(G, 2)
        G = [zeros(size(G, 1)), G; G', zeros(size(G, 2))];
    end

    D = diag(sum(G, 2));
    L = D - G;
    graph_is_connected = sum(abs(eig(L)) <= e) == 1;
end
