function mustHaveColumns(table, column_names)
    % MUSTHAVECOLUMNS  Validates that [table] contains each column listed in
    % [column_names] (but does not preclude other columns from existing).
    %
    % This function throws an error if a required column is absent, and returns
    % nothing otherwise.

    if ~any(ismember(column_names, table.Properties.VariableNames))
        error("Input must at least have columns %s.", mat2str(column_names));
    end
end
