classdef PlotConfig < Config
    % PLOTCONFIG  Configuration for plotting the results of a [Laboratory].

    properties
        % TITLE  The title of the plot.
        title (1, 1) {mustBeText} = "";
        % X_LABEL  The x-axis label.
        x_label (1, 1) {mustBeText} = "Rounds";
        % Y_LABEL  The y-axis label.
        y_label (1, 1) {mustBeText} = "";
        % Y_LOG  `true` if and only if the y axis is log scale.
        y_log (1, 1) logical = false;
        % Y_SCI_TICKS  `true` if and only if the y axis should have tick labels scaled
        % using scientific notation.
        y_sci_ticks (1, 1) logical = true;

        % FILTER_EXP  Determines whether an [Experiment] is included in this plot.
        filter_exp = @(it) true;  % ((1, 1) Experiment) -> (1, 1) logical
        % EXP_TO_LINE  Maps an [Experiment] to the string identifier of the line in the
        % plot that the [Experiment] corresponds to.
        %
        % Use this to combine multiple [Experiment]s into a single line.
        %
        % The default value returns a unique string depending on the [ExperimentConfig].
        exp_to_line = @(it) hash(it.conf);  % ((1, 1) Experiment) -> (1, 1) {mustBeText};
        % EXP_TO_DATA  Maps an [Experiment] to the data that should be plotted, with
        % each row corresponding to a pair of `(x, y)` coordinates.
        %
        % If a single line has multiple [Experiment]s contributing data, their data is
        % vertically concatenated.
        exp_to_data;  % ((1, 1) Experiment) -> (:, 2) double;
        % LINE_TO_LABEL  Returns the label corresponding to a line based on the
        % [ExperimentConfig] of any of the filtered [Experiment]s.
        line_to_label = 0;  % ((1, 1) Experiment) -> (1, 1) {mustBeText};
    end


    methods
        function obj = PlotConfig(args)
            arguments% (Input)
                args.?PlotConfig;
            end
            % arguments (Output)
            %     obj (1, 1) PlotConfig;
            % end

            obj = obj@Config(args);
        end


        function new_obj = set(obj, args)
            arguments% (Input)
                obj (1, 1) PlotConfig;
                args.?PlotConfig;
            end
            % arguments (Output)
            %     new_obj (1, 1) PlotConfig;
            % end

            new_obj = set@Config(obj, args);
        end

        function h = cache_id(~)
            arguments% (Input)
                ~;
            end
            % arguments (Output)
            %     h (1, 1) {mustBeText};
            % end

            h = "0";
        end
    end

    methods (Static)
        function partial_obj = partial(args)
            arguments% (Input)
                args.?PlotConfig;
            end
            % arguments (Output)
            %     partial_obj (1, :) cell;
            % end

            partial_obj = partial@Config(args);
        end
    end
end
