classdef NumberModel < Model
    % NUMBERMODEL  A model represented by a single number.
    %
    % The model does not actually do any learning, but will average its value with
    % its neighbours.

    properties (Access = private)
        % NUMBER  This model's singular number.
        number (1, 1) {mustBeNumeric};
    end

    methods
        function obj = NumberModel(number)
            % NUMBERMODEL  Constructs a new model with the given number.

            obj.number = number;
        end


        function loss = train(~, ~, ~, ~, ~, ~, ~)
            % TRAIN  Does nothing, since nothing can be done.

            loss = 0;
        end

        function combine_with_neighbors(obj, ~, neighbor_models)
            arguments% (Input)
                obj (1, 1) NumberModel;
                ~;
                neighbor_models (:, 1) cell;  % cell<NumberModel>
            end

            if numel(neighbor_models) == 0; return; end

            obj.number = mean([obj.number; cellfun(@(it) it.number, neighbor_models(:))]);
        end


        function accuracy = evaluate_accuracy(obj, dataset_test, ~)
            arguments% (Input)
                obj (1, 1) NumberModel;
                dataset_test (:, 2) table {mustHaveColumns(dataset_test, ["inputs", "labels"])};
                ~;
            end
            % arguments (Output)
            %     accuracy (1, 1) double {mustBeInRange(accuracy, 0, 1)};
            % end


            accuracy = abs(obj.number - mean(dataset_test.inputs));
        end

        function flat_learnables = get_flat_learnables(obj)
            arguments% (Input)
                obj (1, 1) NumberModel;
            end
            % arguments (Output)
            %     flat_learnables (:, 1) double;
            % end

            flat_learnables = obj.number;
        end
    end
end
