clear all;close all;clc %#ok<*CLALL>
video_info = xlsread('mapping_updated.xlsx','B2:J14'); % Import Excel file with video info
video_info = video_info/25; % convert frames to seconds
savepng=1; % if set to 1, then save .png files of all figures
appen_indices = [17,... % 1. Instructions understood
    37,... % 2. Gender
    36,... % 3. Age
    19,... % 4. Eyesight quality
    16,... % 5. Age of obtaining first driver's license
    38,... % 6. Primary mode of transportation
    33,... % 7. How often in past 12 months did you drive a vehicle
    28,... % 8. How often in past year were you a pedestrian
    13,... % 9. Mileage
    20,... % 10. Number of accidents in past 3 years
    21,... % 11. DBQ1 - How often do you get angered by other drivers
    22,... % 12. DBQ2 - How often do you disregard motorway speed limit
    23,... % 13. DBQ3 - How often do you disregard residential speed limit
    24,... % 14. DBQ4 - How often do you drive close to car in front
    25,... % 15. DBQ5 - How often do you race away from traffic lights
    26,... % 16. DBQ6 - How often do you sound your horn when annoyed
    27,... % 17. DBQ7 - How often do you use mobile when driving
    18,... % 18. Eye contact importance for safety
    14,... % 19. Eye contact meaning for driver
    15,... % 20. Eye contact meaning for pedestrian
    35,... % 21. Worker code
    9,...  % 22. Country
    4,...  % 23. Start
    2,...  % 24. End ---> 25. Survey time
    8,...  % 26. Worker ID
    12];   % 27. IP address

heroku_files={'heroku0.txt';'heroku1.txt'};
appen_file='AllAppenData.csv';
num_stimuli=26;
code_pattern='W7\d+\s?HF\d+\s?2J';
disp([datestr(now, 'HH:MM:SS.FFF') ' - Start of importing data']);
read_heroku = 0; % if 0 then load mat file

%% import Excel file with appen data (survey page)
raw_appen = readtable(appen_file, 'ReadVariableNames', false);
raw_appen = table2cell(raw_appen);  % convert to cell array for ease of checking
disp([datestr(now, 'HH:MM:SS.FFF') ' - Imported data from file with appen data ' appen_file]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - End of importing data']);
%% Process appen data
disp([datestr(now, 'HH:MM:SS.FFF') ' - Start of processing appen data']);
X=NaN(size(raw_appen,1),29); % allocate matrix to store numers answers to survey questions, worker ID and additional data/flags
disp([datestr(now, 'HH:MM:SS.FFF') ' - Number of respondents in appen data = ' num2str(size(raw_appen, 1))])

found_values=raw_appen(:,appen_indices(1)); X(:,1)=strcmp(found_values,'no')+2*strcmp(found_values,'yes'); % instructions understood
found_values=raw_appen(:,appen_indices(2)); X(:,2)=1*strcmp(found_values,'female') + 2*strcmp(found_values,'male') - 1*strcmp(found_values,'i_prefer_not_to_respond'); % gender
found_values=raw_appen(:,appen_indices(3)); % age
for i=1:size(found_values,1)
    try if strcmp(found_values(i),'?')
            X(i,3)=NaN;
        else
            X(i,3)=cell2mat(found_values(i));
        end
    catch error
        X(i,3)=NaN;
    end
end
X(X(:,3)>110,3)=NaN; % people who report age greater than 110 years
found_values=raw_appen(:,appen_indices(4));X(:,4)=1*strcmp(found_values,'perfect') + 2*strcmp(found_values,'corrected') - 1*strcmp(found_values,'uncorrected') - 2*strcmp(found_values,'i_prefer_not_to_respond'); % eyesight quality
found_values=raw_appen(:,appen_indices(5)); % age of obtaining first driver's license
for i=1:size(found_values,1)
    try if strcmp(found_values(i),'?')
            X(i,5)=NaN;
        else
            X(i,5)=cell2mat(found_values(i));
        end
    catch error
        X(i,5)=NaN;
    end
end
X(X(:,5)>110,5)=NaN; % people who report licence more than 110 years
found_values=raw_appen(:,appen_indices(6));
X(:,6)= 1*strcmp(found_values,'private_vehicle') ...
    + 2*strcmp(found_values,'public_transportation') ...
    + 3*strcmp(found_values,'motorcycle') ...
    + 4*strcmp(found_values,'walkingcycling') ...
    + 5*strcmp(found_values,'other') ...
    - 1*strcmp(found_values,'i_prefer_not_to_respond');
% how often in past 12 months did you drive a vehicle
found_values=raw_appen(:,appen_indices(7));
X(:,7)=1*strcmp(found_values,'never') ...
    + 2*strcmp(found_values,'less_than_once_a_month') ...
    + 3*strcmp(found_values,'once_a_month_to_once_a_week') ...
    + 4*strcmp(found_values,'1_to_3_days_a_week') ...
    + 5*strcmp(found_values,'4_to_6_days_a_week') ...
    + 6*strcmp(found_values,'every_day') ...
    - 1*strcmp(found_values,'i_prefer_not_to_respond');
found_values=raw_appen(:,appen_indices(8)); % how often in past year were you a pedestrian
X(:,8)=1*strcmp(found_values,'never') ...
    + 2*strcmp(found_values,'less_than_once_a_month') ...
    + 3*strcmp(found_values,'once_a_month_to_once_a_week') ...
    + 4*strcmp(found_values,'1_to_3_days_a_week') ...
    + 5*strcmp(found_values,'4_to_6_days_a_week') ...
    + 6*strcmp(found_values,'every_day') ...
    - 1*strcmp(found_values,'i_prefer_not_to_respond');
found_values=raw_appen(:,appen_indices(9)); % mileage
X(:,9)=1*strcmp(found_values,'0_km__mi') ...
    + 2*strcmp(found_values,'1__1000_km_1__621_mi') ...
    + 3*strcmp(found_values,'1001__5000_km_622__3107_mi') ...
    + 4*strcmp(found_values,'5001__15000_km_3108__9321_mi') ...
    + 5*strcmp(found_values,'15001__20000_km_9322__12427_mi') ...
    + 6*strcmp(found_values,'20001__25000_km_12428__15534_mi') ...
    + 7*strcmp(found_values,'25001__35000_km_15535__21748_mi') ...
    + 8*strcmp(found_values,'35001__50000_km_21749__31069_mi') ...
    + 9*strcmp(found_values,'50001__100000_km_31070__62137_mi') ...
    + 10*strcmp(found_values,'more_than_100000_km_more_than_62137_mi') ...
    - 1*strcmp(found_values,'i_prefer_not_to_respond');
found_values=string(raw_appen(:,appen_indices(10))); % number of accidents in past 3 years
X(:,10)=1*strcmp(found_values,'0') ...
    + 2*strcmp(found_values,'1') ...
    + 3*strcmp(found_values,'2') ...
    + 4*strcmp(found_values,'3') ...
    + 5*strcmp(found_values,'4') ...
    + 6*strcmp(found_values,'5') ...
    + 9*strcmp(found_values,'more_than_5') ...
    - 1*strcmp(found_values,'i_prefer_not_to_respond');
found_values=raw_appen(:,appen_indices(11:17)); % driver behaviour questionnaire (DBQ1-7)
X(:,11:17)=1*strcmp(found_values,'0_times_per_month') ...
    + 2*strcmp(found_values,'1_to_3_times_per_month') ...
    + 3*strcmp(found_values,'4_to_6_times_per_month') ...
    + 4*strcmp(found_values,'7_to_9_times_per_month') ...
    + 5*strcmp(found_values,'10_or_more_times_per_month')...
    - 1*strcmp(found_values,'i_prefer_not_to_respond');
found_values=raw_appen(:,appen_indices(18)); % eye contact importance for safety
X(:,18)=1*strcmp(found_values,'completely_disagree') ...
    + 2*strcmp(found_values,'disagree') ...
    + 3*strcmp(found_values,'neither_agree_nor_disagree') ...
    + 4*strcmp(found_values,'agree') ...
    + 5*strcmp(found_values,'completely_agree')...
    - 1*strcmp(found_values,'i_prefer_not_to_respond');
found_values=raw_appen(:,appen_indices(19)); % eye contact meaning for driver
X(:,19)=1*strcmp(found_values,'i_should_stop') ...
    + 2*strcmp(found_values,'the_pedestrian_should_stop') ...
    + 3*strcmp(found_values,'both_should_stop') ...
    + 4*strcmp(found_values,'neither_should_stop') ...
    - 1*strcmp(found_values,'i_prefer_not_to_respond');
found_values=raw_appen(:,appen_indices(20)); % eye contact meaning for pedestrian
X(:,20)=1*strcmp(found_values,'i_should_stop') ...
    + 2*strcmp(found_values,'the_driver_should_stop') ...
    + 3*strcmp(found_values,'both_should_stop') ...
    + 4*strcmp(found_values,'neither_should_stop') ...
    - 1*strcmp(found_values,'i_prefer_not_to_respond');
found_values=raw_appen(:,appen_indices(21)); % worker code
for i=1:size(found_values,1)
    try if strcmp(found_values(i),'?')
            X(i,21)=NaN;
        else
            X(i,21)=cell2mat(found_values(i));
        end
    catch error
        X(i,21)=NaN;
    end
end
found_values=raw_appen(:,appen_indices(22)); % country
Country=cell(size(X,1),1);
for i=1:size(found_values,1)
    try
        % try to extract country code
        Country(i)=unique(found_values(i));
    catch error
        Country(i)={'NaN'};
    end
end
% set -1 responses (prefer not to repond, missing data) values to NaN
X(X<0)=NaN;

%%% Survey time
for i=1:size(raw_appen, 1)
    starttime=datenum(raw_appen{i,appen_indices(23)});
    endtime=datenum(raw_appen{i,appen_indices(24)});
    X(i,23)=starttime; % save start time
    X(i,24)=endtime;  % save end time
    X(i,25)=round(24*3600*(endtime - starttime));  % survey time
end
disp([datestr(now, 'HH:MM:SS.FFF') ' - Survey time mean (minutes) before filtering = ' num2str(nanmean(X(:,25)/60))]); %#ok<*NANMEAN>
disp([datestr(now, 'HH:MM:SS.FFF') ' - Survey time median (minutes) before filtering = ' num2str(nanmedian(X(:,25)/60))]); %#ok<*NANMEDIAN>
disp([datestr(now, 'HH:MM:SS.FFF') ' - Survey time SD (minutes) before filtering = ' num2str(nanstd(X(:,25)/60))]); %#ok<*NANSTD>
disp([datestr(now, 'HH:MM:SS.FFF') ' - First survey start date before filtering = ' datestr(min(X(:,23)))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Last survey end date before filtering = ' datestr(max(X(:,24)))]);

%%% Worker ID
found_ids=raw_appen(:,appen_indices(25));
for i=1:size(found_ids,1)
    try if strcmp(found_ids(i),'?')
            X(i,26)=NaN;
        else
            X(i,26)= cell2mat(found_ids(i));
        end
    catch error
        X(i,26)=NaN;
    end
end

disp([datestr(now, 'HH:MM:SS.FFF') ' - End of processing appen data']);

%% Process keypress data
if read_heroku==1
    raw_heroku1 = readmatrix(heroku_files{1},'outputtype','string','NumHeaderLines',0);
    raw_heroku2 = readmatrix(heroku_files{2},'outputtype','string','NumHeaderLines',0);
    raw_heroku2(:,2504:6562)=raw_heroku1(end,end); % Fill with 'missing' to make sure that the two data files have the same number of columns
    raw_heroku=[raw_heroku1;raw_heroku2]; % Append the two files to create 1 file 'raw_heroku'
    clear raw_heroku1 raw_heroku2;
end
%%
if read_heroku==1
    num_in_row = 2000; % assumed max possible number of values for 1 stimulus
    Stats = NaN(size(raw_appen,1), 100); % reaction time values for participants
    Postexperimentresponses=NaN(size(raw_appen,1), 3);
    Match=NaN(size(raw_appen,1), 1);
    RT = NaN(size(raw_appen,1), num_stimuli, num_in_row); % reaction time values for participants
    RP1 = NaN(size(raw_appen,1), num_stimuli); % Response to eye contact question
    RP2 = NaN(size(raw_appen,1), num_stimuli); % Response to intuitiveness question
    RP3 = NaN(size(raw_appen,1), num_stimuli); % Response to injection question
    RP3_qtext = NaN(size(raw_appen,1), num_stimuli); % Response to injection question
    Resolution = NaN(size(raw_appen,1), 4); % Response to intuitiveness question
    StimulusIDs  = NaN(size(raw_appen,1), num_stimuli); % Stimuli shown (number of participants x number of stimuli matrix)
    found_values = zeros(size(raw_appen,1),1+num_stimuli); % Flags for blocks that were found.
    TrialDuration  = NaN(size(raw_appen,1), num_stimuli); % Trial durations (number of participants x number of stimuli matrix)
    cheater_worker_codes=[];  % store worker_codes of cheaters
    
    Elapsed_time_start  = NaN(size(raw_appen,1), num_stimuli); % Trial durations (number of participants x number of stimuli matrix)
    Elapsed_time_end  = NaN(size(raw_appen,1), num_stimuli); % Trial durations (number of participants x number of stimuli matrix)
    Elapsed_time_last_of_row  = NaN(size(raw_appen,1), num_stimuli); % Trial durations (number of participants x number of stimuli matrix)
    
    disp([datestr(now, 'HH:MM:SS.FFF') ' - Start of processing heroku data']);
    
    for row_heroku=1:size(raw_heroku,1) % loop over rows
        
        if (mod(row_heroku,100)==0);disp([datestr(now, 'HH:MM:SS.FFF') ' - Processing row ' num2str(row_heroku) ' in heroku data ']); end
        
        RT_row           = NaN(1,num_in_row);  % initialize values for row
        RP1_row          = NaN(1,1);           % initialize values for row
        RP2_row          = NaN(1,1);           % initialize values for row
        RP3_row          = NaN(1,1);           % initialize values for row
        RP3_qtext_row    = NaN(1,1);           % initialize values for row
        Start_time_row   = NaN(1,1);           % initialize values for row
        End_time_row     = NaN(1,1);           % initialize values for row
        stimuli_id_row   = NaN(1,1);           % initialize values for row
        Elapsed_time_row   = NaN;              % initialize values for row
        
        stats_row=[];
        postexperimentresponses=[];
        counter_rt = 0; % set counter to 0
        counter_rp1 = 0; % set counter to 0
        counter_rp2 = 0; % set counter to 0
        counter_rp3 = 0; % set counter to 0
        counter_rp3_qtext = 0; % set counter to 0
        counter_stimuli_id = 0; % set counter to 0
        rts_detected = false;  % flag for starting to record RTs of stimulus
        heroku_code = '';  % worker_code in heroku data
        
        extracted_row = rmmissing(raw_heroku(row_heroku,:)); % row of data in heroku
        
        if contains(extracted_row(2),{'data:[{"success":true'}) % if the row contains stats information (browser, etc)
            stats_row=1;
            for cell_counter=1:length(extracted_row)
                cell_row=cell2mat(extracted_row(cell_counter)); % work with 1 particular cell from the row of data
                if contains(cell_row,'worker_code')% Worker_code found
                    code_regex = regexp(cell_row, code_pattern, 'match');
                    heroku_code = code_regex(1);
                end
                if contains(cell_row,'window_height_init:')%
                    resolution(1)=sscanf(cell_row(1+max(strfind(cell_row,':')):end),'%f');
                end
                if contains(cell_row,'window_width_init:')%
                    resolution(2)=sscanf(cell_row(1+max(strfind(cell_row,':')):end),'%f');
                end
                if contains(cell_row,'window_height:')%
                    resolution(3)=sscanf(cell_row(1+max(strfind(cell_row,':')):end),'%f');
                end
                if contains(cell_row,'window_width:')%
                    resolution(4)=sscanf(cell_row(1+max(strfind(cell_row,':')):end),'%f');
                end
            end
        elseif contains(extracted_row(3),{'importance\'}) % if the row contains the results of the post-experiment questions
            postexperimentresponses=[sscanf(extracted_row{3}(1+max(strfind(extracted_row{3},':')):end),'%f') ...
                sscanf(extracted_row{4}(1+max(strfind(extracted_row{4},':')):end),'%f') ...
                sscanf(extracted_row{5}(1+max(strfind(extracted_row{5},':')):end),'%f')];
            for cell_counter=1:length(extracted_row)
                cell_row=cell2mat(extracted_row(cell_counter)); % work with 1 particular cell from the row of data
                if contains(cell_row,'worker_code')% Worker_code found
                    code_regex = regexp(cell_row, code_pattern, 'match');
                    heroku_code = code_regex(1);
                    continue
                end
            end
            
        else % if the row contains data
            for cell_counter=1:length(extracted_row)
                
                cell_row=cell2mat(extracted_row(cell_counter)); % work with 1 particular cell from the row of data
                
                % check if keypress times for stimulus will follow
                if contains(cell_row, 'rts:[')
                    rts_detected = true;  % flag to start recording RTs from stimulus
                    counter_rt = 0;  % reset countrer of RTs for stimulus
                    try
                        starttimecell=extracted_row{cell_counter-3};
                        Start_time_row = sscanf(starttimecell(1+max(strfind(starttimecell,':')):end),'%f'); % Store time elapsed in a single vector for row (not per block)
                    catch error
                    end
                end
                
                % Keypress time
                if rts_detected
                    if contains(cell_row,'rt:') && rts_detected % keypress time found
                        counter_rt = counter_rt + 1;
                        RT_row(counter_rt) = sscanf(cell_row(1+max(strfind(cell_row,':')):end),'%f'); % Store RT in RT_row
                        continue
                    end
                end
                
                % Post-trial question 1
                if size(cell_row,2) >= 4
                    if contains(cell_row(1:4),'resp') % Response to question found
                        counter_rp1 = counter_rp1 + 1;
                        RP1_row(counter_rp1) = sscanf(cell_row(1+max(strfind(cell_row,':')):end),'%f');
                        continue;  % only 1 item can be picked up form the cell
                    end
                end
                
                % Post-trial question 2
                if contains(cell_row,'\"intuitive') % Response to question found
                    counter_rp2 = counter_rp2 + 1;
                    RP2_row(counter_rp2) = sscanf(cell_row(1+max(strfind(cell_row,':')):end),'%f');
                    continue
                end
                
                if contains(cell_row,'\"injection') % Response to question found
                    counter_rp3 = counter_rp3 + 1;
                    RP3_row(counter_rp3) = sscanf(cell_row(1+max(strfind(cell_row,':')):end),'%f');
                    continue
                end
                
                if contains(cell_row,'injection_q:') % Response to question found
                    counter_rp3_qtext = counter_rp3_qtext + 1;
                    if contains(cell_row,'injection_q:"na"')
                        RP3_qtext_row(counter_rp3_qtext) = 1;
                    elseif contains(cell_row,'injection_q:"2+4=6."')
                        RP3_qtext_row(counter_rp3_qtext) = 2;
                    elseif contains(cell_row,'injection_q:"3+2=5."')
                        RP3_qtext_row(counter_rp3_qtext) = 3;
                    elseif contains(cell_row,'injection_q:"4+3=9."')
                        RP3_qtext_row(counter_rp3_qtext) = 4;
                    elseif contains(cell_row,'injection_q:"2+2=5."')
                        RP3_qtext_row(counter_rp3_qtext) = 5;
                    elseif contains(cell_row,'injection_q:"The current year is 2013."')
                        RP3_qtext_row(counter_rp3_qtext) = 6;
                    elseif contains(cell_row,'injection_q:"France is in Europe."')
                        RP3_qtext_row(counter_rp3_qtext) = 7;
                    elseif contains(cell_row,'injection_q:"The earth is round."')
                        RP3_qtext_row(counter_rp3_qtext) = 8;
                    elseif contains(cell_row,'injection_q:"Oranges are orange."')
                        RP3_qtext_row(counter_rp3_qtext) = 9;
                    elseif contains(cell_row,'injection_q:"Tomatoes are red."')
                        RP3_qtext_row(counter_rp3_qtext) = 10;
                    elseif contains(cell_row,'injection_q:"Bananas are yellow."')
                        RP3_qtext_row(counter_rp3_qtext) = 11;
                    end
                    continue
                end
                
                % Worker code (code the participant receives at the end of the experiment)
                if contains(cell_row,'worker_code')% Worker_code found
                    code_regex = regexp(cell_row, code_pattern, 'match');
                    heroku_code = code_regex(1);
                    continue
                end
                
                if contains(cell_row,'trial_type:"video-keyboard-multiple-responses-release"')
                    endtimecell=extracted_row{cell_counter+3};
                    End_time_row = sscanf(endtimecell(1+max(strfind(endtimecell,':')):end),'%f'); % Store time elapsed in a single vector for row
                    if isempty(End_time_row)
                        endtimecell=extracted_row{cell_counter+2};
                        End_time_row = sscanf(endtimecell(1+max(strfind(endtimecell,':')):end),'%f'); % Store time elapsed in a single vector for row
                    end
                    continue
                end
                
                % Elapsed time
                if contains(cell_row,'time_elapsed:')
                    Elapsed_time_row_last = sscanf(cell_row(1+max(strfind(cell_row,':')):end),'%f');
                    continue
                end
                
                % stimulus ID
                if contains(cell_row,'{"stimulus":"[\"videos/video_')
                    rts_detected = false; % reached the end of RT values for the stimulus
                    counter_stimuli_id = counter_stimuli_id + 1; % detected new stimulus ID
                    stimuli_id_row(counter_stimuli_id) = sscanf(cell_row(1+min(strfind(cell_row,'_')):-1+max(strfind(cell_row,'.mp4'))),'%f');
                    continue
                end
                
            end % end of loop over cells in row
        end % end of 'if is not a stats row'
        
        % now store in Appen-matched matrices
        row_appen_matched=find(strcmp(heroku_code, raw_appen(:,appen_indices(21)))); % Find occurences of the Heroku Worker Code in the Appen data
        
        if ~isempty(row_appen_matched) % if the Heroku code is found in the Appen data
            if size(row_appen_matched, 1) > 1 % if the Heroku code is found more than once in the Appen data, this worker is labelled as a cheater
                if ~any(strcmp(cheater_worker_codes, heroku_code)) % If the Worker Code was not marked as a cheater before, then add to the list of cheaters
                    cheater_worker_codes = [cheater_worker_codes, heroku_code]; %#ok<AGROW>
                end
            end
            
            row_appen_matched=row_appen_matched(1); % Use only the first occurrence of Heroku Worker Code
            
            if ~isempty(stats_row) % if stats only
                Stats(row_appen_matched,1:length(stats_row))=stats_row;
                Resolution(row_appen_matched,1:4)=resolution;
            elseif ~isempty(postexperimentresponses)
                Postexperimentresponses(row_appen_matched,:)=postexperimentresponses;
            else % if RT data
                if found_values(row_appen_matched,1) == 0
                    block_number = 1;
                    Match(row_appen_matched) = 1;  % flag that row was matched
                else
                    block_number = find(found_values(row_appen_matched,:),1,'last')+1; % determine block number from last indexed block
                end
                found_values(row_appen_matched, block_number) = 1;
                
                if counter_stimuli_id==1 && counter_rp1==1 && counter_rp2==1 && counter_stimuli_id==1 && block_number<=num_stimuli && ~isnan(RP1_row) && ~isnan(RP2_row) % Expected number of datapoints found in Heroku row
                    RT(row_appen_matched, block_number,:)   = RT_row(1:num_in_row);   % Store in matrix
                    RP1(row_appen_matched, block_number)    = RP1_row;                % Store in matrix
                    RP2(row_appen_matched, block_number)    = RP2_row;                % Store in matrix
                    RP3(row_appen_matched, block_number)    = RP3_row;                % Store in matrix
                    RP3_qtext(row_appen_matched, block_number)    = RP3_qtext_row;                % Store in matrix
                    TrialDuration(row_appen_matched, block_number) = End_time_row-Start_time_row; % Store in matrix
                    Elapsed_time_start(row_appen_matched, block_number) = Start_time_row;         % Store in matrix
                    Elapsed_time_end(row_appen_matched, block_number) = End_time_row;             % Store in matrix
                    Elapsed_time_last_of_row(row_appen_matched, block_number) = Elapsed_time_row_last; % Store in matrix
                    StimulusIDs(row_appen_matched, block_number) = stimuli_id_row;  % Store in matrix
                else
                end
            end
        end % end of ~isempty(row_appen_matched)
    end % end of loop over row
    
    disp([datestr(now, 'HH:MM:SS.FFF') ' - End of processing heroku data']);
    save('AllHerokuData.mat','RT','RP1','RP2','RP3','RP3_qtext','TrialDuration','Elapsed_time_start','Elapsed_time_end','Elapsed_time_last_of_row','StimulusIDs','Postexperimentresponses','found_values','Stats','Match','Resolution')
else
    load('AllHerokuData.mat')
end
%% Analyse responses to text questions
CorrectAnswers=[NaN 1 1 0 0 0 1 1 1 1 1];
CorrectPercentage=NaN(size(CorrectAnswers));
RP3_Correct=NaN(size(RP3));
for i=2:length(CorrectAnswers)
    Correct=find(RP3_qtext==i & RP3==CorrectAnswers(i));
    InCorrect=find(RP3_qtext==i & RP3~=CorrectAnswers(i));
    RP3_Correct(Correct)=1;
    RP3_Correct(InCorrect)=0;
    CorrectPercentage(i)=length(Correct)./(length(Correct)+length(InCorrect));
end

%% Computer estimated trial duration. Trial duration sometimes has to be estimated since it was not recorded.
% using the elapsed time from the previous trial does not seem reliable (too high values)
% Median substitution was used for estimating the trial durations
TrialDurationEstimated=TrialDuration;
for i=1:size(Elapsed_time_end,1)
    TrialDurationYielding=nanmedian(TrialDuration(i,ismember(StimulusIDs(i,:),0:10)));
    TrialDurationNonYielding=nanmedian(TrialDuration(i,ismember(StimulusIDs(i,:),11:12)));
    
    YieldingMissingIndexes=find(ismember(StimulusIDs(i,:),0:10) & isnan(TrialDuration(i,:)));
    NonYieldingMissingIndexes=find(ismember(StimulusIDs(i,:),11:12) & isnan(TrialDuration(i,:)));
    
    YieldingMissingIndexes(YieldingMissingIndexes==1)=[]; % trial duration is not estimated for the first trial, as the first trial relatively often contains lag
    NonYieldingMissingIndexes(NonYieldingMissingIndexes==1)=[]; % trial duration is not estimated for the first trial, as the first trial relatively often contains lag
    
    TrialDurationEstimated(i,YieldingMissingIndexes)=TrialDurationYielding;
    TrialDurationEstimated(i,NonYieldingMissingIndexes)=TrialDurationNonYielding;
end
%% Some checks of trial duration for the different pilot tests that were done (some of them involved a higher FPS of the videos)
% not used for the paper
TrialDuration_part1=TrialDuration(X(:,23)<738238,1:26);
TrialDuration_part2=TrialDuration(X(:,23)>738238 & X(:,23)<=738250,1:26);
TrialDuration_part3=TrialDuration(X(:,23)>738250,1:26);
StimulusIDs_part1=StimulusIDs(X(:,23)<738238,1:26);
StimulusIDs_part2=StimulusIDs(X(:,23)>738238 & X(:,23)<=738250,1:26);
StimulusIDs_part3=StimulusIDs(X(:,23)>738250,1:26);

TrialDuration_part1_all=TrialDuration_part1(ismember(StimulusIDs_part1,0:10));
TrialDuration_part2_all=TrialDuration_part2(ismember(StimulusIDs_part2,0:10));
TrialDuration_part3_all=TrialDuration_part3(ismember(StimulusIDs_part3,0:10));

disp('Pilot 1: 31-s videos')
disp([sum(TrialDuration_part1_all>0) sum(TrialDuration_part1_all<31000) sum(TrialDuration_part1_all>33000) sum(TrialDuration_part1_all>33000*1.2) sum(isnan(TrialDuration_part1_all))])
disp('Pilot 2: 31-s videos')
disp([sum(TrialDuration_part2_all>0) sum(TrialDuration_part2_all<31000) sum(TrialDuration_part2_all>33000) sum(TrialDuration_part2_all>33000*1.2) sum(isnan(TrialDuration_part2_all))])
disp('Pilot 3: 31-s videos')
disp([sum(TrialDuration_part3_all>0) sum(TrialDuration_part3_all<31000) sum(TrialDuration_part3_all>33000) sum(TrialDuration_part3_all>33000*1.2) sum(isnan(TrialDuration_part3_all))])

TrialDuration_part1_all=TrialDuration_part1(ismember(StimulusIDs_part1,11:12));
TrialDuration_part2_all=TrialDuration_part2(ismember(StimulusIDs_part2,11:12));
TrialDuration_part3_all=TrialDuration_part3(ismember(StimulusIDs_part3,11:12));

disp('Pilot 1: 21-s videos')
disp([sum(TrialDuration_part1_all>0) sum(TrialDuration_part1_all<21000) sum(TrialDuration_part1_all>23000) sum(TrialDuration_part1_all>21000*1.2) sum(isnan(TrialDuration_part1_all))])
disp('Pilot 2: 21-s videos')
disp([sum(TrialDuration_part2_all>0) sum(TrialDuration_part2_all<21000) sum(TrialDuration_part2_all>23000) sum(TrialDuration_part2_all>21000*1.2) sum(isnan(TrialDuration_part2_all))])
disp('Pilot 3: 21-s videos')
disp([sum(TrialDuration_part3_all>0) sum(TrialDuration_part3_all<21000) sum(TrialDuration_part3_all>23000) sum(TrialDuration_part3_all>21000*1.2) sum(isnan(TrialDuration_part3_all))])

%% Find participants who did not meet the criteria

invalid1 = find(X(:,1)==1);    % respondents who did not read instructions
invalid2 = find(X(:,3)<18);    % respondents who indicated they are under 18 years old
invalid3 = find(X(:,25)<1000); % respondents who took less than 1000 s to complete the study
invalid4 = find(Match~=1);     % no match
invalid5=find(nansum(RP3_Correct'>=0)<8)'; %#ok<*NANSUM> % 2 mistakes seems legit. So 8, 9, and 10 correct are included

[NumberofTrialsWithDuration,NumberofLongTrials]=deal(NaN(size(TrialDuration,1),1));
for i=1:size(TrialDuration,1)
    NumberofLongTrials(i)=sum(TrialDurationEstimated(i,ismember(StimulusIDs(i,:),0:10))>36000)+sum(TrialDurationEstimated(i,ismember(StimulusIDs(i,:),11:12))>26000); % more than 5 s delay
end

invalid6 =find(NumberofLongTrials>2); % participants with playback issues in more than 2 trials

pp_multiple_ips=NaN(size(X(:,1)));
ip_appen=NaN(size(raw_appen,1),1);  % IP addresses in appen data

% reduce IP addresses of appen data to a single number
for i=1:size(raw_appen,1)
    try
        ip_appen(i)=str2double(strrep(raw_appen(i,appen_indices(26)),'.',''));
    catch
        ip_appen(i)=cell2mat(raw_appen(i,appen_indices(26)));
    end
end

% go over IPs in appen data
for i=1:size(X,1)
    % IPs for the value in question
    found_ips=find(ip_appen==ip_appen(i));
    % if the IP address occurs only once
    if length(found_ips)==1
        pp_multiple_ips(i)=1; % only IP found, so keep
    elseif length(found_ips)>1 % if the IP addres occurs more than once
        pp_multiple_ips(found_ips(1))=1; % keep the first survey for that IP address
        pp_multiple_ips(found_ips(2:end))=2; % do not keep the other ones
    end
end

invalid7=find(pp_multiple_ips>1); % respondents who completed the survey more than once, i.e., remove the doublets.
% invalid 7 is not used for this study
%% Remove invalid participants
invalid = unique([invalid1;invalid2;invalid3;invalid4;invalid5;invalid6]); % add together all invalid rows with data
X(invalid,:)=[];
Country(invalid)=[];
RT(invalid,:,:)=[];
RP1(invalid,:)=[];
RP2(invalid,:)=[];
RP3(invalid,:)=[];
RP3_qtext(invalid,:)=[];
RP3_Correct(invalid,:)=[];
raw_appen(invalid,:)=[];
Postexperimentresponses(invalid,:)=[];
Resolution(invalid,:)=[];
Stats(invalid,:)=[];
StimulusIDs(invalid,:)=[];
TrialDuration(invalid,:)=[];
TrialDurationEstimated(invalid,:)=[];

%% Output statistics and filtering information

disp([datestr(now, 'HH:MM:SS.FFF') ' - Number of respondents who did not read instructions = ' num2str(length(invalid1))])
disp([datestr(now, 'HH:MM:SS.FFF') ' - Number of respondents under 18 = ' num2str(length(invalid2))])
disp([datestr(now, 'HH:MM:SS.FFF') ' - Number of respondents who took less than given amount of time = ' num2str(length(invalid3))])
disp([datestr(now, 'HH:MM:SS.FFF') ' - Number of rows in keypress data not matched =  ' num2str(length(invalid4))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Number of responses who failed test questions = ' num2str(length(invalid5))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Number of responses with playback delay = ' num2str(length(invalid6))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Number of responses coming from the same IP = ' num2str(length(invalid7))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Number of respondents removed = ' num2str(length(invalid))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Number of respondents included in the analysis =  ' num2str(size(X,1))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Number of countries included in the analysis =  ' num2str(length(unique(Country)))]);

disp([datestr(now, 'HH:MM:SS.FFF') ' - Gender, male respondents after filtering = ' num2str(sum(X(:,2)==2))])
disp([datestr(now, 'HH:MM:SS.FFF') ' - Gender, female respondents after filtering = ' num2str(sum(X(:,2)==1))])
disp([datestr(now, 'HH:MM:SS.FFF') ' - Gender, I prefer not to respond after filtering = ' num2str(sum(isnan(X(:,2))))])
disp([datestr(now, 'HH:MM:SS.FFF') ' - Age, mean after filtering = ' num2str(nanmean(X(:,3)))])
disp([datestr(now, 'HH:MM:SS.FFF') ' - Age, sd filtering = ' num2str(nanstd(X(:,3)))])

disp([datestr(now, 'HH:MM:SS.FFF') ' - Study completion time mean (minutes) after filtering = ' num2str(nanmean(X(:,25)/60))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Study completion time median (minutes) after filtering = ' num2str(nanmedian(X(:,25)/60))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Study completion time SD (minutes) after filtering = ' num2str(nanstd(X(:,25)/60))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - First study start date after filtering = ' datestr(min(X(:,23)))]);
disp([datestr(now, 'HH:MM:SS.FFF') ' - Last study end date after filtering = ' datestr(max(X(:,24)))]);

disp('Number of participants with desktop, laptop, tablet, mobile, other, no response =')
disp([sum(strcmp(raw_appen(:,39),'desktop_keyboard'))
    sum(strcmp(raw_appen(:,39),'laptop_keyboard'))
    sum(strcmp(raw_appen(:,39),'tablet_keyboard'))
    sum(strcmp(raw_appen(:,39),'mobile_keyboard'))
    sum(strcmp(raw_appen(:,39),'other'))
    sum(strcmp(raw_appen(:,39),'i_prefer_not_to_respond'))])

disp('Number of participants walking from 1 (never) to 6 (every day), last item: NaN = no response')
disp([histc(X(:,8),1:6);sum(isnan(X(:,8)))]) %#ok<HISTC>

%% Most common countries (after filtering)
[~, ~, ub] = unique(Country);
test2counts = histcounts(ub, 'BinMethod','integers');
[B,I] = maxk(test2counts,5);
country_unique = unique(Country);
if (size(country_unique,1) > 0)
    disp('Most common countries (after filtering) = ')
    disp(country_unique(I)')
    disp(B)
end
%%
key_pressesf = NaN(size(RT,1),num_stimuli/2,800);
NumberofVideosPlayed = NaN(size(RT,1),num_stimuli/2);
SM=NaN(16,13);
SM2=NaN(16,13);

for i = 1:size(RT,1) % loop over participants
    for j = 1:num_stimuli % loop over videos (26)
        if (ismember(StimulusIDs(i,j),0:10) && TrialDurationEstimated(i,j)<33000 && TrialDurationEstimated(i,j)>=30900) || (ismember(StimulusIDs(i,j),11:12) && TrialDurationEstimated(i,j)<23000 && TrialDurationEstimated(i,j)>=20900) % fix for checking video_id (different than older studies)
            rts = squeeze(RT(i,j,:))/1000; % Vector RTs of person in seconds. The vector is filled with 0s after the last RT.
            rts(isnan(rts))=[]; % remove NaNs
            % start of filling the 0.5-s gaps
            if length(rts)>=2 % fill data gap for first half a second (0.5 s) of holding the key
                if   rts(1)<=0.54 % if the first button press is 'exactly' at 0.5 seconds, suggesting that participants held the key
                    rts=[transpose(0.04:0.04:rts(1));rts(2:end)];
                end
                gapindexes=1+find(diff(rts)>=0.42 & diff(rts)<=0.54); % indexes where the gap is 'exactly' 0.5 seconds, suggesting that participants held the key
                for k=length(gapindexes):-1:1 % loop over all gaps (backward order)
                    rts=[rts(1:gapindexes(k)-1);transpose(rts(gapindexes(k)-1)+0.04:0.04:rts(gapindexes(k)));rts(gapindexes(k):end)]; % fill with button press data
                end
            end
            % end of filling the 0.5-s gaps
            
            if ismember(StimulusIDs(i,j),0:10)
                rts=video_info(1,1)*rts./(TrialDurationEstimated(i,j)/1000); % normalize the key press data to a range from 0 s to video length
            elseif ismember(StimulusIDs(i,j),11:12)
                rts=video_info(13,1)*rts./(TrialDurationEstimated(i,j)/1000); % normalize the key press data to a range from 0 s to video length
            end
            
            O = 10 * unique(round(rts,1));  % Indices where button is pressed (in 0.1-second increments)
            if isnan(key_pressesf(i,1+StimulusIDs(i,j),1))
                key_pressesf(i,1+StimulusIDs(i,j),:) = 0;
                O(O==0) = [];
                key_pressesf(i,1+StimulusIDs(i,j),O) = key_pressesf(i,1+StimulusIDs(i,j),O) + 1;
                NumberofVideosPlayed(i,1+StimulusIDs(i,j))=1;
            else
                O(O==0) = [];
                key_pressesf(i,1+StimulusIDs(i,j),O) = key_pressesf(i,1+StimulusIDs(i,j),O) + 1;
                NumberofVideosPlayed(i,1+StimulusIDs(i,j))=2;
            end
        end
    end
end

% divide key presses by the number of times the video was played
for i = 1:size(RT,1) % loop over participants
    for j = 1:size(RT,2)/2 % loop over videos
        key_pressesf(i,j,:)=key_pressesf(i,j,:)./NumberofVideosPlayed(i,j);
    end
end

disp(['Number of trials with data = ' num2str(sum(nansum(NumberofVideosPlayed)))])
disp(['Total number of trials = ' num2str(2*size(NumberofVideosPlayed,1)*size(NumberofVideosPlayed,2))])

%% Post-trial question data

[Q1,NumberofQ1] = deal(NaN(size(RP1,1),num_stimuli/2));
for i = 1:size(RP1,1) % loop over participants
    for j = 1:num_stimuli % loop over videos
        if (ismember(StimulusIDs(i,j),0:10) && TrialDurationEstimated(i,j)<33000 && TrialDurationEstimated(i,j)>=30900) || (ismember(StimulusIDs(i,j),11:12) && TrialDurationEstimated(i,j)<23000 && TrialDurationEstimated(i,j)>=20900) % fix for checking video_id (different than older studies)
            if isnan(Q1(i,1+StimulusIDs(i,j)))
                Q1(i,1+StimulusIDs(i,j)) = RP1(i,j);
                NumberofQ1(i,1+StimulusIDs(i,j))=1;
            else
                Q1(i,1+StimulusIDs(i,j)) = Q1(i,1+StimulusIDs(i,j)) + RP1(i,j);
                NumberofQ1(i,1+StimulusIDs(i,j))=2;
            end
        end
    end
end

for i = 1:size(RP1,1) % loop over participants
    for j = 1:num_stimuli/2 % loop over videos
        Q1(i,j)=Q1(i,j)./NumberofQ1(i,j);
    end
end

[Q2,NumberofQ2] = deal(NaN(size(RP1,1),num_stimuli/2));
for i = 1:size(RP2,1) % loop over participants
    for j = 1:num_stimuli % loop over videos
        if (ismember(StimulusIDs(i,j),0:10) && TrialDurationEstimated(i,j)<33000 && TrialDurationEstimated(i,j)>=30900) || (ismember(StimulusIDs(i,j),11:12) && TrialDurationEstimated(i,j)<23000 && TrialDurationEstimated(i,j)>=20900) % fix for checking video_id (different than older studies)
            if isnan(Q2(i,1+StimulusIDs(i,j)))
                Q2(i,1+StimulusIDs(i,j)) = RP2(i,j);
                NumberofQ2(i,1+StimulusIDs(i,j))=1;
            else
                Q2(i,1+StimulusIDs(i,j)) = Q2(i,1+StimulusIDs(i,j)) + RP2(i,j);
                NumberofQ2(i,1+StimulusIDs(i,j))=2;
            end
        end
    end
end
for i = 1:size(RP2,1) % loop over participants
    for j = 1:num_stimuli/2 % loop over videos
        Q2(i,j)=Q2(i,j)./NumberofQ2(i,j);
    end
end
%% Create distinguishable colors
colors(1,:)=[0 0 0]; % No eye contact
colors(6,:)=[31 198 0]/255; % First visible–Out of sight

colors(12,:)=[0.5 0.5 0.5]; % No eye contact, no yielding
colors(13,:)=[14 255 0]/255; % First visible-Out of sight, no yielding

colors(11,:)=[75 200 244]/255; % Braking start–Out of sight
colors(7,:)=[21 146 202]/255; % Full stop–Out of sight

colors(2,:)=[255 0 0 ]/255; % First visible–Full stop
colors(9,:)=[247 144 57]/255; % Braking start–Full stop

colors(3,:)=[255 0 255]/255; % First visible–Take-off

colors(4,:)=[135 110 88]/255; % Full stop–Take-off
colors(5,:)=[254 139 141]/255; % Take off–Out of sight
colors(8,:)=[209 255 213]/255; % First visible–Braking start
colors(10,:)=[0 0 255]/255; % Braking start–Take-off
%% Figure 2
time = (0.05:0.1:size(key_pressesf,3)/10)'; % time vector
opengl hardware
figure;hold on;grid on;box on

xlabel('Time (s)')
ylabel('Percentage of trials with response key pressed')
rectangle('position',[-1 -100 2 300],'facecolor',[127 127 127 20]/255,'Linewidth',.5);
plot([video_info(11,2) video_info(11,2)],[-100 100],'k-')
text((video_info(11,2)+1)/2,58,'Approaching at 15 km/h','horizontalalignment','center')
plot([17.64 17.64],[-100 100],'k-')
text(15.62,58,'Braking','horizontalalignment','center')
plot([22.92 22.92],[-100 100],'k-')
text(20.26,58,'Standing still','horizontalalignment','center')
plot([26.52 26.52],[-100 100],'k-')
text(24.72,58,'Driving off','horizontalalignment','center')
text(28.76,58,'Out of sight','horizontalalignment','center')
v1=1;
v2=6;
V1 = 100 * squeeze(nanmean(nanmean(key_pressesf(:,v1,:),2),1));
V2 = 100 * squeeze(nanmean(nanmean(key_pressesf(:,v2,:),2),1));

hh(2)=plot(time,V2,'color',colors(v2,:),'Linewidth',2);
IV=find(time>=video_info(v2,2) & time<=video_info(v2,4)+0.1);plot(time(IV),V2(IV),'color',colors(v2,:),'Linewidth',6);
hh(1)=plot(time,V1,'color',colors(v1,:),'Linewidth',2);

[~,p]=ttest(squeeze(key_pressesf(:,v1,:)),squeeze(key_pressesf(:,v2,:)));
plot(time(p<0.001),2,'*','color',[0 0 0])
set(gca,'LooseInset',[0.01 0.01 0.01 0.01],'xlim',[0 30.9],'xtick',1:2:32,'ylim',[0 60],'ytick',0:5:100,'ticklength',[0.005 0.005])
l=legend(hh,'1. Yielding: No eye contact','6. Yielding: First visible–Out of sight','autoupdate','off','location','southwest');
h=findobj('FontName','Helvetica'); set(h,'FontSize',20,'Fontname','Arial')
set(l,'position',[0.08 0.532364139840775 0.247395826751987 0.0690550344260187])
if savepng==1;set(gcf,'WindowState', 'maximized');print(gcf,'Figure2.png','-dpng','-r300');end
%% Figure 3. Percentage of trials in which the response key was pressed for no driver’s eye contact and driver’s eye contact throughout, for the videos in which the car did not yield.
figure;hold on;grid on;box on
xlabel('Time (s)')
ylabel('Percentage of trials with response key pressed')
rectangle('position',[-1 -100 2 300],'facecolor',[127 127 127 20]/255,'Linewidth',.5);
text((1+16.7)/2,58,'Approaching at 15 km/h','horizontalalignment','center')
plot([16.7 16.72],[-100 100],'k-')
text((16.7+21)/2,58,'Out of sight','horizontalalignment','center')
v1=12;
v2=13;
V1 = 100 * squeeze(nanmean(nanmean(key_pressesf(:,v1,:),2),1));
V2 = 100 * squeeze(nanmean(nanmean(key_pressesf(:,v2,:),2),1));

hh(2)=plot(time,V2,'color',colors(v2,:),'Linewidth',2);
IV=find(time>=video_info(v2,2) & time<=video_info(v2,4)+0.1);plot(time(IV),V2(IV),'color',colors(v2,:),'Linewidth',6);
hh(1)=plot(time,V1,'color',colors(v1,:),'Linewidth',2);

[~,p]=ttest(squeeze(key_pressesf(:,v1,:)),squeeze(key_pressesf(:,v2,:)));
plot(time(p<0.001),2,'*','color',[0 0 0])

set(gca,'LooseInset',[0.01 0.01 0.01 0.01],'xlim',[0 20.9],'xtick',1:2:32,'ylim',[0 60],'ytick',0:5:100,'ticklength',[0.005 0.005])
l=legend(hh,'12. Non-yielding: No eye contact','13. Non-yielding: First visible–Out of sight','autoupdate','off','location','southwest');
h=findobj('FontName','Helvetica'); set(h,'FontSize',20,'Fontname','Arial')
set(l,'position',[0.12 0.532364139840775 0.247395826751987 0.0690550344260187])
if savepng==1;set(gcf,'WindowState', 'maximized');print(gcf,'Figure3.png','-dpng','-r300');end
%% Figure 4. Percentage of trials in which the response key was pressed for driver’s eye contact throughout (Video 6) and eye contact initiation when the car started to brake (Video 11) or when the car came to a stop (Video 7).
clear hh
figure;hold on;grid on;box on

xlabel('Time (s)')
ylabel('Percentage of trials with response key pressed')
rectangle('position',[-1 -100 2 300],'facecolor',[127 127 127 20]/255,'Linewidth',.5);
plot([video_info(11,2) video_info(11,2)],[-100 100],'k-')
text((video_info(11,2)+1)/2,58,'Approaching at 15 km/h','horizontalalignment','center')
plot([17.64 17.64],[-100 100],'k-')
text(15.62,58,'Braking','horizontalalignment','center')
plot([22.92 22.92],[-100 100],'k-')
text(20.26,58,'Standing still','horizontalalignment','center')
plot([26.52 26.52],[-100 100],'k-')
text(24.72,58,'Driving off','horizontalalignment','center')
text(28.76,58,'Out of sight','horizontalalignment','center')
v1=6;
v2=7;
v3=11;
V1 = 100 * squeeze(nanmean(nanmean(key_pressesf(:,v1,:),2),1));
V2 = 100 * squeeze(nanmean(nanmean(key_pressesf(:,v2,:),2),1));
V3 = 100 * squeeze(nanmean(nanmean(key_pressesf(:,v3,:),2),1));
hh(1)=plot(time,V1,'color',colors(v1,:),'Linewidth',2);
hh(2)=plot(time,V2,'color',colors(v2,:),'Linewidth',2);
hh(3)=plot(time,V3,'color',colors(v3,:),'Linewidth',2);
IV=find(time>=video_info(v1,2) & time<=video_info(v1,4)+0.1);
plot(time(IV),V1(IV),'color',colors(v1,:),'Linewidth',6);
IV=find(time>=video_info(v2,2) & time<=video_info(v2,4)+0.1);
plot(time(IV),V2(IV),'color',colors(v2,:),'Linewidth',6);
IV=find(time>=video_info(v3,2) & time<=video_info(v3,4)+0.1);
plot(time(IV),V3(IV),'color',colors(v3,:),'Linewidth',6);

[~,p]=ttest(squeeze(key_pressesf(:,v1,:)),squeeze(key_pressesf(:,v2,:)));
plot(time(p<0.001),2,'*','color',colors(v2,:))
[~,p]=ttest(squeeze(key_pressesf(:,v1,:)),squeeze(key_pressesf(:,v3,:)));
plot(time(p<0.001),1,'*','color',colors(v3,:))

set(gca,'LooseInset',[0.01 0.01 0.01 0.01],'xlim',[0 30.9],'xtick',1:2:32,'ylim',[0 60],'ytick',0:5:100,'ticklength',[0.005 0.005])
l=legend(hh,'6. Yielding: First visible–Out of sight','7. Yielding: Full stop-Out of sight','11. Yielding: Braking start-Out of sight','autoupdate','off','location','southwest');
h=findobj('FontName','Helvetica'); set(h,'FontSize',20,'Fontname','Arial')
set(l,'position',[0.08 0.532364139840775 0.247395826751987 0.0690550344260187])
if savepng==1;set(gcf,'WindowState', 'maximized');print(gcf,'Figure4.png','-dpng','-r300');end
%% Figure 5. Percentage of trials in which the response key was pressed for no driver’s eye contact throughout (Video 1) and eye contact termination when the car came to a stop (Videos 2 and 9).
clear hh
figure;hold on;grid on;box on

xlabel('Time (s)')
ylabel('Percentage of trials with response key pressed')
rectangle('position',[-1 -100 2 300],'facecolor',[127 127 127 20]/255,'Linewidth',.5);
plot([video_info(11,2) video_info(11,2)],[-100 100],'k-')
text((video_info(11,2)+1)/2,58,'Approaching at 15 km/h','horizontalalignment','center')
plot([17.64 17.64],[-100 100],'k-')
text(15.62,58,'Braking','horizontalalignment','center')
plot([22.92 22.92],[-100 100],'k-')
text(20.26,58,'Standing still','horizontalalignment','center')
plot([26.52 26.52],[-100 100],'k-')
text(24.72,58,'Driving off','horizontalalignment','center')
text(28.76,58,'Out of sight','horizontalalignment','center')
v1=1;
v2=2;
v3=9;
V1 = 100 * squeeze(nanmean(nanmean(key_pressesf(:,v1,:),2),1));
V2 = 100 * squeeze(nanmean(nanmean(key_pressesf(:,v2,:),2),1));
V3 = 100 * squeeze(nanmean(nanmean(key_pressesf(:,v3,:),2),1));
hh(2)=plot(time,V2,'color',colors(v2,:),'Linewidth',2);
hh(3)=plot(time,V3,'color',colors(v3,:),'Linewidth',2);
IV=find(time>=video_info(v1,2) & time<=video_info(v1,4)+0.1);plot(time(IV),V1(IV),'color',colors(v1,:),'Linewidth',6);
IV=find(time>=video_info(v2,2) & time<=video_info(v2,4)+0.1);plot(time(IV),V2(IV),'color',colors(v2,:),'Linewidth',6);
IV=find(time>=video_info(v3,2) & time<=video_info(v3,4)+0.1);plot(time(IV),V3(IV),'color',colors(v3,:),'Linewidth',6);
hh(1)=plot(time,V1,'color',colors(v1,:),'Linewidth',2);

[~,p]=ttest(squeeze(key_pressesf(:,v1,:)),squeeze(key_pressesf(:,v2,:)));
plot(time(p<0.001),2,'*','color',colors(v2,:))
[~,p]=ttest(squeeze(key_pressesf(:,v1,:)),squeeze(key_pressesf(:,v3,:)));
plot(time(p<0.001),1,'*','color',colors(v3,:))

set(gca,'LooseInset',[0.01 0.01 0.01 0.01],'xlim',[0 30.9],'xtick',1:2:32,'ylim',[0 60],'ytick',0:5:100,'ticklength',[0.005 0.005])
l=legend(hh,'1. Yielding: No eye contact','2. Yielding: First visible-Full stop','9. Braking start-Full stop','autoupdate','off','location','southwest');
h=findobj('FontName','Helvetica'); set(h,'FontSize',20,'Fontname','Arial')
set(l,'position',[0.08 0.532364139840775 0.247395826751987 0.0690550344260187])
if savepng==1;set(gcf,'WindowState', 'maximized');print(gcf,'Figure5.png','-dpng','-r300');end
%% Figure 6. Percentage of trials in which the response key was pressed for driver’s eye contact throughout (Video 6) and eye contact termination when the car took off (Video 3).
clear hh
figure;hold on;grid on;box on

xlabel('Time (s)')
ylabel('Percentage of trials with response key pressed')
rectangle('position',[-1 -100 2 300],'facecolor',[127 127 127 20]/255,'Linewidth',.5);
plot([video_info(11,2) video_info(11,2)],[-100 100],'k-')
text((video_info(11,2)+1)/2,58,'Approaching at 15 km/h','horizontalalignment','center')
plot([17.64 17.64],[-100 100],'k-')
text(15.62,58,'Braking','horizontalalignment','center')
plot([22.92 22.92],[-100 100],'k-')
text(20.26,58,'Standing still','horizontalalignment','center')
plot([26.52 26.52],[-100 100],'k-')
text(24.72,58,'Driving off','horizontalalignment','center')
text(28.76,58,'Out of sight','horizontalalignment','center')
v1=6;
v2=3;

V1 = 100 * squeeze(nanmean(nanmean(key_pressesf(:,v1,:),2),1));
V2 = 100 * squeeze(nanmean(nanmean(key_pressesf(:,v2,:),2),1));

hh(1)=plot(time,V1,'color',colors(v1,:),'Linewidth',2);
IV=find(time>=video_info(v1,2) & time<=video_info(v1,4)+0.1);plot(time(IV),V1(IV),'color',colors(v1,:),'Linewidth',6);
IV=find(time>=video_info(v2,2) & time<=video_info(v2,4)+0.1);plot(time(IV),V2(IV),'color',colors(v2,:),'Linewidth',6);
hh(2)=plot(time,V2,'color',colors(v2,:),'Linewidth',2);

[~,p]=ttest(squeeze(key_pressesf(:,v1,:)),squeeze(key_pressesf(:,v2,:)));
plot(time(p<0.001),2,'*','color',[0 0 0])

set(gca,'LooseInset',[0.01 0.01 0.01 0.01],'xlim',[0 30.9],'xtick',1:2:32,'ylim',[0 60],'ytick',0:5:100,'ticklength',[0.005 0.005])
l=legend(hh,'6. Yielding: First visible-Out of sight','3. Yielding: First visible-Take-off','autoupdate','off','location','southwest');
h=findobj('FontName','Helvetica'); set(h,'FontSize',20,'Fontname','Arial')
set(l,'position',[0.08 0.532364139840775 0.247395826751987 0.0690550344260187])
if savepng==1;set(gcf,'WindowState', 'maximized');print(gcf,'Figure6.png','-dpng','-r300');end
%% Figure S1
figure;hold on;grid on;box on

xlabel('Time (s)')
ylabel('Percentage of trials with response key pressed')
rectangle('position',[-1 -100 2 300],'facecolor',[127 127 127 20]/255,'Linewidth',.5);
plot([video_info(11,2) video_info(11,2)],[-100 100],'k-')
text((video_info(11,2)+1)/2,58,'Approaching at 15 km/h','horizontalalignment','center')
plot([17.64 17.64],[-100 100],'k-')
text(15.62,58,'Braking','horizontalalignment','center')
plot([22.92 22.92],[-100 100],'k-')
text(20.26,58,'Standing still','horizontalalignment','center')
plot([26.52 26.52],[-100 100],'k-')
text(24.72,58,'Driving off','horizontalalignment','center')
text(28.76,58,'Out of sight','horizontalalignment','center')

hh=NaN(11,1);
for video=2:11 % eye contact (thick lines)
    V = 100 * squeeze(nanmean(nanmean(key_pressesf(:,video,:),2),1));
    IV=find(time>=video_info(video,2) & time<=video_info(video,4)+0.1);
    hh(video)=plot(time(IV),V(IV),'color',colors(video,:),'Linewidth',6);
end
for video=2:11 % no eye contact (thin lines)
    V = 100 * squeeze(nanmean(nanmean(key_pressesf(:,video,:),2),1));
    IV=find(time<=video_info(video,2)+0.1);
    plot(time(IV),V(IV),'color',colors(video,:),'Linewidth',2);
    IV=find(time>=video_info(video,4));
    plot(time(IV),V(IV),'color',colors(video,:),'Linewidth',2);
end
l=legend(hh(2:11),'2. First visible–Full stop','3. First visible–Take-off','4. Full stop–Take-off','5. Take off–Out of sight','6. First visible–Out of sight',...
    '7. Full stop–Out of sight','8. First visible–Braking start','9. Braking start–Full stop','10. Braking start–Take-off','11. Braking start–Out of sight');
set(l,'position',[0.0493055555555555 0.532364139840775 0.247395826751987 0.0690550344260187])

xlabel('Time (s)')
ylabel('Percentage of trials with response key pressed')
set(gca,'LooseInset',[0.01 0.01 0.01 0.01],'xlim',[0 30.9],'xtick',1:2:32,'ylim',[0 60],'ytick',0:5:100,'ticklength',[0.005 0.005])
h=findobj('FontName','Helvetica'); set(h,'FontSize',20,'Fontname','Arial')
set(l,'position',[0.08         0.286258224675134         0.206770827962707         0.330737269741724])
if savepng==1;set(gcf,'WindowState', 'maximized');print(gcf,'FigureS1.png','-dpng','-r300');end
%% Figure 7. Self-reported intuitiveness of eye contact versus self-reported occurrence of eye contact (left), and self-reported intuitiveness of eye contact versus performance score (right).

disp('Did the driver make eye contact with you? Percentages ''yes'' for the 13 videos, % keypresses when the car came to a stop:')
disp([transpose(1:13) round(100*nanmean(Q1)') round(100*nanmean(key_pressesf(:,:,find(time<17.66,1,'last')),1)',1)])

% paired t-tests of intuitiveness ratings. Perform a paired-samples t-test between all pairs of 13 videos
p=NaN(13,13);
for i=1:13
    for i2=1:13
        if i2<i
            [~,p(i,i2)]=ttest(Q2(:,i),Q2(:,i2)); % store the p-value in the matrix p (13 x 13 matrix)
        end
    end
end
disp(['Number of paired comparisons of intuitiveness ratings = ' num2str(sum(sum(p>=0)))])
disp('Non-significant pairs:')
[a,b]=find(p>0.005);disp([b a])

figure;hold on;grid on;box on
subplot(1,2,1)
for i=1:13
    scatter1=scatter(100*nanmean(Q1(:,i)),nanmean(1+Q2(:,i)),700,'markerfacecolor',colors(i,:),'markeredgecolor',colors(i,:));hold on;grid on
    scatter1.MarkerFaceAlpha = .3;
    text(100*nanmean(Q1(:,i)),nanmean(1+Q2(:,i)),num2str(i),'horizontalalignment','center')
end
set(gca,'pos',[0.05 0.09 0.42 0.89],'ylim',[2.5 4.3])
xlabel('Did the driver make eye contact with you? (%)')
ylabel('The driver''s eye contact was intuitive (1–5)')
h=findobj('FontName','Helvetica');set(h,'FontSize',20,'Fontname','Arial')

performance_score = nanmean(key_pressesf(:,1:11,time>=video_info(11,2) & time<=video_info(1,7)),3); % 13.6-22.9
performance_score2 = 1-nanmean(key_pressesf(:,1:11,time>video_info(1,7) & time<=video_info(1,8)),3);  % 22.9-26.5
performance_score = (performance_score+performance_score2)/2;

subplot(1,2,2)
for i=1:11
    scatter1=scatter(100*nanmean(performance_score(:,i)),nanmean(1+Q2(:,i)),700,'markerfacecolor',colors(i,:),'markeredgecolor',colors(i,:));hold on;grid on
    scatter1.MarkerFaceAlpha = .4;
    text(100*nanmean(performance_score(:,i)),nanmean(1+Q2(:,i)),num2str(i),'horizontalalignment','center')
end
set(gca,'pos',[0.57 0.09 0.42 0.89],'ylim',[2.5 4.3],'xlim',[59 66])
xlabel('Performance score (%)')
ylabel('The driver''s eye contact was intuitive (1–5)')
h=findobj('FontName','Helvetica');set(h,'FontSize',20,'Fontname','Arial')
if savepng==1;set(gcf,'WindowState', 'maximized');print(gcf,'Figure7.png','-dpng','-r300');end
%% Figure 8. Percentage of trials in which the response key was pressed for different self-reported concentration levels.
figure;hold on;box on
rectangle('position',[-1 -100 2 300],'facecolor',[127 127 127 20]/255,'Linewidth',.5);
plot([video_info(11,2) video_info(11,2)],[-100 100],'k-')
text((video_info(11,2)+1)/2,58,'Approaching at 15 km/h','horizontalalignment','center')
plot([17.64 17.64],[-100 100],'k-')
text(15.62,58,'Braking','horizontalalignment','center')
plot([22.92 22.92],[-100 100],'k-')
text(20.26,58,'Standing still','horizontalalignment','center')
plot([26.52 26.52],[-100 100],'k-')
text(24.72,58,'Driving off','horizontalalignment','center')
text(28.76,58,'Out of sight','horizontalalignment','center')
h=findobj('FontName','Helvetica'); set(h,'FontSize',20,'Fontname','Arial')
V=100 * squeeze(nanmean(key_pressesf(:,1:11,:),2));
[hh,LL,MM]=deal(NaN(1,5));
for i=0:4
    temp=find(Postexperimentresponses(:,3)==i); % Concentration
    hh(i+1)=plot(time,nanmean(V(temp,:)),'color',[i*0 i*63.75 i*63.75]/255,'Linewidth',5);
    LL(i+1)=length(temp);
    MM(i+1)=mean(nanmean(V(temp,time<=video_info(1,8)))); % overall mean for concentration level
end
l=legend(hh,['Completely disagree (\itn = \rm' num2str(LL(1)) ')'],...
    ['Disagree (\itn = \rm' num2str(LL(2)) ')'],...
    ['Neither disagree not agree (\itn = \rm' num2str(LL(3)) ')'],...
    ['Agree (\itn = \rm' num2str(LL(4)) ')'],...
    ['Completely agree (\itn = \rm' num2str(LL(5)) ')']);
set(l,'Position',[0.783131937149285 0.724125999486665 0.175520828894029 0.151609549146079])
xlabel('Time (s)')
ylabel('Percentage of trials with response key pressed')
set(gca,'LooseInset',[0.01 0.01 0.01 0.01],'xlim',[0 30.9],'xtick',1:2:32,'ylim',[0 60],'ytick',0:5:100,'ticklength',[0.005 0.005])
h=findobj('FontName','Helvetica'); set(h,'FontSize',20,'Fontname','Arial')
if savepng==1;set(gcf,'WindowState', 'maximized');print(gcf,'Figure8.png','-dpng','-r300');end

disp('Mean keypress percentages from 0 to 26.5 s for Concentration levels 1-5')
disp(round(MM,1))
%% Compute correlation matrix
XMP=[nanmean(performance_score,2) X(:,1:29) nanmean(V,2) nanmean(RP1,2) nanmean(RP2,2) nanmean(RP3_Correct,2) Postexperimentresponses];
[c,p]=corr(XMP,'rows','pairwise');disp([ transpose(0:size(c,1)-1) c(:,1) p(:,1)]);
% Last three variables are the post-experiment questionnaire: importance, preference, concentration
%% Figure 9. Mean self-reported intuitiveness of eye contact per video for participants from the United States and Venezuela (left), and mean performance score per video for participants from the United States and Venezuela (right).
figure;hold on;grid on;box on
subplot(1,2,1)
plot([0 10],[0 10],'k:');hold on
for i=1:13
    scatter1=scatter(1+nanmean(Q2(strcmp(Country,'VEN'),i)),1+nanmean(Q2(strcmp(Country,'USA'),i)),700,'markerfacecolor',colors(i,:),'markeredgecolor',colors(i,:));hold on;grid on
    scatter1.MarkerFaceAlpha = .3;
    text(1+nanmean(Q2(strcmp(Country,'VEN'),i)),1+nanmean(Q2(strcmp(Country,'USA'),i)),num2str(i),'horizontalalignment','center')
end
set(gca,'pos',[0.05 0.09 0.42 0.89],'xlim',[2.5 4.3],'ylim',[2.5 4.3])
xlabel('The driver''s eye contact was intuitive (1–5) (VEN)')
ylabel('The driver''s eye contact was intuitive (1–5) (USA)')
h=findobj('FontName','Helvetica');set(h,'FontSize',20,'Fontname','Arial')

PerformanceVEN=100*nanmean(performance_score(strcmp(Country,'VEN'),:))';
PerformanceUSA=100*nanmean(performance_score(strcmp(Country,'USA'),:))';

subplot(1,2,2)
plot([0 100],[0 100],'k:');hold on
for i=1:11
    scatter1=scatter(PerformanceVEN(i),PerformanceUSA(i),700,'markerfacecolor',colors(i,:),'markeredgecolor',colors(i,:));hold on;grid on
    scatter1.MarkerFaceAlpha = .3;
    text(PerformanceVEN(i),PerformanceUSA(i),num2str(i),'horizontalalignment','center')
end
set(gca,'pos',[0.57 0.09 0.42 0.89],'xlim',[60 66],'ylim',[60 66])
xlabel('Performance score (%) (VEN)')
ylabel('Performance score (%) (USA)')
h=findobj('FontName','Helvetica');set(h,'FontSize',20,'Fontname','Arial')
if savepng==1;set(gcf,'WindowState', 'maximized');print(gcf,'Figure9.png','-dpng','-r300');end
%% Table 2 and Figure S2
CM=NaN(18,13); % 12 measures (3 measures * 5 countries + 2 overall) x 11 videos with a yielding car
CountryAverages=NaN(length(I),size(key_pressesf,3));
for i=1:length(I) % loop over most common countries
    participants_from_country=find(strcmp(Country,country_unique(I(i))));
    CM(i+1,:)=1+nanmean(Q2(participants_from_country,:))'; % Mean intuitiveness for participants from country
    CM(i+2+length(I),1:11)=100*nanmean(performance_score(participants_from_country,:))'; % Mean performance score for participants from country
    CM(i+3+2*length(I),1:11)=mean(100*nanmean(key_pressesf(participants_from_country,1:11,time<=video_info(1,8))),3); % Mean keypress percentages for participants from country
    CountryAverages(i,:)=100*squeeze(nanmean(nanmean(key_pressesf(participants_from_country,1:11,:),2),1));
end
CM(1,:)=1+nanmean(Q2)'; % mean of all participants
CM(7,1:11)=100*nanmean(performance_score)'; % mean of all participants
disp([round(nanmean(CM(1:12,:),2),2) round(nanstd(CM(1:12,:),[],2),2) round(corr(CM(1:12,:)','rows','pairwise'),3)])

figure;hold on;grid on;box on
xlabel('Time (s)')
ylabel('Percentage of trials with response key pressed')
rectangle('position',[-1 -100 2 300],'facecolor',[127 127 127 20]/255,'Linewidth',.5);
plot([video_info(11,2) video_info(11,2)],[-100 100],'k-')
text((video_info(11,2)+1)/2,72,'Approaching at 15 km/h','horizontalalignment','center')
plot([17.64 17.64],[-100 100],'k-')
text(15.62,72,'Braking','horizontalalignment','center')
plot([22.92 22.92],[-100 100],'k-')
text(20.26,72,'Standing still','horizontalalignment','center')
plot([26.52 26.52],[-100 100],'k-')
text(24.72,72,'Driving off','horizontalalignment','center')
text(28.76,72,'Out of sight','horizontalalignment','center')

hh=NaN(5,1);cmap = colormap(hsv(5));
for i=1:5
    hh(i)=plot(time,CountryAverages(i,:),'color',cmap(i,:),'Linewidth',4);
end

set(gca,'LooseInset',[0.01 0.01 0.01 0.01],'xlim',[0 30.9],'xtick',1:2:32,'ylim',[0 75],'ytick',0:5:100,'ticklength',[0.005 0.005])
legend(hh,'Venezuela','United States','Russia','India','Egypt','autoupdate','off','location','southwest');
h=findobj('FontName','Helvetica'); set(h,'FontSize',20,'Fontname','Arial')
disp('Mean keypress percentages from 0 to 26.5 s for the five most represented countries')
disp(round(nanmean(CM(14:end,:),2),3))
if savepng==1;set(gcf,'WindowState', 'maximized');print(gcf,'FigureS2.png','-dpng','-r300');end
%% Figure S3
load distance % distance to predestrian per time stamp (1.02, 1.04, 1.06, ... 31.00 s).
time = (0.05:0.1:size(key_pressesf,3)/10)'; % time vector
distance=interp1(1.02:0.02:31,distance,time);
opengl hardware
figure;hold on;grid on;box on

xlabel('Vehicle-pedestrian distance (m)')
ylabel('Percentage of trials with response key pressed')
plot([-19.8 -19.8],[-100 100],'k-') % starting to brake (distance(136)= -19.95 m; distance(137) = -19.59 m)
text(-45,58,'Approaching at 15 km/h','horizontalalignment','center')
text((-19.6-13.7)/2,58,'Braking','horizontalalignment','center')
plot([-13.7 -13.7],[-100 100],'k-') % coming to a stop (distance(177) = -13.7 m)
plot([-8 -8],[-100 100],'k-') % out of sight (distance(267) = -8.0 m)
text((-13.7-8)/2,58,'Driving off','horizontalalignment','center')
text(0,58,'Out of sight','horizontalalignment','center')
v1=[1 4 5 7];
v2=[2 3 6 8];
v3=[9 10 11];
V1 = 100 * squeeze(nanmean(nanmean(key_pressesf(:,v1,:),2),1));
V2 = 100 * squeeze(nanmean(nanmean(key_pressesf(:,v2,:),2),1));
V3 = 100 * squeeze(nanmean(nanmean(key_pressesf(:,v3,:),2),1));
clear hh
hh(1)=plot(distance,V1,'color',colors(1,:),'Linewidth',2);
hh(2)=plot(distance,V2,'color',colors(2,:),'Linewidth',2);
hh(3)=plot(distance,V3,'color',colors(11,:),'Linewidth',2);

set(gca,'LooseInset',[0.01 0.01 0.01 0.01],'xlim',[-66 8],'xtick',-65:5:5,'ylim',[0 60],'ytick',0:5:100,'ticklength',[0.005 0.005])
legend(hh,'1, 4, 5, 7. Yielding: No eye contact from start',...
          '2, 3, 6, 8. Yielding: Eye contact from start',...
          '9, 10, 11. Yielding: Eye contact from braking moment',...
          'autoupdate','off','location','southwest');
h=findobj('FontName','Helvetica'); set(h,'FontSize',20,'Fontname','Arial')
xticklabel=str2double(get(gca,'xticklabel'));
set(gca,'xticklabel',xticklabel)
if savepng==1;set(gcf,'WindowState', 'maximized');print(gcf,'FigureS3.png','-dpng','-r300');end
%% Figure for presentation; not used for paper
figure;hold on;grid on;box on
xlabel('Time (s)')
ylabel('Percentage of trials with response key pressed')
rectangle('position',[-1 -100 2 300],'facecolor',[127 127 127 20]/255,'Linewidth',.5);
plot([video_info(11,2) video_info(11,2)],[-100 100],'k-')
text((video_info(11,2)+1)/2,58,'Approaching at 15 km/h','horizontalalignment','center')
plot([17.64 17.64],[-100 100],'k-')
text(15.62,58,'Braking','horizontalalignment','center')
plot([22.92 22.92],[-100 100],'k-')
text(20.26,58,'Standing still','horizontalalignment','center')
plot([26.52 26.52],[-100 100],'k-')
text(24.72,58,'Driving off','horizontalalignment','center')
text(28.76,58,'Out of sight','horizontalalignment','center')
v1=1;
v3=10;
V1 = 100 * squeeze(nanmean(nanmean(key_pressesf(:,v1,:),2),1));
V3 = 100 * squeeze(nanmean(nanmean(key_pressesf(:,v3,:),2),1));
clear hh
hh(1)=plot(time,V1,'color','k','Linewidth',2);
IV=find(time>=video_info(v1,2) & time<=video_info(v1,4)+0.1);
plot(time(IV),V1(IV),'color','k','Linewidth',6);
hh(2)=plot(time,V3,'color',[137 209 254]/255,'Linewidth',2);
IV=find(time>=video_info(v3,2) & time<=video_info(v3,4)+0.1);
plot(time(IV),V3(IV),'-','color',[137 209 254]/255,'Linewidth',6);
set(gca,'LooseInset',[0.01 0.01 0.01 0.01],'xlim',[0 30.9],'xtick',1:2:32,'ylim',[0 60],'ytick',0:5:100,'ticklength',[0.005 0.005])
l=legend(hh,'No eye contact','Eye contact from braking start to driving off','autoupdate','off','location','southwest');
h=findobj('FontName','Helvetica'); set(h,'FontSize',20,'Fontname','Arial')
set(l,'position',[0.0493055555555555 0.532364139840775 0.247395826751987 0.0690550344260187])
