# -*- coding: utf-8 -*-
"""
Created on Thu Mar 28 15:51:59 2019

@author: youweiwang
"""
from osgeo import ogr
from osgeo import gdal
import numpy as np
import os
import shutil
import matplotlib.pyplot as plt
import matplotlib.cm as cm
import ipywidgets as widgets
from ipywidgets import interact
from matplotlib import gridspec
from numpy import *
from ipywidgets import IntSlider
from ipywidgets import HBox
from mpl_toolkits.axes_grid1 import make_axes_locatable


folder = '20%_pi'


ini_1 = []
ini_2 = []
ini_3 = []
ini_4 = []

term_1 = []
term_2 = []
term_3 = []
term_4 = []

for subfolder in [1,3,4,5,6,7,12,13,14,15]:
    file_location = r'P:\paper_revision\avulsion timing\excel/' + folder + '/' + folder + '_' + str(subfolder) + '.xlsx'
    x_1 = [xlrd.open_workbook(file_location).sheet_by_index(0).cell_value(i, 0) for i in range(0,4)] #frequency
    x_2 = [xlrd.open_workbook(file_location).sheet_by_index(0).cell_value(i, 1) for i in range(0,4)] #frequency
    print (x_1)
    ini_1.append(x_1[0])
    ini_2.append(x_1[1])
    ini_3.append(x_1[2])
    ini_4.append(x_1[3])
    term_1.append(x_2[0])
    term_2.append(x_2[1])
    term_3.append(x_2[2])
    term_4.append(x_2[3])
    
    
print('hello')
print(ini_1)
print(ini_2)
print(ini_3)
print(ini_4)
print(term_1)
print(term_2)
print(term_3)
print(term_4)
    
ini_1 = np.array(np.array(ini_1)/2)
ini_2 = np.array(np.array(ini_2)/2-10)
ini_3 = np.array(np.array(ini_3)/2-20)
ini_4 = np.array(np.array(ini_4)/2-30)
print('hello')
print(ini_1)

#
#
term_1 = np.array(np.array(term_1)/2)
term_2 = np.array(np.array(term_2)/2 -10)
term_3 = np.array(np.array(term_3)/2 -20)
term_4 = np.array(np.array(term_4)/2 -30)
    

fig = plt.figure(figsize=(8,12))

ax1 = plt.subplot(211)
  
x = np.arange(0,12,0.01)
plt.plot(x,-1.8*np.sin(2*np.pi/10*x)+2.5)
print(ini_1)

#plt.text(np.mean(ini_1),1,'.2f%'%(np.mean(ini_1)),fontsize=20)

plt.axvline(2.5,linestyle='--',color='b',linewidth=2,zorder=0)
plt.axvline(7.5,linestyle='--',color='r',linewidth=2,zorder=0)
plt.xlim(0,12);plt.xticks((0,2.5,5,7.5,10), ('0', '2.5', '5','7.5','10'), rotation=0,fontsize=15)
plt.text(0.5, 3.5, 'n = %d'%len(term_1),fontsize=15)

    
box_plot_data_1 = [ini_1,ini_2,ini_3,ini_4]
box=plt.boxplot(box_plot_data_1,vert=0,patch_artist=True,labels=['Cycle 1','Cycle 2','Cycle 3','Cycle 4'],)
box_plot_data_2 = [term_1,term_2,term_3,term_4]
box=plt.boxplot(box_plot_data_2,vert=0,patch_artist=True,labels=['Cycle 1','Cycle 2','Cycle 3','Cycle 4'],)
ax1.yaxis.set_tick_params(labelsize=15)
ax1.set_xlabel('Time (kyr)',fontsize=20)

plt.text(2.5, 1.3,'%.1f±%.1f'%(np.mean(ini_1-2.5),np.std(ini_1-2.5)),fontsize=15)
plt.text(4, 2.3,'%.1f±%.1f'%(np.mean(ini_2-2.5),np.std(ini_2-2.5)),fontsize=15)
plt.text(4.5, 3.3,'%.1f±%.1f'%(np.mean(ini_3-2.5),np.std(ini_3-2.5)),fontsize=15)
plt.text(4.5, 4.3,'%.1f±%.1f'%(np.mean(ini_4-2.5),np.std(ini_4-2.5)),fontsize=15)
#plt.text(3.5, 4.3,'%.1f±%.1f, %.0f%%'%(np.mean(ini_4-2.5),np.std(ini_4-2.5),100*np.std(ini_4-2.5)/np.mean(ini_4-2.5)),fontsize=15)     


plt.text(7.8, 1.3,'%.1f±%.1f'%(np.mean(term_1-7.5),np.std(term_1-7.5)),fontsize=15)
plt.text(8.2, 2.3,'%.1f±%.1f'%(np.mean(term_2-7.5),np.std(term_2-7.5)),fontsize=15)
plt.text(8.1, 3.3,'%.1f±%.1f'%(np.mean(term_3-7.5),np.std(term_3-7.5)),fontsize=15)
plt.text(8, 4.3,'%.1f±%.1f'%(np.mean(term_4-7.5),np.std(term_4-7.5)),fontsize=15)
#plt.text(7.5, 4.3,'%.1f±%.1f'%(np.mean(term_4-7.5),np.std(term_4-7.5),100*np.std(term_4-7.5)/np.mean(term_4-7.5)),fontsize=15)
my_file= str(folder) + '_avulsion_ini_term'
my_path = r'P:/paper_revision/avulsion timing_1224/' 
os.makedirs(my_path, exist_ok=True)
fig.savefig(os.path.join(my_path,my_file+'_eps'),bbox_inches='tight',dpi=999,format='eps')
fig.savefig(os.path.join(my_path,my_file+'_2'),bbox_inches='tight',dpi=999)


#ax3.set_ylabel('elevation (m)',fontsize=20)

#colors = ['cyan', 'lightblue', 'lightgreen', 'tan']
#for patch, color in zip(box['boxes'], colors):
#    patch.set_facecolor(color)
 
plt.show()

fig = plt.figure(figsize=(8,12))
ax2 = plt.subplot(212)
dura_avul_1 = term_1 - ini_1
dura_avul_2 = term_2 - ini_2
dura_avul_3 = term_3 - ini_3
dura_avul_4 = term_4 - ini_4
plt.xlim(0,10);
box_plot_data_3 = [dura_avul_1,dura_avul_2,dura_avul_3,dura_avul_4]
box=plt.boxplot(box_plot_data_3,vert=0,patch_artist=True,labels=['Cycle 1','Cycle 2','Cycle 3','Cycle 4'],)
plt.text(0.5, 0.9, 'aggradation phase',fontsize=15)
plt.text(5.8, 0.9, 'non-deposition phase',fontsize=15)
plt.text(7.8, 3.9, 'n = 10',fontsize=15)

plt.xlim(0,10);plt.xticks((0,2,4,6,8,10), ('0', '20%', '40%','60%','80%','100%'), rotation=0,fontsize=15)
ax2.yaxis.set_tick_params(labelsize=15)
ax2.set_xlabel('relative duration of two phases',fontsize=20)


plt.text(4.5, 1.3,'%.0f%%±%.0f%%'%(10*np.mean(dura_avul_1),10*np.std(dura_avul_1)),fontsize=15)
plt.text(4.0, 2.3,'%.0f%%±%.0f%%'%(10*np.mean(dura_avul_2),10*np.std(dura_avul_2)),fontsize=15)
plt.text(3.5, 3.3,'%.0f%%±%.0f%%'%(10*np.mean(dura_avul_3),10*np.std(dura_avul_3)),fontsize=15)
plt.text(2.5, 4.3,'%.0f%%±%.0f%%'%(10*np.mean(dura_avul_4),10*np.std(dura_avul_4)),fontsize=15)
#plt.text(2.5, 4.3,'%.1f±%.1f, %.0f%%'%(10*np.mean(dura_avul_4),10*np.std(dura_avul_4),100*np.std(dura_avul_4)/np.mean(dura_avul_4)),fontsize=15)

my_file= str(folder) + '_avulsion timing'
my_path = r'P:/paper_revision/avulsion timing_1224/' 
os.makedirs(my_path, exist_ok=True)
fig.savefig(os.path.join(my_path,my_file+'_eps'),bbox_inches='tight',dpi=999,format='eps')
fig.savefig(os.path.join(my_path,my_file+'_2'),bbox_inches='tight',dpi=999)  
















