# -*- coding: utf-8 -*-
"""
Created on Fri Jun  7 21:14:15 2019

@author: youweiwang
"""
import numpy as np; import matplotlib.pyplot as plt
from osgeo import gdal; import os
from math import sqrt

folder = '10%_pi_syvitski'
subfolder = '1'
#directory = r'O:/00_0Qs/'+ folder + '/' + subfolder + '/1backup_EL00'
#directory = r'O:/00_0Qs/40%_useddata/4/1backup_EL00'
#directory = r'Q:/00_0Qs/0%/3/1backup_EL00'
directory =r'Q:\01_KBmodeloutput\06_02/3runs/1/1backup_EL/'

#directory = r'P:\01_KBmodeloutput\02_0_10k\1backup_EL'
#directory = r'Q:/0_0.55Qs_pi/20%_pi/1/1backup_EL00/'



#directory = r'Q:/0_0.55Qs_pi/10%/1/1backup_EL00/'


print(directory);os.chdir(directory)
z=[];end_map=800; hori_section=[]; hori_section_series=[]; time_series=np.ones((80,200)); #time_space_point=[]

x_section=100 #Line BB'

for i in range(1,801,2): 
    hori_section=gdal.Open('%s'%i+'.map').ReadAsArray()[x_section,:] + i*0
    hori_section_series.append(hori_section)   
 
x_list = np.arange(1,40000,100)  # space there are 40,000(cross valley distance)/200(grid size)=200 points
y_list = np.arange(1,800,2)  #time
   
x = np.arange(0,200)
       
for time in np.arange(399):       
        for space in x: # space range is always 0~200, representing 0~40 kyr            
            time_space_point=(hori_section_series[time+1][space]-hori_section_series[time][space])/100
            #print (time_space_point)
            z.append(time_space_point)
for time in np.arange(399,400):
    for space in x:
        time_space_point=0
        z.append(time_space_point)            

print(np.shape(z))
erosion=np.asarray(z).reshape(400,200)*1000    
a = erosion 

def mean_many(window): # this is to make a function of windows for depositional rate at a cross-valley distance of x
    a_new  = []
    a_mean = [] 
    for start in range(0, len(a)-window):
        a_temp = np.mean(a[start:start+window+1],axis=0)
        a_new.append(a_temp)
        
    a_new = np.asarray(a_new)
    return a_new

my_mean = {}  # to make a dictionary, with window as the keyword
my_sigma = []  
for window in range(0,len(a)):
    my_mean[window] = mean_many(window)
    my_sigma.append((np.array(my_mean[window])/0.4-1)**2) #0.4 is my long-term average deposition rate
#print(my_sigma)
my_sigma_mean = []
for i in range(len(my_sigma)):
    my_sigma_mean.append(my_sigma[i].mean(axis=1))        

fig = plt.figure(figsize=(12,8))
ax = plt.subplot(111)

for i in range(len(my_sigma_mean)):
      
#    plt.scatter(np.zeros(len(my_sigma_mean[i]))+i*100,np.sqrt(my_sigma_mean[i]*200),color = 'gray') # all dots
#    plt.scatter(i*100,np.mean(np.sqrt(my_sigma_mean[i]*200)),marker = 's', color = 'r', zorder = 2) # mean values
    plt.errorbar(i*100,np.mean(np.sqrt(my_sigma_mean[i]*200)),yerr=1*np.std(np.sqrt(my_sigma_mean[i]*200)),fmt='o',ecolor='k',color='red',elinewidth=2,capsize=4)
#    plt.plot(i*100,np.mean(np.sqrt(my_sigma_mean[i]*200))+1*np.std(np.sqrt(my_sigma_mean[i]*200)),'-o', color = 'cyan')
#    plt.plot(i*100,np.mean(np.sqrt(my_sigma_mean[i]*200))-1*np.std(np.sqrt(my_sigma_mean[i]*200)),'-o', color = 'cyan')
    
    
    ax.set_yscale('log'); ax.set_xscale('log')
    #plt.xticks([10,100],[100,1000])
    #plt.axvline(x=2000,linestyle='--',color = 'k',linewidth = 3)
#    plt.ylim(0.1,300); 
    plt.xlim(90,40000)
    plt.xticks(fontsize = 30); plt.yticks(fontsize = 30)
    plt.xlabel('time window (years)',fontsize = 30); plt.ylabel(r'$\sigma_{ss}$',fontsize = 30)
    
    #ax = extended(ax, [2000,30000],[np.mean(sqrt(my_sigma_mean[20]*200)),np.mean(sqrt(my_sigma_mean[300]*200))], color="r", lw=2, label="extended")
    # draw the kappa lines
#    plt.plot([2000,30000],[np.mean(np.sqrt(my_sigma_mean[20]*200)),np.mean(np.sqrt(my_sigma_mean[300]*200))],'--', color = 'k',linewidth = 3,zorder=3)
#    plt.plot([2000,200],[np.mean(np.sqrt(my_sigma_mean[20]*200)),np.mean(np.sqrt(my_sigma_mean[2]*200))],'--', color = 'k',linewidth = 3,zorder=3)

#my_file= folder + '_sub_' + subfolder +  '_2711'
my_file= '0%_2'
#my_file = '01_KBmodeloutput_02_0_10k_1_1backup_EL'
my_path =r'P:/autogenic compensation/'
#my_path = r'P:/paper_revision/compensational_error_bar/'         
os.makedirs(my_path, exist_ok=True)    
fig.savefig(os.path.join(my_path,my_file+'_eps'),bbox_inches='tight',dpi=499,format='eps')
fig.savefig(os.path.join(my_path,my_file+'_2'),bbox_inches='tight',dpi=499) 
    
