# -*- coding: utf-8 -*-
"""
Created on Fri Jun 14 16:07:30 2019

@author: youweiwang
"""


import xlrd
import numpy as np
import matplotlib.pyplot as plt
import os

def spectral_10ky(order,sheet_no):
    parent_folder = ['0','5','10','20','40',
                     125,250,500,20000,]
    theme_parent =  ['%','%','%','%','%',
                     'k','k','k','k',]
    folder = parent_folder[order]
    theme = theme_parent[order]
    subfolder = ['1','2','3','4','5','6',][0]

    #print(folder,subfolder)
    #os.chdir(r'O:/00_0Qs/'+ str(folder) + theme + '/' + subfolder + '/1backup_EL00/')
    
    

    #file_location = r'P:\paper_revision\depositional_rate_shortwavelength\excel_data\25/'+str(folder)+theme + '_'+subfolder+ '_'+str(oned_location) + '.xlsx'
    #file_location = r'O:/downstream-20%_pi.xlsx'
    #file_location = r'O:/100/1.xlsx'
    file_location = r'O:/constant water.xlsx'
    print(file_location)
    #file_location = r'C:\Users\youweiwang\Dropbox\03_model_paper_revision\spectral analysis/spectral_analysis_amplitude.xlsx'
    #file_location = r'C:\Users\youweiwang\Dropbox\to be submitted/Qs_180_white_noise.xlsx'
    workbook = xlrd.open_workbook(file_location)

    target = sheet_no # which sheet you are locating
    target_sheet = workbook.sheet_by_index(target)
    print(workbook.sheet_by_index(target))

    x_1 = [target_sheet.cell_value(i, 0)*10 for i in range(1,201)] #frequency
    y_1 = [target_sheet.cell_value(i, 1) for i in range(1,201)] #power
    y_2 = [target_sheet.cell_value(i, 2) for i in range(1,201)] # AR1
    y_3 = [target_sheet.cell_value(i, 4) for i in range(1,201)] # CHI2 90%
    y_4 = [target_sheet.cell_value(i, 5) for i in range(1,201)] # CHI2 95%
    y_5 = [target_sheet.cell_value(i, 6) for i in range(1,201)] # CHI2 99%
   

    fig = plt.figure(figsize=(6,5)) 
    #plt.xlim(0,300)  
    plt.xlim(0,1) 
    
    fz=20
    plt.ylim(0,30)
    #plt.ylim(0,int(np.max(y_1)/10)*10+20)
    #print(int(np.max(y_1)/10)*10+10)
#    plt.xticks((0,10,20,30,40), ('0', '10', '20','30','40'), rotation=0,fontsize=20)
    #plt.yticks(np.arange(0,int(np.max(y_1)/10)*10+10,int((int(np.max(y_1)/10)*10+10)/5)),  rotation=0,fontsize=20)
    plt.yticks([0,40,80],fontsize=fz)
    plt.xticks(fontsize=fz)
    
    #plt.xticks((0,100,200,300,), ('0', '10','20','30',), rotation=0,fontsize=20)
#    plt.xlabel('time (ky)',fontsize=20)
#    plt.ylabel('CV (%)',fontsize=20)
    
    marker_size = 70
    al = 0.7
    
    
    #plt.plot(x_1,y_1, marker = '^', label = 'power', c = 'k',alpha=al)
    plt.plot(x_1,y_1,  label = 'power', c = 'k') #power
    plt.plot(x_1,y_2, label = 'theoretical AR (1)', c = 'r') #AR1
    plt.plot(x_1,y_3,':', label = 'chi2 90%', c = 'b',)# CHI2 90%
    plt.plot(x_1,y_4, '-.',label = 'chi2 95%', c = 'b',)# CHI2 95%
    plt.plot(x_1,y_5, '--',label = 'chi2 99%', c = 'b',) # CHI2 99%
    #plt.scatter(x_3,y_3, marker='o',label = '20-kyr-wavelenth run',s = marker_size, c = 'b',alpha=al,zorder=4)
    
    #print(np.where(y_1 == np.amax(y_1)))
    peak = int(np.where(y_1 == np.amax(y_1))[0])
    print(peak)
    plt.axvline(x_1[peak],linestyle='--',color='k',linewidth=2,zorder=3)
    if order in np.arange(5):
        plt.axvline(0.1,linestyle='--',color='r',linewidth=2,zorder=3)
    else:
        plt.axvline(1000/folder,linestyle='--',color='r',linewidth=2,zorder=3)
#    plt.axhline(y=5,linestyle='--',color='k',linewidth=2,zorder=3)
#    plt.text(32, 10, 'CV <= 5%',fontsize=20)
    plt.legend(loc = 'upper right', fontsize = 15)
    
    plt.xlabel('frequency ($kyr^{-1}$)',fontsize=fz) 
    plt.ylabel('power',fontsize=fz)
    
    
    #my_file= str(folder) + theme + subfolder + '_' + str(x_section) + '_1D_' + str(oned_location)
    my_file= str(sheet_no)
    #my_path = r'O:/paper_revision/depositional_rate_shortwavelength/spectral'   
    my_path = r'O:/100/spectral'   
    
    os.makedirs(my_path, exist_ok=True)
    
    fig.savefig(os.path.join(my_path,my_file+'_eps'),bbox_inches='tight',dpi=999,format='eps')
    fig.savefig(os.path.join(my_path,my_file+'_2'),bbox_inches='tight',dpi=999)     

    
    # insert the zoomed figure
    # plt.setp(sub_axes)
    
    plt.show()

for i in np.arange (0,1):
    spectral_10ky(3,i)

    