# -*- coding: utf-8 -*-
"""
Created on Tue Mar 26 20:33:13 2019

@author: youweiwang
"""

from osgeo import gdal; import numpy as np; import os; import matplotlib.pyplot as plt


def base_level_location(folder,subfolder):
    interval = 10
    os.chdir(r'O:/00_0Qs/'+ folder + '/' + subfolder + '/1backup_EL00')
    fig = plt.figure(figsize=(12,8))
    for map_name in np.arange(10,790,interval):
        long_profile = gdal.Open(str(map_name) + '.map').ReadAsArray()[:,100]
        base_level = map_name*50*0.0004
        plt.plot(long_profile,'k')
        x_location = []    
        for x in np.arange(300):
            if long_profile[x] < base_level-0.00001:
                x_location.append(x)
    #            print(x)
    #            plt.axhline(base_level,x_location[0]/300,1,linestyle = '--',color='k')
                plt.plot([x_location[0]],[base_level],marker='o', markersize=6, color="red")
        
        
    plt.ylim(0,30); plt.xlim(0,300)    
    plt.yticks([0,10,20,30], rotation=0,fontsize=20)
    plt.xticks((0,100,200,300), ('0', '20', '40','60'), rotation=0,fontsize=20)
    plt.xlabel('down-valley distance (km)',fontsize=20)
    plt.ylabel('elevation (m)',fontsize=20)
    plt.axvline(250,linestyle = '--',color='k')
    plt.text(265,22,'Area 6',fontsize = '18')
        
    my_file= folder + '_sub_' + subfolder + '_interval_' + str(interval) +  '_2011'
    my_path = r'P:/paper_revision/base_level_location_continent/'         
    os.makedirs(my_path, exist_ok=True)
    
    fig.savefig(os.path.join(my_path,my_file+'_eps'),bbox_inches='tight',dpi=999,format='eps')
    fig.savefig(os.path.join(my_path,my_file+'_2'),bbox_inches='tight',dpi=999) 

for folder in ['0%','5%','10%','20%','40%','1250k','2500k','5000k','20000k','20%_pi_syvitski']:
    base_level_location(folder,'1')









