%% THIS EXAMPLE ONLY WORKS WITH QBLADE ENTERPRISE EDITION
% Two turbines simulation using QBlade DLL interface.

%%
clear all
close all 
clc

if libisloaded('QBladeDLL')
    unloadlibrary 'QBladeDLL'
end;

addpath('..\..\');

%this is setup using relative path and depends on the location of this file, if there are issues use absolute path to these files
loadlibrary('../../QBladeEE_2.0.5.2.dll','../QBladeDLLFunctions.h','alias','QBladeDLL') 

m = libfunctions('QBladeDLL') ;

if isempty(m)
    fprintf('Error')
end

%this is setup using relative path and depends on the location of this file, if there are issues use absolute path to these files
calllib('QBladeDLL','setLibraryPath','../../QBladeEE_2.0.5.2.dll')

calllib('QBladeDLL','createInstance',1,24)

%this is setup using relative path and depends on the location of this file, if there are issues use absolute path to these files
projectFile = '../../Source/NREL5MW_TwoTurbines.qpr';

calllib('QBladeDLL','loadProject',projectFile)
calllib('QBladeDLL','initializeSimulation') 

simTime = 1400; %in timestep, actual time is timestep*#timesteps
valuestr = 'Rotational Speed [rpm]';
valuestr2 = 'Gen. HSS Torque [Nm]';
% valuestr2 = 'Gen. Power (w.o. losses) [kW]';
f = waitbar(0,'Initializing Simulation') ;

K = 2.24;
N = 97;
for i = 1:1:simTime
    calllib('QBladeDLL','advanceTurbineSimulation')
    omega_WT1 = calllib('QBladeDLL','getCustomData_at_num',valuestr, 0, 0) ;
    genTorqueQB_WT1 = calllib('QBladeDLL','getCustomData_at_num',valuestr2, 0, 0) ;
    genTorqueQB_store_WT1(i,:) = genTorqueQB_WT1;

    omega_g_WT1 = omega_WT1*N;
    genTorque_WT1 = K.*(omega_g_WT1*(2*pi/60))^2;
    genTorque_store_WT1(i,:) = genTorque_WT1 ;
    V_hub_WT1(i,:) = calllib('QBladeDLL','getWindspeed', -20, 0, 87.6, [0 0 0]);

    calllib('QBladeDLL','setControlVars_at_num',[genTorque_WT1 0 0 0 0],0)
    
    omega_WT2 = calllib('QBladeDLL','getCustomData_at_num',valuestr, 0, 1) ;
    genTorqueQB_WT2 = calllib('QBladeDLL','getCustomData_at_num',valuestr2, 0, 1) ;
    genTorqueQB_store_WT2(i,:) = genTorqueQB_WT2;

    omega_g_WT2 = omega_WT2*N;
    genTorque_WT2 = K.*(omega_g_WT2*(2*pi/60))^2;
    genTorque_store_WT2(i,:) = genTorque_WT2 ;
    V_hub_WT2(i,:) = calllib('QBladeDLL','getWindspeed', 350, 0, 87.6, [0 0 0]);

    calllib('QBladeDLL','setControlVars_at_num',[genTorque_WT2 0 0 0 0],1)
    waitbar(i/simTime,f,'Simulation Running')
end
close(f)
% calllib('QBladeDLL','storeProject','Test.qpr')
calllib('QBladeDLL','closeInstance')

figure(1);
subplot(2,1,1)
plot(genTorqueQB_store_WT1,'LineWidth',1.5)
hold on
plot(genTorqueQB_store_WT2,'LineWidth',1.5)
grid on
legend('QB HSS Torque WT 1','QB HSS Torque WT 2','Location','southwest')
title('Generator Torque')

subplot(2,1,2)
plot(V_hub_WT1(:,1),'LineWidth',1.5)
hold on
plot(V_hub_WT2(:,1),'LineWidth',1.5)
grid on
legend('Wind Speed Turbine 1','Wind Speed Turbine 2','Location','southwest')
title('Wind speed')