function QBladeFunctionHelp(inputArg1)

% This function will list all library functions that can be called for 
% interfacing with the QBlade DLL. The following functions can be called.
% 1]: loadProject
% 2]: loadSimDefinition
% 3]: storeProject
% 4]: setDebugInfo
% 5]: createInstance
% 6]: closeInstance
% 7]: loadTurbulentWindBinary
% 8]: addTurbulentWind
% 9]: initializeSimulation
% 10]: setTimestepSize
% 11]: setRPMPrescribeType_at_num
% 12]: setRampupTime
% 13]: getWindspeed
% 14]: getCustomData_at_num
% 15]: setInitialConditions_at_num
% 16]: setTurbinePosition_at_num
% 17]: setPowerLawWind
% 18]: setControlVars_at_num
% 19]: getTurbineOperation_at_num
% 20]: advanceController_at_num
% 21]: advanceTurbineSimulation
% 22]: runFullSimulation
% 23]: setLibraryPath
% 24]: getTowerBottomLoads_at_num

% To get information on one of the individual functions call the function
% with the name of the library call functions as string.
%
% Example:
%   % Call information on the 'getCustomData_at_num' library function
% QBladeFunctionHelp('getCustomData_at_num')
%

if strcmp('loadProject',inputArg1) == 1
     sprintf(['The loadProject library function is used to load a QBlade project \n' ...
     '(.qpr) into the created QBlade instance. loadProject takes the name \n' ...
     'of the project as string. \n' ...
     '\n' ...
     'Example: \n' ...
     ...
     'calllib(' '''<library alias>''' ',' '''loadProject''' ',' '''<projectname>.qpr''' ')'])
elseif strcmp('loadSimDefinition',inputArg1) == 1
     sprintf(['The loadSimDefinition library function is used to load a QBlade Simulation export \n' ...
     '(.sim) into the created QBlade instance. loadSimDefinition takes the name \n' ...
     'of the exported simulation as string. \n' ...
     '\n' ...
     'Example: \n' ...
     ...
     'calllib(' '''<library alias>''' ',' '''loadSimDefinition''' ',' '''<projectname>.sim''' ')'])
elseif strcmp('storeProject',inputArg1) == 1
    sprintf(['Allows to save the project after a simulation has been run. \n' ...
        'storeProject saves the completed simulation as .qpr file \n'...
        '\n'...
        'Example: \n'...
        'calllib(' '''<library alias>''' ',' '''storeProject''' ',' '''<savename>.qpr''' ')'])
elseif strcmp('setDebugInfo',inputArg1) == 1
    sprintf(['Enables the option to see debug information from QBlade.\n'...
            'Takes true or false as input. Unclear if it fully works in Matlab. \n'...
            '\n' ...
            'Example: \n'...
            'calllib(' '''<library alias>''' ',' '''setDebugInfo''' ',' '''true''' ')'])
elseif strcmp('createInstance',inputArg1) == 1
    sprintf(['Creates a new instance of QBlade for a selected device \n' ...
	        'and certain OpenCL parameters. First function to be called \n'...
            'after having connected to the dll library. \n' ...
            '\n'...
            'Example:\n'...
            'calllib(' '''<library alias>''' ',' '''createInstance''' ',' '0,24)'])
elseif strcmp('closeInstance',inputArg1) == 1
        sprintf(['Closes the current open instance of QBlade. Call this function to close \n'...
            'QBLade instance after having run a simulation. \n' ...
            'This is particulary important if looping over more than 1 simulation. \n' ...
            '\n'...
            'Example:\n'...
            'calllib(' '''<library alias>''' ',' '''closeInstance''' ')'])
elseif strcmp('loadTurbulentWindBinary',inputArg1) == 1
        sprintf(['Allows to open a turbulent wind field file in binary data. \n' ...
                'Such a file can be exported from QBlade.\n'...
                '\n'...
                'Example:\n'...
                'calllib(' '''<library alias>''' ',' '''loadTurbulentWindBinary''' ',' '''<windfieldname>.<extension>''' ')'])
elseif strcmp('addTurbulentWind',inputArg1) == 1
    sprintf(['This function can be used to create a turbulent wind field. \n'...
            'The function has the following inputs, entered into the function in the same order:\n'...
            'windspeed: the mean windspeed at the reference height [m/s]\n'...
            'refheight: the reference height [m]\n'...
            'hubheight: the hubheight, more specifically the height of the windfield center [m]\n'...
            'dimensions: the y- and z- dimensions of the windfield in meters [m]\n'...
            'gridpoints: the number of points in the y and z direction for which velocities are evaluated [-]\n'...
            'length: the simulated length of the windfield in seconds [s]\n'...
            'dT: the temporal resolution of the windfield [s]\n'...
            'turbulenceClass: the turbulence class, can be "A", "B" or "C"\n'...
            'turbulenceType: the turbulence type, can be "NTM", "ETM", "xEWM1" or "xEWM50" - where x is the turbine class (1,2 or 3)\n'...
            'seed: the random seed for the turbulent windfield\n'...
            'vertInf: vertical inflow angle in degrees [deg]\n'...
            'horInf: horizontal inflow angle in degrees [deg]])\n'...
            '\n'...
            'Example:\n'...
            'In this example we will create a turbulent wind field with turbulence class A and Type ETM.\n'...
            'The inflow speed is 14 m/s, at reference height of 89 meters (NREL5MW).\n'...
            'The windfield will be sized on a 50 by 50 grid, spanning 100 by 100 meters, centered at 89 meters.\n'...
            'The wind field will be simulated for 100 seconds, with time steps of 0.05s and finally \n'...
            'it will have no horizontal or vertical inflow angle (i.e. the wind is perpendicular to the rotor plane if the turbine is not moved).\n'...
            'The seed is chosen as a random integer, in this example we take 42: \n'...
            '\n'...
            'Function Call: \n'...
            'calllib(' '''<library alias>''' ',' '''addTurbulentWind''' ',14,89,89,[100 100],[50 50],100,0.05,' '''A''' ',' '''ETM''' ',42,0,0,[]'  ')'...
            '\n'...
            '\n'...
            'IMPORTANT! This function can not be used together with setPowerLawWind.'])
elseif strcmp('initializeSimulation',inputArg1) == 1
    sprintf(['Initiates the simulation. \n'...
	    '\n'...
        'Example:\n'...
        'calllib(' '''<library alias>''' ',' '''initializeSimulation'')'])
elseif strcmp('setTimestepSize',inputArg1) == 1
    sprintf(['Set the simulation step size in seconds [s]. Call this function before initializeSimulation!\n'...
        '\n'...
        'Set time step at 0.05 seconds example:\n'...
        'calllib(' '''<library alias>''' ',' '''setTimestepSize''' ',0.05'  ')'])
elseif strcmp('setRPMPrescribeType_at_num',inputArg1) == 1
    sprintf(['Sets the phase in which the RPM is prescribed to the turbine. Call this function before initializeSimulation! \n'...
        'If the RPM is prescribed no control over RPM is possible. There exist three options: \n'...
        'Prescribed during ramp-up only: 0\n'...
        'Prescribed during entire simulation: 1\n'...
        'No prescribed RPM :2\n'...
                'The first input is prescribed mode, the second input specifies the turbine.\n'...
        'The first turbine can be accessed by passing a 0, the second turbine by 1 etc.\n'...
        '\n'...
        'Example with prescribed RPM during ramp-up only:\n'...
         'calllib(' '''<library alias>''' ',' '''setRPMPrescribeType_at_num''' ', 0, 0'  ')'])
elseif strcmp('setRampupTime',inputArg1) == 1
        sprintf(['Set the simulation ramp up time in seconds [s]. Call this function before initializeSimulation!\n'...
        '\n'...
        'Set ramp up time to 15 seconds example:\n'...
        'calllib(' '''<library alias>''' ',' '''setRampupTime''' ', 15'  ')'])
elseif strcmp('getWindspeed',inputArg1) == 1
    sprintf(['Gets information of the wind speed [m/s] at a specified x-y-z location.\n'...
            'The fourth input to this function specifies the output vector, this is not used in Matlab.\n'...
            'Passing a 0 for that input was found to work to generate an output.\n'...
            'This output can be passed to any Matlab variable by setting it equal to the calllib.\n'...
            '\n'...
            'Example where we read the windspeed at the hub of the turbine (x,y,z --> 0,0,89) and pass it to a variable called V_hub:\n'...
            'V_hub = calllib(' '''<library alias>''' ',' '''getWindspeed''' ', 0, 0, 89, 0'  ')'])
elseif strcmp('getCustomData_at_num',inputArg1) == 1
    sprintf(['Gets information from any of the available data channels in QBlade for the current time step. \n'...
        'All data channels that can be found in the graph view are also available for reading.\n'...
        'The first input is the name of the channel as string, the second input specifies the normalized position along the blade,\n' ...
        'and the third input specifies the turbine.\n'...
        'The first turbine can be accessed by passing a 0, the second turbine by 1 etc.\n'...
        'This output can be passed to any Matlab variable by setting it equal to the calllib.\n'...
        '\n'...
        'In this example we will read the rotational speed of the turbine \n'...
        'and pass it to a Matlab variable called omega_r.\n'...
        '\n'...
        'Example:\n'...
        'omega_r = calllib(' '''<library alias>''' ',' '''getCustomData_at_num''' ',' '''Rotational Speed [rpm]''' ', 0.5' ', 0'  ')'])
elseif strcmp('setInitialConditions_at_num',inputArg1) == 1
    sprintf(['Sets the turbine initial conditions. If multiple turbines are present in the simulation\n'...
        'then the turbine to be set can be specific by passing 0,1,2,etc as final input to the library call.\n'...
        'The first turbine corresponds to passing a 0. If only 1 turbine is present, pass 0 as well.\n'...
        '\n'...
        'The following initial conditions can be set:\n'...
        'turbine initial yaw [deg]\n' ...
        'collective pitch [deg]\n' ...
        'azimuthal angle [deg]\n' ...
        'initial rotSpeed [rpm]\n'...
        'Call this function before initializeSimulation!\n'...
        '\n'...
        'In the following example we will set the first turbine with an initial rotor speed of 10 rpm\n'...
        ',5 degree initial yaw, 2 degree collective pitch and 0 degree azimuthal angle.\n'...
        '\n'...
        'Example:\n'...
        'calllib(' '''<library alias>''' ',' '''setInitialConditions_at_num''' ', 5, 2, 0, 10, 0'  ')'])
elseif strcmp('setTurbinePosition_at_num',inputArg1) == 1
    sprintf(['Sets the turbine position. If multiple turbines are present in the simulation\n'...
        'then the turbine to be set can be specific by passing 0,1,2,etc as final input to the library call.\n'...
        'The first turbine corresponds to passing a 0. If only 1 turbine is present, pass 0 as well.\n'...
        '\n'...
        'Turbine position is specified using x, y, z coordinates and rotation around those axes in degrees.\n' ...
        'In the following example we set our first turbine at (630,0,0) and pitch (rotation around y) is with 10 degrees\n' ...
        '\n'...
        'calllib(' '''<library alias>''' ',' '''setTurbinePosition_at_num''' ', 630, 0, 0, 0, 10, 0, 0'  ')'])
elseif strcmp('setPowerLawWind',inputArg1) == 1
    sprintf(['This function defines a power law wind profile and the inflow direction.\n'...
        'This function can be called after the simulation has been initialized and can be used to simulate a time varying wind field.\n'...
        'The function has the following inputs:\n'...
        'windspeed: constant windspeed in m/s [m/s]\n'...
        'horAngle: the horizontal inflow angle in degrees [deg]\n'...
        'vertAngle: the vertical inflow angle in degrees [deg]\n'...
        'shearExponent: set to 0 if windspeed is constant with height [-]\n'...
        'referenceHeight: [m]])\n'...
        '\n'...
        'In the following example we will set a normal wind shear profile with a wind speed of 10 m/s, \n'...
        '0 degree horizantal inflow direction, 5 degree vertical inflow direction, shear of 1/7 and \n'...
        'reference height of 89 metres\n'...
        '\n'...
        'Example:\n'...
        'calllib(' '''<library alias>''' ',' '''setPowerLawWind''' ', 10, 0, 5, 1/7, 89'  ')'])
elseif strcmp('setControlVars_at_num',inputArg1) == 1
    sprintf(['Sets controller variables of the selected turbine. If multiple turbines are present in the simulation\n'...
        'then the turbine to be set can be specific by passing 0,1,2,etc as final input to the library call.\n'...
        'The first turbine corresponds to passing a 0. If only 1 turbine is present, pass 0 as well.\n'...
        '\n'...
        'This function does not interact with any dll controller added to QBlade project.\n'...
        'If this function is called after advanceController and before advanceStructure it will override control inputs from the dll. \n'...
        'The following control parameters can be set directly:\n'...
        'generator torque [Nm]\n'...
        'yaw angle [deg]\n'...
        'pitch blade 1 [deg]\n'...
        'pitch blade 2 [deg]\n'...
        'pitch blade 3 [deg]\n'...
        '\n' ...
        'Since this will be an often used function a dedicated Matlab script can be found\n'...
        'in the same folder that has a working example of a kw^2 controller, implemented using this method.'...
        ' The example here will set the collective pitch of all blades to 1 deg\n'...
        '\n'...
        'Example:\n'...
        'calllib(' '''<library alias>''' ',' '''setControlVars_at_num''' ', 0, 0, 1, 1, 1, 0'  ')'])
elseif strcmp('getTurbineOperation_at_num',inputArg1) == 1
    sprintf(['This functions gives 40 different variables commonly used in turbine control.\n'...
        'Data is read for the specified turbine. If multiple turbines are present in the simulation\n'...
        'then the turbine to be set can be specific by passing 0,1,2,etc as final input to the library call.\n'...
        'The first turbine corresponds to passing a 0. If only 1 turbine is present, pass 0 as well.\n'...
    '[0] = rotational speed [rad/s]\n'...
    '[1] = power [W]\n'...
    '[2] = HH wind velocity [m/s]\n'...
    '[3] = yaw angle [deg]\n'...
    '[4] = pitch blade 1 [deg]\n'...
    '[5] = pitch blade 2 [deg]\n'...
    '[6] = pitch blade 3 [deg]\n'...
    '[7] = oop blade root bending moment blade 1 [Nm]\n'...
    '[8] = oop blade root bending moment blade 2 [Nm]\n'...
    '[9] = oop blade root bending moment blade 3 [Nm]\n'...
    '[10] = ip blade root bending moment blade 1 [Nm]\n'...
    '[11] = ip blade root bending moment blade 2 [Nm]\n'...
    '[12] = ip blade root bending moment blade 3 [Nm]\n'...
    '[13] = tor blade root bending moment blade 1 [Nm]\n'...
    '[14] = tor blade root bending moment blade 2 [Nm]\n'...
    '[15] = tor blade root bending moment blade 3 [Nm]\n'...
    '[16] = oop tip deflection blade 1 [m]\n'...
    '[17] = oop tip deflection blade 2 [m]\n'...
    '[18] = oop tip deflection blade 3 [m]\n'...
    '[19] = ip tip deflection blade 1 [m]\n'...
    '[20] = ip tip deflection blade 2 [m]\n'...
    '[21] = ip tip deflection blade 3 [m]\n'...
    '[22] = tower top acceleration in global X [m/s^2]\n'...
    '[23] = tower top acceleration in global Y [m/s^2]\n'...
    '[24] = tower top acceleration in global Z [m/s^2]\n'...
    '[25] = tower top fore aft acceleration [m/s^2]\n'...
    '[26] = tower top side side acceleration [m/s^2]\n'...
    '[27] = tower top X position [m]\n'...
    '[28] = tower top Y position [m]\n'...
    '[29] = tower bottom force along global X [Nm]\n'...
    '[30] = tower bottom force along global Y [Nm]\n'...
    '[31] = tower bottom force along global Z [Nm]\n'...
    '[32] = tower bottom bending moment along global X [Nm]\n'...
    '[33] = tower bottom bending moment along global Y [Nm]\n'...
    '[34] = tower bottom bending moment along global Z [Nm]\n'...
    '[35] = current time [s]\n'...
    '[36] = azimuthal position of the LSS [deg]\n'...
    '[37] = azimuthal position of the HSS [deg]\n'...
    '[38] = HSS torque [Nm]\n'...
    '[39] = wind speed at hub height [m/s]\n'...
    '[40] = horizontal inflow angle [deg]\n'...
    '\n'...
    'The following example will pass all variables to a Matlab variable called Turb_Out.\n'...
    '\n'...
    'Example:\n'...
    'Turb_Out = calllib(' '''<library alias>''' ',' '''getTurbineOperation_at_num''' ', ones(1,40), 0'  ')'])
elseif strcmp('advanceController_at_num',inputArg1) == 1
    sprintf(['Advances the controller dll of the selected turbine. If multiple turbines are present in the simulation\n'...
        'then the turbine to be set can be specific by passing 0,1,2,etc as final input to the library call.\n'...
        'The first turbine corresponds to passing a 0. If only 1 turbine is present, pass 0 as well.\n'...
        '\n'...
        'The following variables are written as output of the controller:\n' ...
        'generator torque [Nm]\n' ...
        'yaw angle [deg]\n' ...
        'pitch blade 1 [deg]\n' ...
        'pitch blade 2 [deg]\n' ...
        'pitch blade 3 [deg]\n' ...
        '\n' ...
        'This output can be passed to any Matlab variable by setting it equal to the calllib.\n'...
        '\n'...
        'In this example we will read the control inputs sent to the turbine \n'...
        'and pass it to a Matlab variable called control_out.\n'...
        '\n'...
        'Example:\n'...
        'control_out = calllib(' '''<library alias>''' ',' '''advanceController_at_num''' ', ones(1,5), 0'  ')'])
    elseif strcmp('advanceTurbineSimulation',inputArg1) == 1
    sprintf(['Advances both the aerodynamic as the structural time step by one \n'...
        '\n'...
        'Example:\n'...
        'calllib(' '''<library alias>''' ',' '''advanceTurbineSimulation'')'])
    elseif strcmp('runFullSimulation',inputArg1) == 1
    sprintf(['Runs the full simulations for the time specified in the .qpr or .sim file. \n'...
        'You cannot interact with the simulation (get_data for example) when using this option. \n' ...
        '\n'...
        'Example:\n'...
        'calllib(' '''<library alias>''' ',' '''runFullSimulation'')'])
    elseif strcmp('setLibraryPath',inputArg1) == 1
    sprintf(['MANDATORY FUNCTION! Sets the path to the dll location. \n'...
        'The path specified must be absolute for reading license!. \n' ...
        '\n'...
        'Example:\n'...
        'calllib(' '''<library alias>''' ',' '''setLibraryPath''' ',' '''<userpath>/QBladeEE_2.0.5.2/''' ')'])
    elseif strcmp('getTowerBottomLoads_at_num',inputArg1) == 1
    sprintf(['Outputs at the bottom of the tower loads of specified turbine. \n'...
        'If multiple turbines are present in the simulation \n'...
        'then the turbine to be set can be specific by passing 0,1,2,etc as final input to the library call.\n'...
        'The first turbine corresponds to passing a 0. If only 1 turbine is present, pass 0 as well.\n'...
        '\n'...
        'The following variables are written as output:\n' ...
        'Example:\n'...
        'Towerloads = calllib(' '''<library alias>''' ',' '''getTowerBottomLoads_at_num''' ',' '''loads''' ',' '0' ')'])
else
    error('No library function found. Check if punctuation is correct. For full list of callable functions type help QBladeFunctionHelp')

end

