%%
% Writing DISCON loop.

%%
clear all
close all 
clc

%% Define paths

%set the absolute path to your qblade directory here
UserPath = '<userpath>\QBladeCE_2.0.5.2\'; 
disconPath = [UserPath];
MatlabPath = [UserPath 'MATLAB_Files\4p4_DRC_Cases\4p42_IndividualPitchControl\'];
SourcePath = [UserPath 'Source'] ;
DllPath = [UserPath 'QBladeCE_2.0.5.2.dll'];
addpath('..\Functions');
addpath('..\..\..\');
%%

%this is setup using relative path and depends on the location of this file, if there are issues use absolute path to these files
loadlibrary(DllPath,'../../QBladeDLLFunctions.h','alias','QBladeDLL') 

m = libfunctions('QBladeDLL') ;

if isempty(m)
    fprintf('Error')
end

%% Defining Settings
Str = [0.25 0.5];

IPC = 0;
Pulse = 0/57.3;
Helix_CM2 = 4/57.3;
Helix_CM3 = 4/57.3;
Freq = Str*9/126*2*pi ;
Pitch_off = 0/57.3;
uservar7 = 0;
uservar8 = 0;
uservar9 = 0;
uservar10 = 0;

SimNr = length(Freq);
tic
for i_for1 = 1:1:SimNr

    Sim_name_folder = ['Sim_', num2str(i_for1)] ;
    
    copyfile([SourcePath],Sim_name_folder);

    cd(disconPath)

    writeDisconIPC(IPC,Pulse,Helix_CM2,Helix_CM3,Freq(i_for1),Pitch_off)
    cd(MatlabPath)
    
    run IPC_Simulation.m
    
    cd(Sim_name_folder)
    
    save(['Output_',num2str(i_for1)],'PitchAngles')
    
    cd('..\..\..\..\')
    %delete('discon.in');
    cd(MatlabPath)
end
%%
toc

figure;
plot(PitchAngles(:,1))
hold on
plot(PitchAngles(:,2))
plot(PitchAngles(:,3))
grid on
legend('Blade 1','Blade 2','Blade 3')
