simFile_loc = [MatlabPath Sim_name_folder '\'];

calllib('QBladeDLL','setLibraryPath',DllPath)
calllib('QBladeDLL','createInstance',1,24)
simName = 'NREL5MW_DIPC.sim';
calllib('QBladeDLL','loadSimDefinition',[simFile_loc simName])
calllib('QBladeDLL','initializeSimulation')

simTime = 1000; %in timestep, actual time is timestep*#timesteps
valuestr = 'Pitch Angle Blade 1 [deg]';
valuestr2 = 'Pitch Angle Blade 2 [deg]';
valuestr3 = 'Pitch Angle Blade 3 [deg]';

f = waitbar(0,'Initializing Simulation') ;

for i_for2 = 1:1:simTime

    calllib('QBladeDLL','advanceTurbineSimulation')
    calllib('QBladeDLL','advanceController_at_num',[0 0 0 0 0],0)
    
    Pitch1 = calllib('QBladeDLL','getCustomData_at_num',valuestr, 0, 0) ;
    Pitch2 = calllib('QBladeDLL','getCustomData_at_num',valuestr2, 0, 0); 
    Pitch3 = calllib('QBladeDLL','getCustomData_at_num',valuestr3, 0, 0); 

    PitchAngles(i_for2,:) = [Pitch1 Pitch2 Pitch3] ;

    waitbar(i_for2/simTime,f,'Simulation Running')

end
close(f)

calllib('QBladeDLL','closeInstance')
